/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.serialization.formats.newv;

import cn.regionsoft.one.serialization.formats.core.SeriziDataType;
import cn.regionsoft.one.serialization.formats.newv.StringFormat;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SeriliWorker {
    private Map<Class, Field[]> fieldsMap = new HashMap<Class, Field[]>();
    private ByteBuf threadBindBuf = ByteBufAllocator.DEFAULT.buffer(10);

    public Object deserialize(ByteBuf byteBuf, Class<?> targetClass) throws Exception {
        byte dataType = byteBuf.readByte();
        switch (dataType) {
            case 0: {
                return this.deserializeObject(byteBuf, targetClass);
            }
            case 1: {
                return StringFormat.getValFromSerialized(byteBuf, 4, byteBuf.readIntLE());
            }
        }
        return null;
    }

    private Object deserializeObject(ByteBuf byteBuf, Class<?> targetClass) throws Exception {
        Object instance = targetClass.newInstance();
        Field[] fields = this.fieldsMap.get(targetClass);
        if (fields == null) {
            for (Field tmp : fields = targetClass.getDeclaredFields()) {
                tmp.setAccessible(true);
            }
            this.fieldsMap.put(targetClass, fields);
        }
        for (Field tmp : fields) {
            tmp.set(instance, this.deserializeFieldObject(byteBuf, tmp.getType()));
        }
        return instance;
    }

    private Object deserializeFieldObject(ByteBuf byteBuf, Class<?> targetClass) throws Exception {
        byte dataType = byteBuf.readByte();
        switch (dataType) {
            case 0: {
                return this.deserializeObject(byteBuf, targetClass);
            }
            case 1: {
                return StringFormat.getValFromSerialized(byteBuf, 0, byteBuf.readIntLE());
            }
            case 10: {
                int length = byteBuf.readIntLE();
                if (length == 0) {
                    return null;
                }
                byte[] tmp = new byte[length];
                byteBuf.readBytes(tmp);
                return tmp;
            }
        }
        return null;
    }

    public ByteBuf serialize(Object obj) throws Exception {
        this.threadBindBuf.clear();
        return this.serialize(obj, this.threadBindBuf);
    }

    public ByteBuf serialize(Object obj, ByteBuf byteBuf) throws Exception {
        Field[] fields;
        Class<?> targetClass = obj.getClass();
        if (targetClass == String.class) {
            return StringFormat.getBytes((String)obj, byteBuf);
        }
        if (targetClass.isArray() || obj instanceof List || obj instanceof Map) {
            // empty if block
        }
        if ((fields = this.fieldsMap.get(targetClass)) == null) {
            for (Field tmp : fields = obj.getClass().getDeclaredFields()) {
                tmp.setAccessible(true);
            }
            this.fieldsMap.put(targetClass, fields);
        }
        byteBuf.writeByte((int)((byte)SeriziDataType.Class.ordinal()));
        for (Field tmp : fields) {
            Object val = tmp.get(obj);
            this.wrapFieldBytes(val, tmp.getType(), byteBuf);
        }
        return byteBuf;
    }

    public void wrapFieldBytes(Object obj, Class targetClass, ByteBuf byteBuf) throws Exception {
        if (targetClass == Object.class) {
            targetClass = obj.getClass();
        }
        if (targetClass.isArray()) {
            if ("[B".equals(targetClass.getName())) {
                if (obj != null) {
                    byte[] tmp = (byte[])obj;
                    byteBuf.writeByte(SeriziDataType.byteT.ordinal());
                    byteBuf.writeIntLE(tmp.length);
                    byteBuf.writeBytes(tmp);
                } else {
                    byteBuf.writeByte(SeriziDataType.byteT.ordinal());
                    byteBuf.writeIntLE(0);
                }
            }
            return;
        }
        if (targetClass == String.class) {
            StringFormat.wrapBytes((String)obj, byteBuf);
            return;
        }
        this.wrapObject(obj, targetClass, byteBuf);
    }

    private void wrapObject(Object obj, Class targetClass, ByteBuf byteBuf) throws Exception {
        Field[] fields = this.fieldsMap.get(targetClass);
        if (fields == null) {
            for (Field tmp : fields = obj.getClass().getDeclaredFields()) {
                tmp.setAccessible(true);
            }
            this.fieldsMap.put(targetClass, fields);
        }
        byteBuf.writeByte((int)((byte)SeriziDataType.Class.ordinal()));
        for (Field tmp : fields) {
            Object val = tmp.get(obj);
            this.wrapFieldBytes(val, tmp.getType(), byteBuf);
        }
    }
}

