/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.serialization.formats.newv;

public class MathUtil {
    public static byte[] unsignIntToBytes2(int intVal) {
        if (intVal < 0) {
            throw new RuntimeException("minus value is not allowed :" + intVal);
        }
        if (intVal == 0) {
            return new byte[]{-128};
        }
        if (intVal < 256) {
            return new byte[]{(byte)(intVal - 128)};
        }
        double tmpFloat = Math.log(intVal) / Math.log(256.0);
        double k = Math.ceil(tmpFloat);
        int sizeOfByte = k == tmpFloat ? (int)(k + 1.0) : (int)k;
        byte[] lengthByte = new byte[sizeOfByte];
        for (int i = 0; i < sizeOfByte; ++i) {
            int x = intVal / 256;
            int y = intVal % 256;
            lengthByte[sizeOfByte - 1 - i] = (byte)(y - 128);
            intVal = x;
        }
        return lengthByte;
    }

    public static int bytesToInt2(byte[] data, int readerIndex) {
        int result = 0;
        for (int i = readerIndex; i < readerIndex + 4; ++i) {
            result <<= 8;
            result += data[i] + 128;
        }
        return result;
    }

    public static byte[] intToBytes(int intVal) {
        if (intVal < 0) {
            if ((intVal = -intVal) < 256) {
                return new byte[]{1, (byte)(intVal - 128)};
            }
            double tmpFloat = Math.log(intVal) / Math.log(256.0);
            double k = Math.ceil(tmpFloat);
            int sizeOfByte = k == tmpFloat ? (int)(k + 1.0) : (int)k;
            byte[] lengthByte = new byte[++sizeOfByte];
            lengthByte[0] = 1;
            for (int i = 1; i < sizeOfByte; ++i) {
                int x = intVal / 256;
                int y = intVal % 256;
                lengthByte[sizeOfByte - i] = (byte)(y - 128);
                intVal = x;
            }
            return lengthByte;
        }
        return MathUtil.unsigneIntToBytes(intVal);
    }

    private static byte[] unsigneIntToBytes(int intVal) {
        if (intVal < 0) {
            throw new RuntimeException("minus value is not allowed :" + intVal);
        }
        if (intVal == 0) {
            return new byte[]{0, -128};
        }
        if (intVal < 256) {
            return new byte[]{0, (byte)(intVal - 128)};
        }
        double tmpFloat = Math.log(intVal) / Math.log(256.0);
        double k = Math.ceil(tmpFloat);
        int sizeOfByte = k == tmpFloat ? (int)(k + 1.0) : (int)k;
        byte[] lengthByte = new byte[++sizeOfByte];
        lengthByte[0] = 0;
        for (int i = 1; i < sizeOfByte; ++i) {
            int x = intVal / 256;
            int y = intVal % 256;
            lengthByte[sizeOfByte - i] = (byte)(y - 128);
            intVal = x;
        }
        return lengthByte;
    }

    public static int bytesToInt(byte[] bytes, int startIndex, int endIndex) {
        if (bytes == null) {
            throw new RuntimeException("bytes is null");
        }
        int result = 0;
        byte sign = bytes[startIndex];
        for (int i = startIndex + 1; i < endIndex; ++i) {
            result <<= 8;
            result += bytes[i] + 128;
        }
        if (sign == 0) {
            return result;
        }
        return -result;
    }

    public static long bytesToLong(byte[] bytes, int startIndex, int endIndex) {
        if (bytes == null) {
            throw new RuntimeException("bytes is null");
        }
        long result = 0L;
        byte sign = bytes[startIndex];
        for (int i = startIndex + 1; i < endIndex; ++i) {
            result <<= 8;
            result += (long)(bytes[i] + 128);
        }
        if (sign == 0) {
            return result;
        }
        return -result;
    }

    public static byte[] longToBytes(long longVal) {
        if (longVal < 0L) {
            if ((longVal = -longVal) < 256L) {
                return new byte[]{1, (byte)(longVal - 128L)};
            }
            double tmpFloat = Math.log(longVal) / Math.log(256.0);
            double k = Math.ceil(tmpFloat);
            int sizeOfByte = k == tmpFloat ? (int)(k + 1.0) : (int)k;
            byte[] lengthByte = new byte[++sizeOfByte];
            lengthByte[0] = 1;
            for (int i = 1; i < sizeOfByte; ++i) {
                long x = longVal / 256L;
                long y = longVal % 256L;
                lengthByte[sizeOfByte - i] = (byte)(y - 128L);
                longVal = x;
            }
            return lengthByte;
        }
        return MathUtil.unsigneLongToBytes(longVal);
    }

    private static byte[] unsigneLongToBytes(long longVal) {
        if (longVal < 0L) {
            throw new RuntimeException("minus value is not allowed :" + longVal);
        }
        if (longVal == 0L) {
            return new byte[]{0, -128};
        }
        if (longVal < 256L) {
            return new byte[]{0, (byte)(longVal - 128L)};
        }
        double tmpFloat = Math.log(longVal) / Math.log(256.0);
        double k = Math.ceil(tmpFloat);
        int sizeOfByte = k == tmpFloat ? (int)(k + 1.0) : (int)k;
        byte[] lengthByte = new byte[++sizeOfByte];
        lengthByte[0] = 0;
        for (int i = 1; i < sizeOfByte; ++i) {
            long x = longVal / 256L;
            long y = longVal % 256L;
            lengthByte[sizeOfByte - i] = (byte)(y - 128L);
            longVal = x;
        }
        return lengthByte;
    }
}

