/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.schedule;

import cn.regionsoft.one.annotation.Job;
import cn.regionsoft.one.common.Logger;
import cn.regionsoft.one.core.Assert;
import cn.regionsoft.one.core.CommonUtil;
import cn.regionsoft.one.schedule.JobClassMeta;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

public class ScheduleManager {
    private static final Logger logger = Logger.getLogger(ScheduleManager.class);
    private static ScheduleManager scheduleManager = null;
    private Scheduler scheduler = null;
    private ConcurrentHashMap<String, HashMap<String, JobClassMeta>> jobRegistry = new ConcurrentHashMap();
    private ConcurrentHashMap<String, JobClassMeta> jobMetaMap = new ConcurrentHashMap();

    private ScheduleManager() {
        try {
            StdSchedulerFactory schedulerFactory = new StdSchedulerFactory();
            this.scheduler = schedulerFactory.getScheduler();
            this.scheduler.start();
        }
        catch (Exception e) {
            logger.error(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ScheduleManager getInstance() {
        if (scheduleManager != null) return scheduleManager;
        Class<ScheduleManager> clazz = ScheduleManager.class;
        synchronized (ScheduleManager.class) {
            if (scheduleManager != null) return scheduleManager;
            scheduleManager = new ScheduleManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return scheduleManager;
        }
    }

    public synchronized void initNewJob(String jobName, String groupName, String corn, Method method, Object managedBean) throws Exception {
        Assert.notEmpty(corn, "corn is emtpy");
        JobClassMeta jobClassMeta = JobClassMeta.newJobClassMeta();
        jobClassMeta.setManagedBean(managedBean);
        jobClassMeta.setMethod(method);
        HashMap<String, JobClassMeta> groupJobMetas = this.jobRegistry.get(groupName);
        if (groupJobMetas == null) {
            groupJobMetas = new HashMap();
            this.jobRegistry.put(groupName, groupJobMetas);
            groupJobMetas.put(jobName, jobClassMeta);
        } else {
            JobClassMeta exsitJobClassMeta = groupJobMetas.get(jobName);
            if (exsitJobClassMeta != null) {
                throw new Exception("duplicate scheduled jobs are found: jobGroup=" + groupName + ",jobName=" + jobName + ". " + managedBean.getClass().getName() + "." + method.getName());
            }
            groupJobMetas.put(jobName, jobClassMeta);
        }
        JobDetail jobDetail = JobBuilder.newJob(jobClassMeta.getJobClass()).withIdentity(jobName, groupName).build();
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity("trigger_" + jobName, "trigger_" + groupName).startNow().withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)corn)).build();
        jobClassMeta.setJobKey(jobDetail.getKey());
        jobClassMeta.setTriggerKey(trigger.getKey());
        jobClassMeta.setGroupName(groupName);
        jobClassMeta.setJobName(jobName);
        this.scheduler.scheduleJob(jobDetail, trigger);
        this.jobMetaMap.put(jobClassMeta.getId().toString(), jobClassMeta);
    }

    public synchronized void initNewJob(Job job, Method method, Object managedBean) throws Exception {
        String corn = job.corn();
        String jobName = job.name();
        String groupName = job.group();
        if (CommonUtil.isEmpty(groupName)) {
            groupName = managedBean.getClass().getName();
        }
        if (CommonUtil.isEmpty(jobName)) {
            jobName = method.getName();
        }
        this.initNewJob(jobName, groupName, corn, method, managedBean);
    }

    public void excuteJob(String jobId) {
        JobClassMeta jobClassMeta = this.jobMetaMap.get(jobId);
        try {
            jobClassMeta.getMethod().invoke(jobClassMeta.getManagedBean(), new Object[0]);
        }
        catch (Exception e) {
            logger.error(e);
        }
    }
}

