/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.schedule;

import cn.regionsoft.one.core.ids.IDGenerator;
import java.lang.reflect.Method;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import org.quartz.Job;
import org.quartz.JobKey;
import org.quartz.TriggerKey;

public class JobClassMeta {
    private Long id;
    private Method method;
    private Object managedBean;
    private JobKey jobKey;
    private TriggerKey triggerKey;
    private String jobName;
    private String groupName;
    private Class<Job> jobClass;

    public TriggerKey getTriggerKey() {
        return this.triggerKey;
    }

    void setTriggerKey(TriggerKey triggerKey) {
        this.triggerKey = triggerKey;
    }

    public JobKey getJobKey() {
        return this.jobKey;
    }

    void setJobKey(JobKey jobKey) {
        this.jobKey = jobKey;
    }

    public String getJobName() {
        return this.jobName;
    }

    void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    void setJobClass(Class<Job> jobClass) {
        this.jobClass = jobClass;
    }

    public static JobClassMeta newJobClassMeta() throws Exception {
        Long jobClassId = IDGenerator.generateSnowflakeID();
        ClassPool pool = ClassPool.getDefault();
        CtClass cc = pool.makeClass("cn.regionsoft.one.schedule.jobs.RegionJob" + jobClassId);
        cc.addInterface(pool.get("org.quartz.Job"));
        StringBuilder methodBody = new StringBuilder("public void execute(org.quartz.JobExecutionContext context) throws org.quartz.JobExecutionException{");
        methodBody.append("cn.regionsoft.one.schedule.ScheduleManager.getInstance().excuteJob(\"" + jobClassId + "\");");
        methodBody.append("}");
        CtMethod m1 = CtMethod.make((String)methodBody.toString(), (CtClass)cc);
        cc.addMethod(m1);
        Class realClass = cc.toClass();
        cc.detach();
        JobClassMeta jobClassMeta = new JobClassMeta();
        jobClassMeta.id = jobClassId;
        jobClassMeta.jobClass = realClass;
        return jobClassMeta;
    }

    public Long getId() {
        return this.id;
    }

    public Class<Job> getJobClass() {
        return this.jobClass;
    }

    public Method getMethod() {
        return this.method;
    }

    void setMethod(Method method) {
        this.method = method;
    }

    public Object getManagedBean() {
        return this.managedBean;
    }

    void setManagedBean(Object managedBean) {
        this.managedBean = managedBean;
    }
}

