/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.rpc.server;

import cn.regionsoft.one.common.Logger;
import cn.regionsoft.one.core.CommonUtil;
import cn.regionsoft.one.core.RequestInfoHolder;
import cn.regionsoft.one.core.auth.dto.RequestInfoDto;
import cn.regionsoft.one.rpc.common.RpcRequest;
import cn.regionsoft.one.rpc.common.RpcResponse;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.HashMap;
import java.util.Map;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;

public class RpcHandler
extends SimpleChannelInboundHandler<RpcRequest> {
    private static final Logger logger = Logger.getLogger(RpcHandler.class);
    private final Map<String, Object> handlerMap;
    private HashMap<String, FastClass> fastClassCache = new HashMap();

    public RpcHandler(Map<String, Object> handlerMap) {
        this.handlerMap = handlerMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead0(ChannelHandlerContext ctx, RpcRequest request) throws Exception {
        RpcResponse response = new RpcResponse();
        response.setRequestId(request.getRequestId());
        RequestInfoDto requestInfo = new RequestInfoDto();
        requestInfo.setRequestId(request.getRequestId());
        requestInfo.setLocale(request.getLocale());
        RequestInfoHolder.getInstance().setRequestInfo(requestInfo);
        try {
            String registerPath = request.getRegisterPath();
            Object serviceBean = this.handlerMap.get(registerPath);
            String methodName = request.getMethodName();
            Class[] parameterTypes = request.getParameterTypes();
            Object[] parameters = request.getParameters();
            Class<?> serviceClass = serviceBean.getClass();
            FastClass serviceFastClass = this.fastClassCache.get(serviceClass.getName());
            if (serviceFastClass == null) {
                Class<?> clazz = serviceClass;
                synchronized (clazz) {
                    if (serviceFastClass == null) {
                        serviceFastClass = FastClass.create(serviceClass);
                        this.fastClassCache.put(serviceClass.getName(), serviceFastClass);
                    }
                }
            }
            FastMethod serviceFastMethod = serviceFastClass.getMethod(methodName, parameterTypes);
            Object result = serviceFastMethod.invoke(serviceBean, parameters);
            response.setResult(result);
            ctx.writeAndFlush((Object)response);
        }
        catch (Throwable t) {
            logger.error(t);
            response.setResult(CommonUtil.getStackTrace(t));
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        logger.error(cause);
        ctx.close();
    }
}

