/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.rpc.server;

import cn.regionsoft.one.common.Logger;
import cn.regionsoft.one.rpc.client.MicrosvcManager;
import cn.regionsoft.one.rpc.common.RpcDecoder;
import cn.regionsoft.one.rpc.common.RpcEncoder;
import cn.regionsoft.one.rpc.common.RpcRequest;
import cn.regionsoft.one.rpc.common.RpcResponse;
import cn.regionsoft.one.rpc.server.RpcHandler;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.ResourceLeakDetector;
import java.util.Iterator;
import java.util.Map;

public class RPCServer {
    private static final Logger logger = Logger.getLogger(RPCServer.class);
    private static RPCServer instance;
    private static EventLoopGroup bossGroup;
    private static EventLoopGroup workerGroup;

    private RPCServer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RPCServer getInstance() {
        if (instance != null) return instance;
        Class<RPCServer> clazz = RPCServer.class;
        synchronized (RPCServer.class) {
            if (instance != null) return instance;
            instance = new RPCServer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startSvc(String serverAddress, MicrosvcManager microsvcManager) {
        final Map<String, Object> handlerMap = microsvcManager.getRpcHandlerMap();
        String[] array = serverAddress.split(":");
        String host = array[0];
        int port = Integer.parseInt(array[1]);
        Iterator<String> iterator = handlerMap.keySet().iterator();
        while (iterator.hasNext()) {
            microsvcManager.getZooKeeperManager().regService(iterator.next(), serverAddress);
        }
        try {
            ServerBootstrap b = new ServerBootstrap();
            if (Epoll.isAvailable()) {
                ((ServerBootstrap)b.group(bossGroup, workerGroup).channel(EpollServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<EpollSocketChannel>(){

                    public void initChannel(EpollSocketChannel ch) throws Exception {
                        ch.pipeline().addLast(new ChannelHandler[]{new RpcDecoder(RpcRequest.class)});
                        ch.pipeline().addLast(new ChannelHandler[]{new RpcEncoder(RpcResponse.class)});
                        ch.pipeline().addLast(new ChannelHandler[]{new RpcHandler(handlerMap)});
                    }
                });
                b.option(EpollChannelOption.SO_REUSEPORT, (Object)true);
            } else {
                ((ServerBootstrap)b.group(bossGroup, workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<NioSocketChannel>(){

                    public void initChannel(NioSocketChannel ch) throws Exception {
                        ch.pipeline().addLast(new ChannelHandler[]{new RpcDecoder(RpcRequest.class)});
                        ch.pipeline().addLast(new ChannelHandler[]{new RpcEncoder(RpcResponse.class)});
                        ch.pipeline().addLast(new ChannelHandler[]{new RpcHandler(handlerMap)});
                    }
                });
            }
            b.option(ChannelOption.SO_BACKLOG, (Object)8192);
            b.option(ChannelOption.SO_REUSEADDR, (Object)true);
            b.option(ChannelOption.SO_RCVBUF, (Object)262144);
            b.option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
            b.option(ChannelOption.SO_KEEPALIVE, (Object)true);
            b.childOption(ChannelOption.SO_REUSEADDR, (Object)true);
            b.childOption(ChannelOption.SO_RCVBUF, (Object)262144);
            b.childOption(ChannelOption.SO_SNDBUF, (Object)262144);
            b.childOption(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(0x100000, 0x200000));
            b.childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
            b.childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
            b.bind(port).sync();
            logger.debug("RPC Server listening on " + port + " ...");
        }
        catch (InterruptedException e) {
            logger.error(e);
        }
        finally {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                bossGroup.shutdownGracefully();
                workerGroup.shutdownGracefully();
            }));
        }
    }

    static {
        ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.DISABLED);
        bossGroup = null;
        workerGroup = null;
        if (Epoll.isAvailable()) {
            bossGroup = new EpollEventLoopGroup(1);
            workerGroup = new EpollEventLoopGroup();
        } else {
            bossGroup = new NioEventLoopGroup(1);
            workerGroup = new NioEventLoopGroup();
        }
    }
}

