/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.rpc.common;

import cn.regionsoft.one.rpc.common.RpcRequest;
import io.protostuff.LinkedBuffer;
import io.protostuff.ProtobufIOUtil;
import io.protostuff.Schema;
import io.protostuff.runtime.RuntimeSchema;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.objenesis.Objenesis;
import org.objenesis.ObjenesisStd;

public class SerializationUtil {
    private static Map<Class<?>, Schema<?>> cachedSchema = new ConcurrentHashMap();
    private static Objenesis objenesis = new ObjenesisStd(true);
    private static ThreadLocal<LinkedBuffer> threadLinkedBuffer = new ThreadLocal();

    private SerializationUtil() {
    }

    private static <T> Schema<T> getSchema(Class<T> cls) {
        RuntimeSchema schema = cachedSchema.get(cls);
        if (schema == null && (schema = RuntimeSchema.createFrom(cls)) != null) {
            cachedSchema.put(cls, (Schema<?>)schema);
        }
        return schema;
    }

    public static <T> byte[] serialize(T obj) {
        Class<?> cls = obj.getClass();
        LinkedBuffer buffer = threadLinkedBuffer.get();
        if (buffer == null) {
            buffer = LinkedBuffer.allocate((int)512);
            threadLinkedBuffer.set(buffer);
        } else {
            buffer.clear();
        }
        try {
            Schema<?> schema = SerializationUtil.getSchema(cls);
            return ProtobufIOUtil.toByteArray(obj, schema, (LinkedBuffer)buffer);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public static <T> T deserialize(byte[] data, Class<T> cls) {
        try {
            Object message = objenesis.newInstance(cls);
            Schema<T> schema = SerializationUtil.getSchema(cls);
            ProtobufIOUtil.mergeFrom((byte[])data, (Object)message, schema);
            return (T)message;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public static <T> T deserializeFromStream(InputStream in, Class<T> cls) {
        try {
            Object message = objenesis.newInstance(cls);
            Schema<T> schema = SerializationUtil.getSchema(cls);
            ProtobufIOUtil.mergeFrom((InputStream)in, (Object)message, schema);
            return (T)message;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public static <T> void serializeToStream(T obj, OutputStream out) {
        Class<?> cls = obj.getClass();
        LinkedBuffer buffer = threadLinkedBuffer.get();
        if (buffer == null) {
            buffer = LinkedBuffer.allocate((int)512);
            threadLinkedBuffer.set(buffer);
        } else {
            buffer.clear();
        }
        try {
            Schema<?> schema = SerializationUtil.getSchema(cls);
            ProtobufIOUtil.writeTo((OutputStream)out, obj, schema, (LinkedBuffer)buffer);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public static void main(String[] args) throws InstantiationException, IllegalAccessException {
        RpcRequest a = new RpcRequest();
        a.setRegisterPath("sadfasdf");
        a.setMethodName("sdfasdfsdf");
        long time = System.currentTimeMillis();
        for (int i = 0; i < 600000; ++i) {
            SerializationUtil.deserialize(SerializationUtil.serialize(a), RpcRequest.class);
        }
        System.out.println(System.currentTimeMillis() - time);
    }
}

