/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.rpc.common;

import cn.regionsoft.one.rpc.common.SerializationUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.io.InputStream;
import java.util.List;

public class RpcDecoder
extends ByteToMessageDecoder {
    private Class<?> genericClass;

    public RpcDecoder(Class<?> genericClass) {
        this.genericClass = genericClass;
    }

    public final void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (in.readableBytes() < 4) {
            return;
        }
        in.markReaderIndex();
        int dataLength = in.readInt();
        if (dataLength < 0) {
            ctx.close();
        }
        if (in.readableBytes() < dataLength) {
            in.resetReaderIndex();
        } else {
            ByteBufInputStream bis = new ByteBufInputStream(in);
            Object obj = SerializationUtil.deserializeFromStream((InputStream)bis, this.genericClass);
            out.add(obj);
            bis.close();
        }
    }
}

