/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.rpc.client;

import cn.regionsoft.one.assist.aop.interfaces.Interceptor;
import cn.regionsoft.one.assist.aop.interfaces.InterfaceProxyAssist;
import cn.regionsoft.one.common.Logger;
import cn.regionsoft.one.core.RequestInfoHolder;
import cn.regionsoft.one.rpc.client.MicrosvcManager;
import cn.regionsoft.one.rpc.client.RemoteInvocationHandler;
import cn.regionsoft.one.rpc.client.RpcClient;
import cn.regionsoft.one.rpc.client.RpcClientPool;
import cn.regionsoft.one.rpc.common.ParaUtil;
import cn.regionsoft.one.rpc.common.RpcRequest;
import cn.regionsoft.one.rpc.common.RpcResponse;
import cn.regionsoft.one.web.core.ResProxy;
import io.netty.channel.Channel;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.text.MessageFormat;

public class RpcProxy
implements ResProxy {
    private static final Logger logger = Logger.getLogger(RpcProxy.class);
    private MicrosvcManager microsvcManager;
    private RpcClientPool rpcClientPool = null;
    public static String DELIMETER = ":";
    private boolean useJdkProxy = true;
    private static final String SERVICE_NOT_FOUND = "microsvcManager is null";
    private static final String NO_REMOTE_SERVICE_FOUND = "No remote service found in service registration server:{0}  , path : {1}";

    public RpcProxy(MicrosvcManager microsvcManager) {
        this.microsvcManager = microsvcManager;
        this.rpcClientPool = new RpcClientPool(2 * Runtime.getRuntime().availableProcessors() + 1);
    }

    @Override
    public <T> T create(Class<?> interfaceClass, final String registerPath) {
        if (!this.useJdkProxy) {
            try {
                return (T)InterfaceProxyAssist.proxyInterface(interfaceClass, new Interceptor(){

                    @Override
                    public void beforeInvoke() {
                    }

                    @Override
                    public Object invoke(Class withinClass, String methodName, Class<?>[] parameterTypes, Object[] parameters) {
                        try {
                            RpcRequest request = new RpcRequest();
                            request.setRequestId(RequestInfoHolder.getInstance().getRequestInfo().getRequestId());
                            request.setLocale(RequestInfoHolder.getInstance().getRequestInfo().getLocale());
                            request.setRegisterPath(withinClass.getName());
                            request.setMethodName(methodName);
                            byte[] paraBytes = null;
                            if (parameters != null && parameters.length > 0) {
                                paraBytes = ParaUtil.getBytes(parameters, parameterTypes);
                            }
                            if (RpcProxy.this.microsvcManager == null) {
                                throw new Exception(RpcProxy.SERVICE_NOT_FOUND);
                            }
                            String serverAddress = RpcProxy.this.microsvcManager.discover(registerPath);
                            if (serverAddress == null) {
                                throw new Exception(MessageFormat.format(RpcProxy.NO_REMOTE_SERVICE_FOUND, RpcProxy.this.microsvcManager.getZkConectStr(), registerPath));
                            }
                            RpcClient rpcClient = RpcProxy.this.rpcClientPool.getClient(serverAddress);
                            Channel channel = rpcClient.send(request);
                            RpcResponse rpcResponse = rpcClient.getResponse(channel);
                            return rpcResponse.getResult();
                        }
                        catch (Throwable e) {
                            logger.error(e);
                            return null;
                        }
                    }

                    @Override
                    public void afterInvoke() {
                    }
                });
            }
            catch (Exception e) {
                logger.debug(e);
                return null;
            }
        }
        return (T)Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)new RemoteInvocationHandler(interfaceClass, registerPath, this.microsvcManager, this.rpcClientPool));
    }
}

