/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.rpc.client;

import cn.regionsoft.one.common.Logger;
import cn.regionsoft.one.rpc.client.RpcClient;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;

public class RpcClientPool {
    private static final Logger logger = Logger.getLogger(RpcClientPool.class);
    private Map<String, RpcClient> clientMap = new ConcurrentHashMap<String, RpcClient>();
    private Integer poolSizePerServer;
    private Semaphore semaphore = new Semaphore(1);
    public static String DELIMETER = ":";

    public RpcClientPool(Integer poolSizePerServer) {
        if (poolSizePerServer == null) {
            poolSizePerServer = 1;
        }
        this.poolSizePerServer = poolSizePerServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RpcClient getClient(String serverAddress) {
        try {
            RpcClient client = this.clientMap.get(serverAddress);
            if (client == null) {
                try {
                    this.semaphore.acquire();
                    client = this.clientMap.get(serverAddress);
                    if (client == null) {
                        String[] array = serverAddress.split(DELIMETER);
                        String host = array[0];
                        int port = Integer.parseInt(array[1]);
                        client = new RpcClient(host, port);
                        this.clientMap.put(serverAddress, client);
                    }
                }
                finally {
                    this.semaphore.release();
                }
            }
            return client;
        }
        catch (Exception e) {
            logger.error(e);
            return null;
        }
    }

    public Integer getPoolSizePerServer() {
        return this.poolSizePerServer;
    }
}

