/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.rpc.client;

import cn.regionsoft.one.common.Logger;
import cn.regionsoft.one.rpc.client.RpcClient;
import cn.regionsoft.one.rpc.common.RpcResponse;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.UUID;
import java.util.concurrent.Semaphore;

public class RpcClientHandler
extends SimpleChannelInboundHandler<RpcResponse> {
    private static final Logger logger = Logger.getLogger(RpcClientHandler.class);
    private RpcClient rpcClient;

    public RpcClientHandler(RpcClient rpcClient) {
        this.rpcClient = rpcClient;
    }

    public void channelRead0(ChannelHandlerContext ctx, RpcResponse response) throws Exception {
        Channel channel = ctx.channel();
        channel.attr(RpcClient.CHANNEL_RESPONSE).set((Object)response);
        ((Semaphore)channel.attr(RpcClient.CHANNEL_RESPONSE_READABLE).get()).release();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.error("client caught exception", cause);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        logger.debug("RPC Server disconnected");
        ctx.channel().attr(RpcClient.CHANNEL_UUID).set(null);
        this.rpcClient.connectNewChannel();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        if (!ctx.channel().hasAttr(RpcClient.CHANNEL_UUID)) {
            ctx.channel().attr(RpcClient.CHANNEL_UUID).set((Object)UUID.randomUUID().toString());
        }
        String uuid = (String)ctx.channel().attr(RpcClient.CHANNEL_UUID).get();
        logger.debug("client" + RpcClientHandler.getRemoteAddress(ctx) + " connected, clientId=" + uuid);
        ctx.channel().attr(RpcClient.CHANNEL_RESPONSE_READABLE).set((Object)new Semaphore(0));
    }

    public static String getRemoteAddress(ChannelHandlerContext ctx) {
        return ctx.channel().remoteAddress().toString();
    }
}

