/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.rpc.client;

import cn.regionsoft.one.common.Logger;
import cn.regionsoft.one.rpc.client.RpcClientHandler;
import cn.regionsoft.one.rpc.common.RpcDecoder;
import cn.regionsoft.one.rpc.common.RpcEncoder;
import cn.regionsoft.one.rpc.common.RpcRequest;
import cn.regionsoft.one.rpc.common.RpcResponse;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.AttributeKey;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;

public class RpcClient {
    private static final Logger logger = Logger.getLogger(RpcClient.class);
    private static EventLoopGroup group = null;
    public static AttributeKey<String> CHANNEL_UUID;
    public static AttributeKey<RpcResponse> CHANNEL_RESPONSE;
    public static AttributeKey<Semaphore> CHANNEL_RESPONSE_READABLE;
    private String host;
    private int port;
    private Bootstrap bootstrap = new Bootstrap();
    private String serverAddr = null;
    private int activeChannelCount = Runtime.getRuntime().availableProcessors() * 2 + 1;
    private BlockingQueue<Channel> activeChannels = new LinkedBlockingQueue<Channel>();

    public RpcClient(String host, int port) {
        this.host = host;
        this.port = port;
        this.serverAddr = host + ":" + port;
        this.init();
    }

    public String getServerAddr() {
        return this.serverAddr;
    }

    private void init() {
        try {
            if (Epoll.isAvailable()) {
                ((Bootstrap)((Bootstrap)this.bootstrap.group(group)).channel(EpollSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<EpollSocketChannel>(){

                    public void initChannel(EpollSocketChannel channel) throws Exception {
                        channel.pipeline().addLast(new ChannelHandler[]{new RpcEncoder(RpcRequest.class)});
                        channel.pipeline().addLast(new ChannelHandler[]{new RpcDecoder(RpcResponse.class)});
                        channel.pipeline().addLast(new ChannelHandler[]{new RpcClientHandler(RpcClient.this)});
                    }
                });
                this.bootstrap.option(EpollChannelOption.SO_REUSEPORT, (Object)true);
            } else {
                ((Bootstrap)((Bootstrap)this.bootstrap.group(group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<NioSocketChannel>(){

                    public void initChannel(NioSocketChannel channel) throws Exception {
                        channel.pipeline().addLast(new ChannelHandler[]{new RpcEncoder(RpcRequest.class)});
                        channel.pipeline().addLast(new ChannelHandler[]{new RpcDecoder(RpcResponse.class)});
                        channel.pipeline().addLast(new ChannelHandler[]{new RpcClientHandler(RpcClient.this)});
                    }
                });
            }
            this.bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)true);
            this.bootstrap.option(ChannelOption.SO_RCVBUF, (Object)256);
            this.bootstrap.option(ChannelOption.SO_SNDBUF, (Object)256);
            this.bootstrap.option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(32768, 65536));
            this.bootstrap.option(ChannelOption.SO_BACKLOG, (Object)256);
            this.bootstrap.option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
            this.bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true);
            for (int i = 0; i < this.activeChannelCount; ++i) {
                Channel channel = this.bootstrap.connect(this.host, this.port).sync().channel();
                this.activeChannels.add(channel);
            }
        }
        catch (Exception e) {
            logger.error(e);
        }
        finally {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                Iterator iterator = this.activeChannels.iterator();
                while (iterator.hasNext()) {
                    ((Channel)iterator.next()).close();
                }
                group.shutdownGracefully();
            }));
        }
    }

    public void connectNewChannel() {
        boolean connected = false;
        while (!connected) {
            logger.debug("reconnecting...");
            try {
                Channel channel = this.bootstrap.connect(this.host, this.port).sync().channel();
                this.activeChannels.add(channel);
            }
            catch (Exception e) {
                logger.debug("connect failed...");
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public Channel send(RpcRequest request) throws Exception {
        Channel channel = this.activeChannels.take();
        String channelUUID = (String)channel.attr(CHANNEL_UUID).get();
        while (channelUUID == null) {
            channel = this.activeChannels.take();
            channelUUID = (String)channel.attr(CHANNEL_UUID).get();
        }
        channel.writeAndFlush((Object)request);
        return channel;
    }

    public RpcResponse getResponse(Channel channel) throws InterruptedException {
        ((Semaphore)channel.attr(CHANNEL_RESPONSE_READABLE).get()).acquire();
        RpcResponse rpcResponse = (RpcResponse)channel.attr(CHANNEL_RESPONSE).get();
        this.activeChannels.add(channel);
        return rpcResponse;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    static {
        group = Epoll.isAvailable() ? new EpollEventLoopGroup(0, (ThreadFactory)new DefaultThreadFactory(EpollEventLoopGroup.class)) : new NioEventLoopGroup(0, (ThreadFactory)new DefaultThreadFactory(NioEventLoopGroup.class));
        CHANNEL_UUID = AttributeKey.valueOf((String)"channel_uuid");
        CHANNEL_RESPONSE = AttributeKey.valueOf((String)"channel_response");
        CHANNEL_RESPONSE_READABLE = AttributeKey.valueOf((String)"channel_semaphore");
        ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.DISABLED);
    }
}

