/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.rpc.client;

import cn.regionsoft.one.common.Logger;
import cn.regionsoft.one.properties.ConfigUtil;
import cn.regionsoft.one.rpc.client.RpcProxy;
import cn.regionsoft.one.rpc.server.RPCServer;
import cn.regionsoft.one.zookeeper.ZooKeeperManager;
import io.netty.util.internal.ThreadLocalRandom;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;

public class MicrosvcManager {
    public static Logger logger = Logger.getLogger(MicrosvcManager.class);
    private CountDownLatch latch = new CountDownLatch(1);
    private ConcurrentHashMap<String, List<String>> registedServicePaths = new ConcurrentHashMap();
    private String zkConectStr;
    private RpcProxy rpcProxy = null;
    private Map<String, Object> rpcHandlerMap = new HashMap<String, Object>();
    private ZooKeeperManager zooKeeperManager;
    private int consumerCount = 0;
    private int providerCount = 0;

    public RpcProxy getRpcProxy() {
        return this.rpcProxy;
    }

    public void setRpcProxy(RpcProxy rpcProxy) {
        this.rpcProxy = rpcProxy;
    }

    public MicrosvcManager(String zkConectStr) {
        this.zkConectStr = zkConectStr;
    }

    public void plusConsumer() {
        ++this.consumerCount;
    }

    public void plusProvider() {
        ++this.providerCount;
    }

    public int getConsumerCount() {
        return this.consumerCount;
    }

    public int getProviderCount() {
        return this.providerCount;
    }

    public String discover(String servicePath) {
        try {
            return this.getServiceNode(servicePath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getServiceNode(String servicePath) {
        String data = null;
        List<String> dataList = this.registedServicePaths.get(servicePath);
        int size = dataList.size();
        if (size > 0) {
            data = size == 1 ? dataList.get(0) : dataList.get(ThreadLocalRandom.current().nextInt(size));
        }
        return data;
    }

    private ZooKeeper connectServer() {
        ZooKeeper zk = null;
        try {
            zk = new ZooKeeper(this.zkConectStr, 5000, new Watcher(){

                public void process(WatchedEvent event) {
                    if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
                        MicrosvcManager.this.latch.countDown();
                    }
                }
            });
            this.latch.await();
        }
        catch (IOException e) {
            logger.error(e);
        }
        catch (InterruptedException e) {
            logger.error(e);
        }
        return zk;
    }

    public void startWatchServices() {
        ZooKeeper zk = this.connectServer();
        if (zk != null) {
            this.watchNodes(zk);
        }
    }

    public Map<String, Object> getRpcHandlerMap() {
        return this.rpcHandlerMap;
    }

    private void watchNodes(ZooKeeper zk) {
        Enumeration<String> bindServices = this.registedServicePaths.keys();
        while (bindServices.hasMoreElements()) {
            this.watchNode(zk, bindServices.nextElement());
        }
    }

    private void watchNode(final ZooKeeper zk, final String servicePath) {
        try {
            List nodeList = zk.getChildren(servicePath, new Watcher(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void process(WatchedEvent event) {
                    if (event.getType() == Watcher.Event.EventType.NodeChildrenChanged) {
                        try {
                            String string = servicePath.intern();
                            synchronized (string) {
                                MicrosvcManager.this.watchNode(zk, servicePath);
                            }
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            });
            ArrayList<String> dataList = new ArrayList<String>();
            for (String node : nodeList) {
                byte[] bytes = zk.getData(servicePath + "/" + node, false, null);
                dataList.add(new String(bytes));
            }
            logger.debug("refresh node data:", dataList);
            this.registedServicePaths.put(servicePath, dataList);
        }
        catch (KeeperException e) {
            logger.error(new Object[]{"", e});
        }
        catch (InterruptedException e) {
            logger.error("", e);
        }
    }

    public void registerConsumer(String path) {
        if (this.registedServicePaths.containsKey(path)) {
            return;
        }
        this.registedServicePaths.put(path, new ArrayList());
    }

    public String getZkConectStr() {
        return this.zkConectStr;
    }

    public ZooKeeperManager getZooKeeperManager() {
        return this.zooKeeperManager;
    }

    public void startMicroSvcServer() {
        String rsMicrosvcEndpoint = ConfigUtil.getProperty("rs.microsvc.endpoint");
        String zkConectStr = ConfigUtil.getProperty("rs.microsvc.zookeepers");
        this.zooKeeperManager = new ZooKeeperManager(zkConectStr);
        RPCServer.getInstance().startSvc(rsMicrosvcEndpoint, this);
    }
}

