/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.httpserver;

import cn.regionsoft.one.core.CommonUtil;
import cn.regionsoft.one.httpserver.FileChangeListener;
import cn.regionsoft.one.httpserver.HttpFileServerHandler;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.AdaptiveRecvByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.net.InetAddress;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;

public class SimpleHtmlServer {
    private ConcurrentHashMap<String, byte[]> resMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> contentTypeMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Long> lastModifiedMap = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runHttp(int port, final String context, final String baseDoc) throws Exception {
        if (CommonUtil.isEmpty(context) || CommonUtil.isEmpty(baseDoc)) {
            return;
        }
        System.out.println("\u524d\u7aef\u670d\u52a1\u5730\u5740\uff1a http://" + InetAddress.getLocalHost().getHostAddress() + ":" + port + context + "/index.html");
        NioEventLoopGroup bossGroup = new NioEventLoopGroup();
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline pipeline = ch.pipeline();
                    pipeline.addLast(new ChannelHandler[]{new HttpRequestDecoder()});
                    pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)});
                    pipeline.addLast(new ChannelHandler[]{new HttpResponseEncoder()});
                    pipeline.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
                    pipeline.addLast(new ChannelHandler[]{new HttpContentCompressor()});
                    pipeline.addLast(new ChannelHandler[]{new HttpFileServerHandler(context, baseDoc, SimpleHtmlServer.this.resMap, SimpleHtmlServer.this.contentTypeMap, SimpleHtmlServer.this.lastModifiedMap)});
                }
            }).option(ChannelOption.SO_BACKLOG, (Object)256)).option(ChannelOption.RCVBUF_ALLOCATOR, (Object)new AdaptiveRecvByteBufAllocator())).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
            FileChangeListener fileChangeListener = new FileChangeListener(baseDoc, this.resMap, this.contentTypeMap, this.lastModifiedMap);
            fileChangeListener.start();
            ChannelFuture channelFuture = b.bind(port).sync();
        }
        finally {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> SimpleHtmlServer.lambda$runHttp$0((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runHttps(int port, final String context, final String baseDoc, final KeyManagerFactory kmf) throws Exception {
        if (CommonUtil.isEmpty(context) || CommonUtil.isEmpty(baseDoc)) {
            return;
        }
        System.out.println("Html\u670d\u52a1\u5730\u5740\uff1a https://" + InetAddress.getLocalHost().getHostAddress() + ":" + port + context + "/index.html");
        NioEventLoopGroup bossGroup = new NioEventLoopGroup();
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline pipeline = ch.pipeline();
                    if (kmf != null) {
                        SSLContext sslcontext = SSLContext.getInstance("TLS");
                        sslcontext.init(kmf.getKeyManagers(), null, null);
                        SSLEngine sslEngine = sslcontext.createSSLEngine();
                        sslEngine.setUseClientMode(false);
                        sslEngine.setNeedClientAuth(false);
                        pipeline.addLast(new ChannelHandler[]{new SslHandler(sslEngine)});
                    }
                    pipeline.addLast(new ChannelHandler[]{new HttpRequestDecoder()});
                    pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)});
                    pipeline.addLast(new ChannelHandler[]{new HttpResponseEncoder()});
                    pipeline.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
                    pipeline.addLast(new ChannelHandler[]{new HttpFileServerHandler(context, baseDoc, SimpleHtmlServer.this.resMap, SimpleHtmlServer.this.contentTypeMap, SimpleHtmlServer.this.lastModifiedMap)});
                }
            }).option(ChannelOption.SO_BACKLOG, (Object)256)).option(ChannelOption.RCVBUF_ALLOCATOR, (Object)new AdaptiveRecvByteBufAllocator())).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
            ChannelFuture channelFuture = b.bind(port).sync();
        }
        finally {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> SimpleHtmlServer.lambda$runHttps$1((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup)));
        }
    }

    public static void main(String[] args) throws Exception {
        String htmlContext = "/MorcbleFrontend";
        String baseDoc = "/home/fenglj/devspace/myprojects/Morcble/MorcbleFrontend/src/main/webapp";
        new SimpleHtmlServer().runHttp(8888, htmlContext, baseDoc);
    }

    private static /* synthetic */ void lambda$runHttps$1(EventLoopGroup bossGroup, EventLoopGroup workerGroup) {
        bossGroup.shutdownGracefully();
        workerGroup.shutdownGracefully();
    }

    private static /* synthetic */ void lambda$runHttp$0(EventLoopGroup bossGroup, EventLoopGroup workerGroup) {
        bossGroup.shutdownGracefully();
        workerGroup.shutdownGracefully();
    }
}

