/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.httpserver;

import cn.regionsoft.one.core.CommonUtil;
import cn.regionsoft.one.enums.LocaleStr;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import javax.activation.MimetypesFileTypeMap;

public class HttpFileServerHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private final String context;
    private final String baseDoc;
    private ConcurrentHashMap<String, byte[]> resMap;
    private ConcurrentHashMap<String, String> contentTypeMap;
    private ConcurrentHashMap<String, Long> lastModifiedMap;
    private static final String T1 = "?";
    private static final String T2 = "/";
    private static final String LAST_MODIFIED = "last-modified";
    private static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    private static final String UTF_8 = "UTF-8";
    private static final String _CSS = ".css";
    private static final String _JS = ".js";
    private static final String TEXT_CSS = "text/css";
    private static final String APPLICATION_JAVASCRIPT = "application/javascript";

    public HttpFileServerHandler(String context, String baseDoc, ConcurrentHashMap<String, byte[]> resMap, ConcurrentHashMap<String, String> contentTypeMap, ConcurrentHashMap<String, Long> lastModifiedMap) {
        this.context = context;
        this.baseDoc = baseDoc;
        this.resMap = resMap;
        this.contentTypeMap = contentTypeMap;
        this.lastModifiedMap = lastModifiedMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest request) throws Exception {
        block31: {
            block28: {
                keepAlive = false;
                if (!request.decoderResult().isSuccess()) {
                    HttpFileServerHandler.sendError(ctx, HttpResponseStatus.BAD_REQUEST);
                    if (keepAlive != false) return;
                }
                ** GOTO lbl-1000
                ctx.close();
                return;
lbl-1000:
                // 1 sources

                {
                    if (request.method() == HttpMethod.GET) ** GOTO lbl-1000
                    HttpFileServerHandler.sendError(ctx, HttpResponseStatus.METHOD_NOT_ALLOWED);
                    if (keepAlive != false) return;
                }
                ctx.close();
                return;
lbl-1000:
                // 1 sources

                {
                    uri = request.uri();
                    index = uri.indexOf("?");
                    if (index != -1) {
                        uri = uri.substring(0, index);
                    }
                    if ((path = this.sanitizeUri(uri)) != null) ** GOTO lbl-1000
                    HttpFileServerHandler.sendError(ctx, HttpResponseStatus.FORBIDDEN);
                    if (keepAlive != false) return;
                }
                ctx.close();
                return;
lbl-1000:
                // 1 sources

                {
                    keepAlive = HttpUtil.isKeepAlive((HttpMessage)request);
                    accessFirstTime = true;
                    lastSince = request.headers().get("If-Modified-Since");
                    if (!CommonUtil.isEmpty(lastSince)) {
                        accessFirstTime = false;
                    }
                    if ((cached = this.resMap.get(path)) != null) break block28;
                    var10_10 = path.intern();
                    synchronized (var10_10) {
                        if (cached != null) break block29;
                        file = new File(path);
                        if (!file.isDirectory()) ** break block30
                        HttpFileServerHandler.sendError(ctx, HttpResponseStatus.NOT_FOUND);
                    }
                    if (keepAlive != false) return;
                }
                ctx.close();
                return;
                {
                    block29: {
                        if (file.isHidden() || !file.exists()) {
                            HttpFileServerHandler.sendError(ctx, HttpResponseStatus.NOT_FOUND);
                            // MONITOREXIT @DISABLED, blocks:[24, 12] lbl48 : MonitorExitStatement: MONITOREXIT : var10_10
                            if (keepAlive != false) return;
                            ctx.close();
                            return;
                        }
                        if (!file.isFile()) {
                            HttpFileServerHandler.sendError(ctx, HttpResponseStatus.FORBIDDEN);
                            // MONITOREXIT @DISABLED, blocks:[23, 12] lbl55 : MonitorExitStatement: MONITOREXIT : var10_10
                            if (keepAlive != false) return;
                            ctx.close();
                            return;
                        }
                        randomAccessFile = null;
                        try {
                            randomAccessFile = new RandomAccessFile(file, "r");
                        }
                        catch (FileNotFoundException fnfd) {
                            HttpFileServerHandler.sendError(ctx, HttpResponseStatus.NOT_FOUND);
                            // MONITOREXIT @DISABLED, blocks:[12, 13] lbl66 : MonitorExitStatement: MONITOREXIT : var10_10
                            if (keepAlive != false) return;
                            ctx.close();
                            return;
                        }
                        ** try [egrp 9[TRYBLOCK] [14 : 346->713)] { 
lbl72:
                        // 1 sources

                        fileLength = randomAccessFile.length();
                        response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
                        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)fileLength);
                        contentType = HttpFileServerHandler.getContentTypeHeader(file);
                        this.contentTypeMap.put(path, contentType);
                        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
                        if (HttpUtil.isKeepAlive((HttpMessage)request)) {
                            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
                        }
                        buffer = new byte[(int)fileLength];
                        randomAccessFile.readFully(buffer);
                        this.resMap.put(path, buffer);
                        response.content().writeBytes(buffer);
                        lastModifiedDt = file.lastModified();
                        response.headers().set("last-modified", (Object)new Date(lastModifiedDt));
                        this.lastModifiedMap.put(path, lastModifiedDt);
                        ctx.write((Object)response);
                    }
                    break block31;
                }
            }
            response = null;
            pageChanged = false;
            if (!CommonUtil.isEmpty(lastSince)) {
                sdf = CommonUtil.getSimpleDateFormat("E, dd MMM yyyy HH:mm:ss z", LocaleStr.en);
                lastSinceTime = sdf.parse(lastSince).getTime();
                v0 = pageChanged = lastSinceTime != this.lastModifiedMap.get(path);
            }
            if (accessFirstTime || pageChanged) {
                response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
                response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)cached.length);
                response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)this.contentTypeMap.get(path));
                lastModifiedDt = this.lastModifiedMap.get(path);
                if (lastModifiedDt == null) {
                    HttpFileServerHandler.sendError(ctx, HttpResponseStatus.NOT_FOUND);
                    return;
                }
                response.headers().set("last-modified", (Object)new Date(lastModifiedDt));
                if (keepAlive) {
                    response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
                }
                response.content().writeBytes(cached);
            } else {
                response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_MODIFIED);
            }
            ctx.write((Object)response);
        }
        lastContentFuture = ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        if (keepAlive != false) return;
        lastContentFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        return;
lbl-1000:
        // 1 sources

        {
            finally {
                if (!keepAlive) {
                    ctx.close();
                }
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
        if (ctx.channel().isActive()) {
            HttpFileServerHandler.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private String sanitizeUri(String uri) {
        try {
            uri = URLDecoder.decode(uri, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            try {
                uri = URLDecoder.decode(uri, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException e1) {
                throw new Error();
            }
        }
        if (!uri.startsWith(this.context)) {
            uri = "/error.html";
        } else if (!uri.startsWith(T2)) {
            uri = "/error.html";
        } else {
            uri = uri.replaceFirst(this.context, "");
            uri = uri.replace('/', File.separatorChar);
        }
        uri = uri.replace("//", T2);
        if (uri.equals("") || uri.equals(T2)) {
            uri = "/index.html";
        }
        return this.baseDoc + uri;
    }

    private static void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.copiedBuffer((CharSequence)("Failure: " + status.toString() + "\r\n"), (Charset)CharsetUtil.UTF_8));
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/html;charset=UTF-8");
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private static String getContentTypeHeader(File file) {
        if (file.getPath().endsWith(_CSS)) {
            return TEXT_CSS;
        }
        if (file.getPath().endsWith(_JS)) {
            return APPLICATION_JAVASCRIPT;
        }
        MimetypesFileTypeMap mimetypesFileTypeMap = new MimetypesFileTypeMap();
        return mimetypesFileTypeMap.getContentType(file.getPath());
    }
}

