/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.httpserver;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class FileChangeListener
extends Thread {
    private File baseFolder;
    private Map<String, Long> fileChangeDtMap = new HashMap<String, Long>();
    private Set<String> filePathSet = new HashSet<String>();
    private ConcurrentHashMap<String, byte[]> resMap;
    private ConcurrentHashMap<String, String> contentTypeMap;
    private ConcurrentHashMap<String, Long> lastModifiedMap;

    public FileChangeListener(String baseDoc, ConcurrentHashMap<String, byte[]> resMap, ConcurrentHashMap<String, String> contentTypeMap, ConcurrentHashMap<String, Long> lastModifiedMap) {
        this.baseFolder = new File(baseDoc);
        this.scanFolder(this.baseFolder);
        this.resMap = resMap;
        this.contentTypeMap = contentTypeMap;
        this.lastModifiedMap = lastModifiedMap;
    }

    private void scanFolder(File file) {
        if (!file.exists()) {
            return;
        }
        this.filePathSet.clear();
        File[] childs = file.listFiles();
        for (File tmp : childs) {
            this.subScanFiles(tmp);
        }
        for (String path : this.filePathSet) {
            this.resMap.remove(path);
            this.contentTypeMap.remove(path);
            this.lastModifiedMap.remove(path);
        }
    }

    private void subScanFiles(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] childs;
            for (File tmp : childs = file.listFiles()) {
                this.subScanFiles(tmp);
            }
        } else if (file.isFile()) {
            String path = file.getPath();
            Long lastModified = file.lastModified();
            Long changeTime = this.fileChangeDtMap.get(path);
            if (changeTime == null) {
                this.fileChangeDtMap.put(path, lastModified);
            } else if (changeTime.longValue() != lastModified.longValue()) {
                this.filePathSet.add(path);
                this.fileChangeDtMap.put(path, lastModified);
            }
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    Thread.sleep(3000L);
                    this.scanFolder(this.baseFolder);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

