/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.event;

import cn.regionsoft.one.annotation.SlowEventListener;
import cn.regionsoft.one.common.Logger;
import cn.regionsoft.one.event.BaseEvent;
import cn.regionsoft.one.event.BaseEventListener;
import cn.regionsoft.one.event.SystemEventHandler;
import java.util.concurrent.ConcurrentHashMap;

@SlowEventListener
public class SystemSlowEventListener
extends BaseEventListener<Event> {
    public static Logger logger = Logger.getLogger(SystemSlowEventListener.class);
    private ConcurrentHashMap<Integer, SystemEventHandler> handlers = new ConcurrentHashMap();

    public void addHandler(SystemEventHandler systemEventHandler) {
        this.handlers.put(systemEventHandler.hashCode(), systemEventHandler);
    }

    @Override
    public Object handleEvent(Event event) {
        EventData eventData = event.getData();
        for (SystemEventHandler systemEventHandler : this.handlers.values()) {
            try {
                systemEventHandler.handle(eventData);
            }
            catch (Exception e) {
                logger.error(e);
            }
        }
        return null;
    }

    public static class EventData {
        public static final int USER_CREATE = 1;
        public static final int USER_ACCESS = 3;
        private int type;
        private Object data;

        public EventData(int type, Object data) {
            this.type = type;
            this.data = data;
        }

        public int getType() {
            return this.type;
        }

        public Object getData() {
            return this.data;
        }
    }

    public static class Event
    extends BaseEvent<EventData> {
        private EventData data;

        public Event(EventData data) {
            this.data = data;
        }

        @Override
        public EventData getData() {
            return this.data;
        }

        @Override
        public void setData(EventData data) {
            this.data = data;
        }
    }
}

