/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.event;

import cn.regionsoft.one.annotation.QuickEventListener;
import cn.regionsoft.one.annotation.SlowEventListener;
import cn.regionsoft.one.event.BaseEvent;
import cn.regionsoft.one.event.EventListener;
import cn.regionsoft.one.event.EventTask;
import cn.regionsoft.one.tool.ThreadPool;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;

public class RegionEventBus {
    private Map<String, EventListener> listenerMap = new ConcurrentHashMap<String, EventListener>();

    public void register(String listenerClassName, EventListener baseEventListener) {
        this.listenerMap.put(listenerClassName, baseEventListener);
    }

    public void unregister(String listenerClassName) {
        this.listenerMap.remove(listenerClassName);
    }

    public Future post(BaseEvent event) {
        Class<?> enclosingClass = event.getClass().getEnclosingClass();
        EventListener eventListener = this.listenerMap.get(enclosingClass.getName());
        if (eventListener == null) {
            return null;
        }
        EventTask task = new EventTask(event, eventListener);
        if (enclosingClass.isAnnotationPresent(QuickEventListener.class)) {
            return ThreadPool.getInstance().submitQuickTask(task);
        }
        if (enclosingClass.isAnnotationPresent(SlowEventListener.class)) {
            return ThreadPool.getInstance().submitSlowTask(task);
        }
        return null;
    }

    public Object postSync(BaseEvent event) {
        Class<?> enclosingClass = event.getClass().getEnclosingClass();
        EventListener eventListener = this.listenerMap.get(enclosingClass.getName());
        if (eventListener == null) {
            return null;
        }
        return eventListener.handleEvent(event);
    }
}

