/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.event;

import cn.regionsoft.one.event.BaseEvent;
import cn.regionsoft.one.event.EventListener;
import cn.regionsoft.one.event.RegionEventBus;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;

public class EventFactory {
    private static EventFactory eventFactory = new EventFactory();
    private final RegionEventBus eventBus = new RegionEventBus();
    private static Semaphore semaphore = new Semaphore(1);

    public static EventFactory getInstance() {
        return eventFactory;
    }

    private EventFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String listenerClassName, EventListener eventListener) {
        try {
            semaphore.acquire();
            this.eventBus.register(listenerClassName, eventListener);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            semaphore.release();
        }
    }

    public void unregister(String listenerClassName) {
        try {
            semaphore.acquire();
            this.eventBus.unregister(listenerClassName);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            semaphore.release();
        }
    }

    public Future publishEvent(BaseEvent event) {
        return this.eventBus.post(event);
    }

    public void publishSyncEvent(BaseEvent event) {
        this.eventBus.postSync(event);
    }
}

