/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.core.threads;

import cn.regionsoft.one.core.H2OContext;
import cn.regionsoft.one.event.EventRegister;
import cn.regionsoft.one.event.HttpFileEventListener;
import cn.regionsoft.one.event.HttpMsgEventListener;
import cn.regionsoft.one.event.SampleSlowEventListener;
import cn.regionsoft.one.event.SystemSlowEventListener;
import cn.regionsoft.one.utils.ContextScan;
import java.util.HashSet;
import java.util.concurrent.Callable;

public class ScanContextClassesTask
implements Callable<HashSet<Class<?>>> {
    private H2OContext context;

    public ScanContextClassesTask(H2OContext context) {
        this.context = context;
    }

    @Override
    public HashSet<Class<?>> call() {
        try {
            HashSet result = new HashSet();
            for (String path : this.context.getConfig().getSystemContextPaths()) {
                result.addAll(ContextScan.getClassListByPackage(path));
            }
            result.addAll(ContextScan.getClassListByPackage("cn.regionsoft.one.admin"));
            result.addAll(ContextScan.getClassListByPackage("cn.regionsoft.one.event"));
            result.add(HttpMsgEventListener.class);
            result.add(SampleSlowEventListener.class);
            result.add(SystemSlowEventListener.class);
            result.add(HttpFileEventListener.class);
            result.add(EventRegister.class);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

