/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.core.threads;

import cn.regionsoft.one.common.Logger;
import cn.regionsoft.one.core.CommonUtil;
import cn.regionsoft.one.core.DBType;
import cn.regionsoft.one.core.H2OContext;
import cn.regionsoft.one.core.dbconnection.AbstractConnectionPoolImpl;
import cn.regionsoft.one.core.dbconnection.CloudDBConnectionPool;
import cn.regionsoft.one.core.dbconnection.ConnectionPool;
import cn.regionsoft.one.core.dbconnection.MongoConnectionPool;
import cn.regionsoft.one.core.dbconnection.SQLConnectionPool;
import java.util.concurrent.Callable;

public class InitConnnectionPoolTask
implements Callable<ConnectionPool> {
    private static final Logger logger = Logger.getLogger(InitConnnectionPoolTask.class);
    private H2OContext context;

    public InitConnnectionPoolTask(H2OContext context) {
        this.context = context;
    }

    @Override
    public ConnectionPool call() {
        AbstractConnectionPoolImpl connectionPool = null;
        try {
            if (this.context.getConfig().getDbType() == DBType.MONGODB) {
                connectionPool = new MongoConnectionPool();
                connectionPool.init(this.context);
            } else if (this.context.getConfig().getDbType() == DBType.CLOUDDB) {
                connectionPool = new CloudDBConnectionPool();
                connectionPool.init(this.context);
            } else if (!CommonUtil.isEmpty((Object)this.context.getConfig().getDbType())) {
                connectionPool = new SQLConnectionPool();
                connectionPool.init(this.context);
            }
        }
        catch (Exception e) {
            logger.error(e);
        }
        return connectionPool;
    }
}

