/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.core.logger;

import cn.regionsoft.one.core.logger.CustomizedClassloader;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.List;

public class CustomizedClassloaderUtil {
    private static CustomizedClassloader customizedClassLoader = new CustomizedClassloader(new URL[0], null);
    private static Class logManagerClass = null;

    public static Object invokeMethod(String methodName, Object ... args) throws Exception {
        try {
            Method[] methods;
            for (Method method : methods = logManagerClass.getDeclaredMethods()) {
                if (!method.getName().equals(methodName)) continue;
                return method.invoke((Object)logManagerClass, args);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void loopFiles(File file, List<File> jars) {
        if (file.isDirectory()) {
            File[] tmps;
            for (File tmp : tmps = file.listFiles()) {
                CustomizedClassloaderUtil.loopFiles(tmp, jars);
            }
        } else if (file.getAbsolutePath().endsWith(".jar") || file.getAbsolutePath().endsWith(".zip")) {
            jars.add(file);
        }
    }

    static {
        ClassLoader tmpLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(customizedClassLoader);
        customizedClassLoader.setSystemClassLoader(CustomizedClassloader.class.getClassLoader());
        try {
            customizedClassLoader.addJar(CustomizedClassloaderUtil.class.getClassLoader().getResource("log4j-api-2.9.1.jar"));
            customizedClassLoader.addJar(CustomizedClassloaderUtil.class.getClassLoader().getResource("log4j-core-2.9.1.jar"));
            customizedClassLoader.addJar(CustomizedClassloaderUtil.class.getClassLoader().getResource("logProxy.jar"));
            logManagerClass = customizedClassLoader.loadClass("cn.regionsoft.xframe.common.LoggerProxy");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            Thread.currentThread().setContextClassLoader(tmpLoader);
            customizedClassLoader = null;
        }
    }
}

