/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.core.logger;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;

public class CustomizedClassloader
extends URLClassLoader {
    private ClassLoader systemClassLoader;

    public CustomizedClassloader(URL[] urls) {
        super(urls);
    }

    public CustomizedClassloader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public void addJarPath(String jarPath) throws MalformedURLException {
        File file = new File(jarPath);
        ArrayList<File> jars = new ArrayList<File>();
        this.loopFiles(file, jars);
        for (int i = 0; i < jars.size(); ++i) {
            this.addURL(((File)jars.get(i)).toURI().toURL());
        }
    }

    public void addJar(URL url) throws MalformedURLException {
        this.addURL(url);
    }

    public void loopFiles(File file, List<File> jars) {
        if (file.isDirectory()) {
            File[] tmps;
            for (File tmp : tmps = file.listFiles()) {
                this.loopFiles(tmp, jars);
            }
        } else if (file.getAbsolutePath().endsWith(".jar") || file.getAbsolutePath().endsWith(".zip")) {
            jars.add(file);
        }
    }

    @Override
    public synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.loadOutSide(name)) {
            return this.systemClassLoader.loadClass(name);
        }
        return super.loadClass(name, resolve);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (this.loadOutSide(name)) {
            return this.systemClassLoader.loadClass(name);
        }
        return super.loadClass(name);
    }

    public void setSystemClassLoader(ClassLoader systemClassLoader) {
        this.systemClassLoader = systemClassLoader;
    }

    private boolean loadOutSide(String name) {
        return false;
    }
}

