/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.core.ids;

import cn.regionsoft.one.common.Code64Util;
import cn.regionsoft.one.core.CommonUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class UserCodeWorker {
    private static final int SECOND_LENGTH = 32;
    private static final int WORKER_ID_LENGTH = 3;
    private static final int SEQ_LENGTH = 18;
    private static final long MAX_SEQ_PER_SECOND = (long)Math.pow(2.0, 18.0) - 1L;
    private static final long MAX_WORKER_ID = (long)Math.pow(2.0, 3.0) - 1L;
    private static final long MIN_ID = 0L;
    private long workIdVal = 0L;
    private Lock reentrantLock = new ReentrantLock();
    private long secondForRenew = 0L;
    private long calResult = 0L;
    private long seqNo = 0L;
    private final String baseTimeStr = "2018-01-01";
    private long baseTime = 0L;
    private final String datePattern = "yyyy-MM-dd";

    public UserCodeWorker(long workerId) {
        if (workerId < 0L || workerId > MAX_WORKER_ID) {
            throw new RuntimeException("workerId range : 0- " + MAX_WORKER_ID);
        }
        this.workIdVal = workerId << 18;
        try {
            SimpleDateFormat sdf = CommonUtil.getSimpleDateFormat("yyyy-MM-dd");
            Date dt = sdf.parse("2018-01-01");
            this.baseTime = dt.getTime() / 1000L;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public long getNextID() throws Exception {
        try {
            long result;
            this.reentrantLock.lock();
            long currentSecond = System.currentTimeMillis() / 1000L;
            if (this.secondForRenew != currentSecond) {
                this.secondForRenew = currentSecond;
                this.calResult = 0L + (this.secondForRenew - this.baseTime << 21) + this.workIdVal;
                this.seqNo = 0L;
            } else {
                ++this.seqNo;
                if (this.seqNo > MAX_SEQ_PER_SECOND) {
                    throw new Exception("IDWorker is exhausted for this second");
                }
            }
            long l = result = this.calResult + this.seqNo;
            return l;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.reentrantLock.unlock();
        }
    }

    public static void main(String[] args) throws Exception {
        Calendar cal = Calendar.getInstance();
        UserCodeWorker idWorkerForBiz = new UserCodeWorker(1L);
        System.out.println(idWorkerForBiz.getNextID());
        System.out.println(Code64Util.longToStr64(idWorkerForBiz.getNextID()));
    }
}

