/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.core.ids;

public class SnowflakeIDWorker {
    private final long workerId;
    private static final long twepoch = 1288834974657L;
    private long sequence = 0L;
    private static final long workerIdBits = 4L;
    public static final long maxWorkerId = 15L;
    private static final long sequenceBits = 10L;
    private static final long workerIdShift = 10L;
    private static final long timestampLeftShift = 14L;
    public static final long sequenceMask = 1023L;
    private long lastTimestamp = -1L;

    public SnowflakeIDWorker(long workerId) {
        if (workerId > 15L || workerId < 0L) {
            Object[] objectArray = new Object[1];
            objectArray[0] = 15L;
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", objectArray));
        }
        this.workerId = workerId;
    }

    public synchronized long nextId() {
        long timestamp = this.timeGen();
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0x3FFL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        if (timestamp < this.lastTimestamp) {
            try {
                throw new Exception(String.format("Clock moved backwards. Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.lastTimestamp = timestamp;
        long nextId = timestamp - 1288834974657L << 14 | this.workerId << 10 | this.sequence;
        return nextId;
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    private long timeGen() {
        return System.currentTimeMillis();
    }

    public static void main(String[] args) {
        SnowflakeIDWorker a = new SnowflakeIDWorker(0L);
        System.out.println(a.nextId());
    }
}

