/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.core.ids;

import cn.regionsoft.one.core.CommonUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class IDWorker {
    private static final Long ClUSTER_BASE = 1000000000000000L;
    private static final Long MAX_BASE = ClUSTER_BASE - 1L;
    private Long clusterMaxID;
    private Long clusterMinID;
    private int persistGap;
    private FileOutputStream fos = null;
    private FileChannel fc = null;
    private FileLock idFileLock = null;
    private String recordFilePath;
    private String recordFileLock;
    private Long lastGenerateId = null;
    private ByteBuffer bb = ByteBuffer.allocate(8);
    private RandomAccessFile idLockFileRaf = null;
    private FileChannel idLockFileFc = null;
    private FileLock idLockFileLock = null;
    private File idLockFile;
    private Lock reentrantLock = new ReentrantLock();

    public IDWorker(Long clusterId, String recordFolderPath, int persistGap) {
        if (clusterId < 0L || clusterId > 9L) {
            throw new RuntimeException("clusterId range : 0- 9");
        }
        File folder = new File(recordFolderPath);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        this.recordFilePath = recordFolderPath + System.getProperty("file.separator") + "ID" + clusterId.toString() + ".id";
        this.recordFileLock = recordFolderPath + System.getProperty("file.separator") + "ID" + clusterId.toString() + ".idlock";
        this.persistGap = persistGap;
        this.clusterMinID = clusterId * ClUSTER_BASE;
        this.clusterMaxID = clusterId * ClUSTER_BASE + MAX_BASE;
        this.init();
    }

    private void lockFile(File idLockFile) throws IOException {
        this.idLockFileRaf = new RandomAccessFile(idLockFile, "rw");
        this.idLockFileFc = this.idLockFileRaf.getChannel();
        this.idLockFileLock = this.idLockFileFc.tryLock();
    }

    private void init() {
        FileChannel isfc;
        FileInputStream fis;
        block10: {
            fis = null;
            isfc = null;
            try {
                File file = new File(this.recordFilePath);
                if (file.exists()) {
                    int jumpGap = 0;
                    this.idLockFile = new File(this.recordFileLock);
                    if (this.idLockFile.exists()) {
                        jumpGap = this.persistGap;
                    } else {
                        this.idLockFile.createNewFile();
                        this.lockFile(this.idLockFile);
                    }
                    fis = new FileInputStream(this.recordFilePath);
                    isfc = fis.getChannel();
                    isfc.read(this.bb, 0L);
                    this.bb.flip();
                    this.lastGenerateId = this.bb.getLong();
                    this.lastGenerateId = this.lastGenerateId + (long)jumpGap;
                    break block10;
                }
                this.lastGenerateId = this.clusterMinID;
                this.idLockFile = new File(this.recordFileLock);
                if (!this.idLockFile.exists()) {
                    this.idLockFile.createNewFile();
                }
                this.lockFile(this.idLockFile);
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    CommonUtil.closeQuietly(isfc);
                    CommonUtil.closeQuietly(fis);
                    throw throwable;
                }
            }
        }
        CommonUtil.closeQuietly(isfc);
        CommonUtil.closeQuietly(fis);
        try {
            this.fos = new FileOutputStream(this.recordFilePath);
            this.fc = this.fos.getChannel();
            this.idFileLock = this.fc.tryLock();
            this.persistCurrentId(this.lastGenerateId);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    IDWorker.this.releaseResource();
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Long getNextID() throws Exception {
        try {
            this.reentrantLock.lock();
            Long l = this.lastGenerateId;
            Long l2 = this.lastGenerateId = Long.valueOf(this.lastGenerateId + 1L);
            if (this.lastGenerateId % (long)this.persistGap == 0L) {
                this.persistCurrentId(this.lastGenerateId);
            }
            if (this.lastGenerateId > this.clusterMaxID) {
                throw new Exception("Cluster IDWorker is exhausted");
            }
            l = this.lastGenerateId;
            return l;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.reentrantLock.unlock();
        }
    }

    private void persistCurrentId(Long index) throws Exception {
        this.bb.rewind();
        this.bb.putLong(index);
        this.bb.flip();
        this.fc.write(this.bb, 0L);
    }

    private void releaseResource() {
        try {
            this.persistCurrentId(this.lastGenerateId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CommonUtil.closeQuietly(this.fc);
        CommonUtil.closeQuietly(this.fos);
        CommonUtil.closeQuietly(this.idLockFileFc);
        CommonUtil.closeQuietly(this.idLockFileRaf);
        this.idLockFile.delete();
    }
}

