/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.core.ids;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class AbstractIDGenerator {
    protected int workerIdLength = 0;
    protected int seqNoLength = 0;
    protected long maxSeqPerSecond = 0L;
    protected long maxWorkerId = 0L;
    protected long minId = 0L;
    protected long workIdVal = 0L;
    protected Lock reentrantLock = new ReentrantLock();
    protected long secondForRenew = 0L;
    protected long calResult = 0L;
    protected long seqNo = 0L;

    public AbstractIDGenerator(long workerId, int workerIdLength, int secondsLength, int seqNoLength) {
        this.workerIdLength = workerIdLength;
        this.seqNoLength = seqNoLength;
        this.maxSeqPerSecond = (long)Math.pow(2.0, seqNoLength) - 1L;
        this.maxWorkerId = (long)Math.pow(2.0, workerIdLength) - 1L;
        this.minId = (long)Math.pow(2.0, secondsLength + workerIdLength + seqNoLength);
        if (workerId < 0L || workerId > this.maxWorkerId) {
            throw new RuntimeException("workerId range : 0- " + this.maxWorkerId);
        }
        this.workIdVal = workerId << seqNoLength;
    }

    protected long getNextIdForBaseTime(long baseTime) throws InterruptedException {
        this.reentrantLock.lock();
        long currentSecond = System.currentTimeMillis() / 1000L;
        if (this.secondForRenew != currentSecond) {
            this.secondForRenew = currentSecond;
            this.calResult = this.minId + (this.secondForRenew - baseTime << this.workerIdLength + this.seqNoLength) + this.workIdVal;
            this.seqNo = 0L;
        } else {
            ++this.seqNo;
            if (this.seqNo > this.maxSeqPerSecond) {
                Thread.sleep(50L);
                return this.getNextIdForBaseTime(baseTime);
            }
        }
        long result = this.calResult + this.seqNo;
        return result;
    }
}

