/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.core.entity;

import cn.regionsoft.one.annotation.EntityMappingMode;
import cn.regionsoft.one.annotation.NoInstanceAnoType;
import cn.regionsoft.one.common.Logger;
import cn.regionsoft.one.core.CommonUtil;
import cn.regionsoft.one.core.ContextConfig;
import cn.regionsoft.one.core.CountResult;
import cn.regionsoft.one.core.DBType;
import cn.regionsoft.one.core.EntityManager;
import cn.regionsoft.one.core.H2OContext;
import cn.regionsoft.one.core.dbconnection.SQLConnection;
import cn.regionsoft.one.core.dbconnection.SQLConnectionManager;
import cn.regionsoft.one.core.entity.BindObject;
import cn.regionsoft.one.core.entity.SQLEntityManager;
import cn.regionsoft.one.data.dialet.MongoDbDialet;
import cn.regionsoft.one.data.dialet.core.Dialet;
import cn.regionsoft.one.data.dialet.core.SQLDialet;
import cn.regionsoft.one.properties.ConfigUtil;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class MongoEntityManager
extends EntityManager {
    private static final Logger logger = Logger.getLogger(MongoEntityManager.class);
    private static boolean showSql = Boolean.valueOf(ConfigUtil.getProperty("show.sql"));
    private H2OContext h2oContext;
    private Dialet dialet;

    public MongoEntityManager(H2OContext h2oContext) {
        this.h2oContext = h2oContext;
    }

    @Override
    public void init() {
        ContextConfig config = this.h2oContext.getConfig();
        if (config.getEntityMappingMode() == EntityMappingMode.NONE) {
            return;
        }
        this.dialet = MongoEntityManager.getCurrentDialetIntance(this.h2oContext);
        HashSet<Class<?>> entities = this.h2oContext.getAnnotatedClassHub().getClassSetByAnnotation(NoInstanceAnoType.Entity);
        if (entities != null) {
            if (config.getEntityMappingMode() == EntityMappingMode.CREATE) {
                this.createMode(entities, this.dialet);
            } else if (config.getEntityMappingMode() == EntityMappingMode.DROP_CREATE) {
                this.dropCreateMode(entities, this.dialet);
            }
        }
    }

    @Override
    public Dialet getDialet() {
        return this.dialet;
    }

    public static Dialet getCurrentDialetIntance(H2OContext systemContext) {
        ContextConfig config = systemContext.getConfig();
        if (config.getDbType() == DBType.MONGODB) {
            return new MongoDbDialet();
        }
        throw new RuntimeException("SystemConfig.DB_TYPE is empty");
    }

    private void excuteBatch(List<String> batchSqls) throws Exception {
        SQLConnection connection = SQLEntityManager.getConnection(this.h2oContext);
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
            int count = 0;
            for (String sql : batchSqls) {
                logger.debug(sql);
                stmt.addBatch(sql);
                if (++count != this.h2oContext.getConfig().getBatchSize()) continue;
                stmt.executeBatch();
                count = 0;
            }
            if (count > 0) {
                stmt.executeBatch();
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            CommonUtil.closeQuietly(stmt);
            SQLConnectionManager.releaseConnection(this.h2oContext);
        }
    }

    public <T> T getObject(String sql, Object[] sqlParas, Class<T> resultMapClass) throws Exception {
        List<T> ls = this.getList(sql, sqlParas, resultMapClass);
        if (ls.size() == 0) {
            return null;
        }
        if (ls.size() == 1) {
            return ls.get(0);
        }
        throw new Exception("More than one records are found");
    }

    public <T> List<T> getList(String sql, Object[] sqlParas, Class<T> resultMapClass) throws Exception {
        List<T> list;
        if (showSql) {
            logger.debug(sql, " , paras:", sqlParas);
        }
        SQLConnection connection = SQLEntityManager.getConnection(this.h2oContext);
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            List<T> ls;
            ps = connection.prepareStatement(sql);
            if (sqlParas != null) {
                for (int i = 0; i < sqlParas.length; ++i) {
                    if (sqlParas[i] instanceof java.util.Date) {
                        if (sqlParas[i] == null) {
                            ps.setDate(i + 1, null);
                            continue;
                        }
                        java.util.Date tmpDt = (java.util.Date)sqlParas[i];
                        Date sqlDt = new Date(tmpDt.getTime());
                        ps.setDate(i + 1, sqlDt);
                        continue;
                    }
                    if (sqlParas[i] instanceof Boolean) {
                        ps.setBoolean(i + 1, (Boolean)sqlParas[i]);
                        continue;
                    }
                    ps.setObject(i + 1, sqlParas[i]);
                }
            }
            rs = ps.executeQuery();
            list = ls = CommonUtil.resolveResultSet(rs, resultMapClass, this.h2oContext);
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                CommonUtil.closeQuietly(rs);
                CommonUtil.closeQuietly(ps);
                SQLConnectionManager.releaseConnection(this.h2oContext);
                throw throwable;
            }
        }
        CommonUtil.closeQuietly(rs);
        CommonUtil.closeQuietly(ps);
        SQLConnectionManager.releaseConnection(this.h2oContext);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMode(HashSet<Class<?>> entities, Dialet dialet) {
        if (dialet instanceof SQLDialet) {
            SQLDialet sqlDialet = (SQLDialet)dialet;
            SQLConnection connection = null;
            try {
                connection = SQLEntityManager.getConnection(this.h2oContext);
                ArrayList<String> sqls = new ArrayList<String>();
                for (Class<?> tmpClass : entities) {
                    BindObject bindObject = new BindObject(tmpClass);
                    this.h2oContext.getEntityManager().getEntityToTableCache().put(tmpClass, bindObject);
                    String sql = sqlDialet.getTableExsitsQuery(bindObject.getTableName(), this.h2oContext.getConfig().getSchema());
                    CountResult countResult = this.getObject(sql, null, CountResult.class);
                    if (countResult.getCount() != 0L) continue;
                    sqls.add(sqlDialet.getCreateTableSql(bindObject));
                }
                if (Logger.specialLogEnabled) {
                    for (String sql : sqls) {
                        if (!showSql) continue;
                        logger.debug(sql);
                    }
                }
                connection.setAutoCommit(false);
                this.excuteBatch(sqls);
                connection.commit();
            }
            catch (Exception e) {
                logger.error(e);
            }
            finally {
                try {
                    connection.setAutoCommit(true);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                SQLConnectionManager.releaseConnection(this.h2oContext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropCreateMode(HashSet<Class<?>> entities, Dialet dialet) {
        if (dialet instanceof SQLDialet) {
            SQLDialet sqlDialet = (SQLDialet)dialet;
            SQLConnection connection = null;
            try {
                connection = SQLEntityManager.getConnection(this.h2oContext);
                ArrayList<String> sqls = new ArrayList<String>();
                for (Class<?> tmpClass : entities) {
                    BindObject bindObject = new BindObject(tmpClass);
                    this.h2oContext.getEntityManager().getEntityToTableCache().put(tmpClass, bindObject);
                    String sql = sqlDialet.getTableExsitsQuery(bindObject.getTableName(), this.h2oContext.getConfig().getSchema());
                    CountResult countResult = this.getObject(sql, null, CountResult.class);
                    if (countResult.getCount() == 0L) {
                        sqls.add(sqlDialet.getCreateTableSql(bindObject));
                        continue;
                    }
                    sqls.add(sqlDialet.getDropTableSql(bindObject.getTableName()));
                    sqls.add(sqlDialet.getCreateTableSql(bindObject));
                }
                connection.setAutoCommit(false);
                this.excuteBatch(sqls);
                connection.commit();
            }
            catch (Exception e) {
                logger.error(e);
            }
            finally {
                try {
                    connection.setAutoCommit(true);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                SQLConnectionManager.releaseConnection(this.h2oContext);
            }
        }
    }
}

