/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.core.entity;

import cn.regionsoft.one.annotation.EntityMappingMode;
import cn.regionsoft.one.annotation.NoInstanceAnoType;
import cn.regionsoft.one.bigdata.core.exceptions.ExistException;
import cn.regionsoft.one.bigdata.core.object.RDSchema;
import cn.regionsoft.one.bigdata.core.object.RDTable;
import cn.regionsoft.one.bigdata.impl.hbase.HbaseThreadHolder;
import cn.regionsoft.one.bigdata.impl.hbase.HbaseUtil;
import cn.regionsoft.one.common.Logger;
import cn.regionsoft.one.core.CommonUtil;
import cn.regionsoft.one.core.ContextConfig;
import cn.regionsoft.one.core.DBType;
import cn.regionsoft.one.core.EntityManager;
import cn.regionsoft.one.core.H2OContext;
import cn.regionsoft.one.core.dbconnection.CloudConnectionManager;
import cn.regionsoft.one.core.dbconnection.CloudDBConnection;
import cn.regionsoft.one.core.entity.BindColumn;
import cn.regionsoft.one.core.entity.BindObject;
import cn.regionsoft.one.data.dialet.CloudDbDialet;
import cn.regionsoft.one.data.dialet.core.Dialet;
import cn.regionsoft.one.properties.ConfigUtil;
import cn.regionsoft.one.utils.ThreadData;
import cn.regionsoft.one.utils.ThreadHolder;
import cn.regionsoft.one.utils.TransactionUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class CloudDBEntityManager
extends EntityManager {
    private static final Logger logger = Logger.getLogger(CloudDBEntityManager.class);
    private static boolean showSql = Boolean.valueOf(ConfigUtil.getProperty("show.sql"));
    private H2OContext h2oContext;
    private Dialet dialet;

    public CloudDBEntityManager(H2OContext h2oContext) {
        this.h2oContext = h2oContext;
    }

    @Override
    public void init() {
        ContextConfig config = this.h2oContext.getConfig();
        if (config.getEntityMappingMode() == EntityMappingMode.NONE) {
            return;
        }
        this.dialet = CloudDBEntityManager.getCurrentDialetIntance(this.h2oContext);
        HashSet<Class<?>> entities = this.h2oContext.getAnnotatedClassHub().getClassSetByAnnotation(NoInstanceAnoType.Entity);
        if (entities != null) {
            if (config.getEntityMappingMode() == EntityMappingMode.CREATE) {
                this.createMode(entities, this.dialet);
            } else if (config.getEntityMappingMode() == EntityMappingMode.DROP_CREATE) {
                this.dropCreateMode(entities, this.dialet);
            }
        }
    }

    @Override
    public Dialet getDialet() {
        return this.dialet;
    }

    public static Dialet getCurrentDialetIntance(H2OContext systemContext) {
        ContextConfig config = systemContext.getConfig();
        if (config.getDbType() == DBType.CLOUDDB) {
            return new CloudDbDialet();
        }
        throw new RuntimeException("SystemConfig.DB_TYPE is empty");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMode(HashSet<Class<?>> entities, Dialet dialet) {
        CloudDBConnection connection = null;
        try {
            connection = CloudDBEntityManager.getConnection(this.h2oContext);
            ContextConfig config = this.h2oContext.getConfig();
            RDSchema rdSchema = HbaseUtil.getRDSchema(config.getAppOwner(), config.getAppId());
            if (rdSchema == null) {
                try {
                    rdSchema = HbaseUtil.createRDSchema(config.getAppOwner(), config.getAppId(), config.getSchema());
                }
                catch (ExistException existException) {
                    // empty catch block
                }
            }
            TreeMap sortedMap = new TreeMap();
            RDTable rdTable = null;
            for (Class<?> tmpClass : entities) {
                BindObject bindObject = new BindObject(tmpClass);
                rdTable = HbaseUtil.getRdTable(rdSchema, bindObject.getTableName());
                if (rdTable == null) {
                    sortedMap.put(tmpClass.getSimpleName(), tmpClass);
                    continue;
                }
                this.createColumns(rdTable, bindObject, (CloudDbDialet)dialet);
                this.h2oContext.getEntityManager().getEntityToTableCache().put(tmpClass, bindObject);
            }
            Set entry = sortedMap.entrySet();
            for (Map.Entry temp : entry) {
                BindObject bindObject = new BindObject((Class)temp.getValue());
                rdTable = HbaseUtil.createRdTable(rdSchema, bindObject.getTableName());
                this.createColumns(rdTable, bindObject, (CloudDbDialet)dialet);
                this.h2oContext.getEntityManager().getEntityToTableCache().put((Class<?>)temp.getValue(), bindObject);
            }
        }
        catch (Exception e) {
            logger.error(e);
        }
        finally {
            CloudConnectionManager.releaseConnection(this.h2oContext);
        }
    }

    private void createColumns(RDTable rdTable, BindObject bindObject, CloudDbDialet cloudDbDialet) throws Exception {
        if (bindObject.getIdColumn() != null) {
            try {
                HbaseUtil.createRdColumn(rdTable, bindObject.getIdColumn().getName(), bindObject.getIdColumn().getName(), cloudDbDialet.getDataTypeByClass(bindObject.getIdColumn().getBindType()));
            }
            catch (ExistException existException) {
                // empty catch block
            }
        }
        Map<String, BindColumn> columns = bindObject.getColumns();
        for (BindColumn tmp : columns.values()) {
            try {
                HbaseUtil.createRdColumn(rdTable, tmp.getName(), tmp.getName(), cloudDbDialet.getDataTypeByClass(tmp.getBindType()));
            }
            catch (ExistException existException) {}
        }
        if (bindObject.getVersionColumn() != null) {
            try {
                HbaseUtil.createRdColumn(rdTable, bindObject.getVersionColumn().getName(), bindObject.getVersionColumn().getName(), cloudDbDialet.getDataTypeByClass(bindObject.getVersionColumn().getBindType()));
            }
            catch (ExistException existException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropCreateMode(HashSet<Class<?>> entities, Dialet dialet) {
        CloudDBConnection connection = null;
        try {
            connection = CloudDBEntityManager.getConnection(this.h2oContext);
            ContextConfig config = this.h2oContext.getConfig();
            RDSchema rdSchema = HbaseUtil.getRDSchema(config.getAppOwner(), config.getAppId());
            if (rdSchema == null) {
                try {
                    rdSchema = HbaseUtil.createRDSchema(config.getAppOwner(), config.getAppId(), config.getSchema());
                }
                catch (ExistException existException) {
                    // empty catch block
                }
            }
            RDTable rdTable = null;
            for (Class<?> tmpClass : entities) {
                BindObject bindObject = new BindObject(tmpClass);
                HbaseUtil.deleteTable(rdSchema, bindObject.getTableName());
                try {
                    rdTable = HbaseUtil.createRdTable(rdSchema, bindObject.getTableName());
                }
                catch (ExistException existException) {
                    // empty catch block
                }
                this.createColumns(rdTable, bindObject, (CloudDbDialet)dialet);
                this.h2oContext.getEntityManager().getEntityToTableCache().put(tmpClass, bindObject);
            }
        }
        catch (Exception e) {
            logger.error(e);
        }
        finally {
            CloudConnectionManager.releaseConnection(this.h2oContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CloudDBConnection getConnection(H2OContext h2oContext) throws Exception {
        CloudDBConnection dbConnection = null;
        ThreadHolder holder = ThreadHolder.getInstance();
        ThreadData threadData = holder.getThreadDatas().get();
        if (threadData == null) {
            threadData = new ThreadData();
            holder.getThreadDatas().set(threadData);
        }
        if (TransactionUtil.isInTransaction(h2oContext)) {
            dbConnection = (CloudDBConnection)threadData.getTransactionConnection(h2oContext);
            if (dbConnection == null) {
                dbConnection = (CloudDBConnection)h2oContext.getConnectionFromPool();
                threadData.setTransactionConnection(dbConnection, h2oContext);
                threadData.setTransactionDepth(1, h2oContext);
            } else {
                threadData.setTransactionDepth(threadData.getTransactionDepth(h2oContext) + 1, h2oContext);
            }
        } else {
            dbConnection = (CloudDBConnection)threadData.getNoTrxConnection(h2oContext);
            if (dbConnection == null) {
                dbConnection = (CloudDBConnection)h2oContext.getConnectionFromPool();
                threadData.setNoTrxConnection(dbConnection, h2oContext);
                threadData.setNonTransactionDepth(1, h2oContext);
            } else {
                threadData.setNonTransactionDepth(threadData.getNonTransactionDepth(h2oContext) + 1, h2oContext);
            }
        }
        ContextConfig config = h2oContext.getConfig();
        if (System.currentTimeMillis() - dbConnection.getLastUseDt().getTime() > config.getConnectionValidateGap()) {
            AutoCloseable statement = null;
            try {
                dbConnection.getHbaseDBConnection().testConnectivity();
            }
            catch (Exception e) {
                dbConnection = (CloudDBConnection)h2oContext.newConnection();
                if (TransactionUtil.isInTransaction(h2oContext)) {
                    threadData.setTransactionConnection(dbConnection, h2oContext);
                } else {
                    threadData.setNoTrxConnection(dbConnection, h2oContext);
                }
            }
            finally {
                CommonUtil.closeQuietly(statement);
            }
        }
        HbaseThreadHolder.getInstance().setThreadDatas(dbConnection.getHbaseDBConnection());
        return dbConnection;
    }
}

