/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.core.entity;

import cn.regionsoft.one.core.CommonUtil;
import cn.regionsoft.one.core.entity.BindColumn;
import cn.regionsoft.one.data.dialet.core.SQLDialet;
import cn.regionsoft.one.data.persistence.Column;
import cn.regionsoft.one.data.persistence.Id;
import cn.regionsoft.one.data.persistence.Table;
import cn.regionsoft.one.data.persistence.Version;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class BindObject {
    private Class<?> entityClass = null;
    private String tableName = null;
    private Map<String, BindColumn> columns = new LinkedHashMap<String, BindColumn>();
    private BindColumn idColumn;
    private BindColumn versionColumn;

    public BindObject(Class<?> entityClass) {
        this.entityClass = entityClass;
        this.init();
    }

    private void init() {
        Table tableAno = this.entityClass.getAnnotation(Table.class);
        if (tableAno != null) {
            this.tableName = tableAno.name();
        }
        if (this.tableName == null || this.tableName.trim().equals("")) {
            this.tableName = this.entityClass.getSimpleName();
        }
        ArrayList<Field> allFields = new ArrayList<Field>();
        CommonUtil.resolveAllFields(this.entityClass, allFields);
        this.resolveColumns(allFields, this.columns);
    }

    private void resolveColumns(List<Field> fieldsPara, Map<String, BindColumn> columnsPara) {
        BindColumn bindColumn = null;
        for (Field field : fieldsPara) {
            Id idAno;
            if (this.idColumn == null && (idAno = field.getDeclaredAnnotation(Id.class)) != null) {
                bindColumn = new BindColumn();
                bindColumn.setName(CommonUtil.isEmpty(idAno.name()) ? field.getName() : idAno.name());
                bindColumn.setLength(idAno.length());
                bindColumn.setBindType(field.getType());
                bindColumn.setField(field);
                bindColumn.setIdColumn(true);
                this.idColumn = bindColumn;
                continue;
            }
            Version versionAno = field.getDeclaredAnnotation(Version.class);
            if (this.versionColumn == null && versionAno != null) {
                bindColumn = new BindColumn();
                bindColumn.setName(versionAno.name());
                if (field.getType() != Integer.class) {
                    throw new RuntimeException("\r\nVersion can only be Integer\r\n-" + this.entityClass.getName() + "." + field.getName());
                }
                bindColumn.setBindType(Integer.class);
                bindColumn.setField(field);
                this.versionColumn = bindColumn;
                continue;
            }
            Column columnAno = field.getDeclaredAnnotation(Column.class);
            if (columnAno == null) continue;
            bindColumn = new BindColumn();
            bindColumn.setName(CommonUtil.isEmpty(columnAno.name()) ? field.getName() : columnAno.name());
            bindColumn.setLength(columnAno.length());
            bindColumn.setBindType(field.getType());
            bindColumn.setField(field);
            if (this.columns.containsKey(field.getName())) continue;
            this.columns.put(field.getName(), bindColumn);
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public Map<String, BindColumn> getColumns() {
        return this.columns;
    }

    public void setColumns(Map<String, BindColumn> columns) {
        this.columns = columns;
    }

    public BindColumn getIdColumn() {
        return this.idColumn;
    }

    public BindColumn getVersionColumn() {
        return this.versionColumn;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public List<BindColumn> getAllColumnsExceptVersion() {
        ArrayList<BindColumn> columns = new ArrayList<BindColumn>();
        if (this.getIdColumn() != null) {
            columns.add(this.getIdColumn());
        }
        for (BindColumn bindColumn : this.getColumns().values()) {
            columns.add(bindColumn);
        }
        return columns;
    }

    public String getDropSql(SQLDialet dialet) {
        return dialet.getDropTableSql(this.getTableName());
    }
}

