/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.core.dispatcher;

import cn.regionsoft.one.annotation.tag.Cookies;
import cn.regionsoft.one.annotation.tag.HeaderInfo;
import cn.regionsoft.one.annotation.tag.Parameter;
import cn.regionsoft.one.annotation.tag.PathVariable;
import cn.regionsoft.one.annotation.tag.RequestMapping;
import cn.regionsoft.one.caches.LocalCacheUtil;
import cn.regionsoft.one.common.AESUtil;
import cn.regionsoft.one.common.JsonUtil;
import cn.regionsoft.one.common.Logger;
import cn.regionsoft.one.core.CommonUtil;
import cn.regionsoft.one.core.H2OContext;
import cn.regionsoft.one.core.I18nMessageManager;
import cn.regionsoft.one.core.RequestInfoHolder;
import cn.regionsoft.one.core.SystemContext;
import cn.regionsoft.one.core.auth.AdvancedSecurityProvider;
import cn.regionsoft.one.core.auth.BasicSecurityProvider;
import cn.regionsoft.one.core.auth.dto.BasicSecurityResultDto;
import cn.regionsoft.one.core.auth.dto.RequestInfoDto;
import cn.regionsoft.one.core.controller.ControllerManager;
import cn.regionsoft.one.core.controller.RequestNode;
import cn.regionsoft.one.core.controller.RequestNodeWrapper;
import cn.regionsoft.one.core.dispatcher.ProcessResponseWrapper;
import cn.regionsoft.one.core.exception.ControllerException;
import cn.regionsoft.one.core.exception.MultipleControllerMappingException;
import cn.regionsoft.one.core.exception.NoControllerMappingException;
import cn.regionsoft.one.enums.RequestMethod;
import cn.regionsoft.one.enums.UserToDoAction;
import cn.regionsoft.one.properties.ConfigUtil;
import cn.regionsoft.one.reflect.MethodMeta;
import cn.regionsoft.one.web.core.RespCode;
import cn.regionsoft.one.web.wrapper.ResourceResWrapper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebRequestProcessor {
    private static final Logger logger = Logger.getLogger(WebRequestProcessor.class);
    private static String secfilterConfig = ConfigUtil.getProperty("security.filter");
    private static final String JSON_HEADER = "Content-Type == application/json;charset=UTF-8";
    private static final String PROMPT_LOGIN = "login.required";
    private static final String PROMPT_403 = "access.forbidden";
    private static final String END_SUFFIX = "/";
    private static final String LOCALE = "locale";
    private static SystemContext systemContext = null;
    private static Map<String, H2OContext> contextsMap = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessResponseWrapper process(String requestURI, String method, Map<String, String[]> requestMap, Map<String, String> headerInfo, Map<String, String> cookies, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            ProcessResponseWrapper processResponseWrapper;
            if (requestURI.endsWith(END_SUFFIX)) {
                requestURI = requestURI.substring(0, requestURI.length() - 1);
            }
            String loginToken = null;
            RequestInfoHolder.getInstance().setRequestInfo(null);
            UserToDoAction userToDoAction = UserToDoAction.VALID_ACCESS;
            RequestInfoDto requestInfoDto = new RequestInfoDto();
            requestInfoDto.setLocale(cookies.get(LOCALE));
            RequestInfoHolder.getInstance().setRequestInfo(requestInfoDto);
            if (userToDoAction == UserToDoAction.VALID_ACCESS) {
                AdvancedSecurityProvider advancedSecurityProvider;
                if (loginToken == null) {
                    loginToken = cookies.get("_token");
                }
                BasicSecurityProvider basicSecurity = systemContext.getBasicSecurityProvider();
                BasicSecurityResultDto basicSecurityResultDto = null;
                if (basicSecurity != null && (userToDoAction = (basicSecurityResultDto = basicSecurity.validateAccess(loginToken, requestURI, request, response, cookies)).getUserToDoAction()) == UserToDoAction.VALID_ACCESS && (advancedSecurityProvider = systemContext.getAdvancedSecurityProvider()) != null) {
                    userToDoAction = advancedSecurityProvider.checkAccess(basicSecurityResultDto.getAccount(), requestURI, headerInfo, cookies, request, response);
                }
                if (basicSecurityResultDto != null) {
                    requestInfoDto.setLoginAccount(basicSecurityResultDto.getAccount());
                    requestInfoDto.setToken(loginToken);
                }
            }
            if (userToDoAction != UserToDoAction.VALID_ACCESS) {
                processResponseWrapper = new ProcessResponseWrapper();
                if (userToDoAction == UserToDoAction.NEED_TO_LOGIN) {
                    processResponseWrapper.setResponse(JsonUtil.objectToJson(ResourceResWrapper.failResult(I18nMessageManager.getMessageWithDefault(PROMPT_LOGIN, "please login first"), RespCode._401)));
                } else if (userToDoAction == UserToDoAction.ACCESS_FORBIDDEN) {
                    processResponseWrapper.setResponse(JsonUtil.objectToJson(ResourceResWrapper.failResult(I18nMessageManager.getMessageWithDefault(PROMPT_403, "access forbidden"), RespCode._403)));
                } else {
                    processResponseWrapper.setResponse(JsonUtil.objectToJson(ResourceResWrapper.failResult(I18nMessageManager.getMessageWithDefault(PROMPT_403, "access forbidden"), RespCode._403)));
                }
                processResponseWrapper.setResponseHeader(new String[]{JSON_HEADER});
                processResponseWrapper.setReturnType(null);
                return processResponseWrapper;
            }
            processResponseWrapper = new ProcessResponseWrapper();
            try {
                RequestNodeWrapper requestNodeWrapper = (RequestNodeWrapper)LocalCacheUtil.get("url-" + requestURI);
                if (requestNodeWrapper == null) {
                    ArrayList<RequestNodeWrapper> matchedNodes = new ArrayList<RequestNodeWrapper>();
                    for (H2OContext context : contextsMap.values()) {
                        try {
                            matchedNodes.add(context.getMatchedRequestNode(requestURI));
                        }
                        catch (NoControllerMappingException noControllerMappingException) {}
                    }
                    requestNodeWrapper = ControllerManager.filterReuqestNodeWrapper(requestURI, matchedNodes);
                    LinkedHashMap<String, Object> pathVaribleMap = requestNodeWrapper.getParaMap();
                    if (pathVaribleMap == null || pathVaribleMap.size() == 0) {
                        LocalCacheUtil.put("url-" + requestURI, requestNodeWrapper);
                    }
                }
                RequestMapping requestMapping = requestNodeWrapper.getRequestNode().getMethod().getAnnotation(RequestMapping.class);
                if (Boolean.valueOf(ConfigUtil.getProperty("aes.enabled")).booleanValue()) {
                    processResponseWrapper.setEncript(true);
                }
                if (requestMapping.ignoreEncryption()) {
                    processResponseWrapper.setEncript(false);
                }
                RequestMethod[] methods = requestMapping.method();
                boolean methodMatched = false;
                method = method.toUpperCase();
                for (RequestMethod requestMethod : methods) {
                    if (!requestMethod.getVal().equals(method)) continue;
                    methodMatched = true;
                    break;
                }
                if (!methodMatched) {
                    processResponseWrapper.setResponse(JsonUtil.objectToJson(ResourceResWrapper.failResult(method + " is not supported by " + requestNodeWrapper.getRequestNode().getControllerClass().getSimpleName() + "." + requestNodeWrapper.getRequestNode().getMethod().getName(), RespCode._404)));
                    processResponseWrapper.setResponseHeader(new String[]{JSON_HEADER});
                    processResponseWrapper.setReturnType(null);
                } else {
                    String responseStr = (String)WebRequestProcessor.invoke(requestNodeWrapper, requestMap, headerInfo, cookies, request, response, requestURI, method, processResponseWrapper.isEncript());
                    processResponseWrapper.setResponse(responseStr);
                    processResponseWrapper.setResponseHeader(requestNodeWrapper.getRequestNode().getProduces());
                    processResponseWrapper.setReturnType(requestNodeWrapper.getRequestNode().getReturnType());
                }
            }
            catch (NoControllerMappingException e1) {
                logger.warn(e1);
                processResponseWrapper.setResponse(JsonUtil.objectToJson(ResourceResWrapper.failResult(requestURI + " \u670d\u52a1\u4e0d\u5b58\u5728", RespCode._404)));
                processResponseWrapper.setResponseHeader(new String[]{JSON_HEADER});
                processResponseWrapper.setReturnType(null);
            }
            catch (MultipleControllerMappingException e2) {
                logger.error(e2);
                processResponseWrapper.setResponse(JsonUtil.objectToJson(ResourceResWrapper.failResult("\u591a\u4e2aController\u5bf9\u5e94\u4e00\u4e2aURL" + requestURI, RespCode._409)));
                processResponseWrapper.setResponseHeader(new String[]{JSON_HEADER});
                processResponseWrapper.setReturnType(null);
            }
            catch (ControllerException e3) {
                logger.error(e3);
                processResponseWrapper.setResponse(JsonUtil.objectToJson(ResourceResWrapper.failResult(e3.getCause().getMessage(), RespCode._508)));
                processResponseWrapper.setResponseHeader(new String[]{JSON_HEADER});
                processResponseWrapper.setReturnType(null);
            }
            finally {
                RequestInfoHolder.getInstance().setRequestInfo(null);
            }
            return processResponseWrapper;
        }
        catch (Exception e) {
            logger.error(e);
            throw e;
        }
    }

    private static Object invoke(RequestNodeWrapper requestNodeWrapper, Map<String, String[]> requestMap, Map<String, String> headerInfo, Map<String, String> cookies, HttpServletRequest request, HttpServletResponse response, String requestURI, String httpMethod, boolean encrypt) throws ControllerException {
        RequestNode requestNode = requestNodeWrapper.getRequestNode();
        try {
            return requestNode.getMethod().invoke(systemContext.getManagedBean(requestNode.getControllerClass()), WebRequestProcessor.resolveParas(requestNodeWrapper, requestMap, headerInfo, cookies, request, response, requestURI, httpMethod, encrypt));
        }
        catch (Exception e) {
            throw new ControllerException(e);
        }
    }

    private static Object[] resolveParas(RequestNodeWrapper requestNodeWrapper, Map<String, String[]> requestMap, Map<String, String> headerInfo, Map<String, String> cookies, HttpServletRequest request, HttpServletResponse response, String requestURI, String httpMethod, boolean encrypt) throws Exception {
        RequestNode requestNode = requestNodeWrapper.getRequestNode();
        LinkedHashMap<String, Object> pathVaribleMap = requestNodeWrapper.getParaMap();
        Method method = requestNode.getMethod();
        MethodMeta methodMeta = CommonUtil.getMethodMeta(requestNode.getControllerClass(), method);
        Map<Integer, String> paraNamesMirror = methodMeta.getParaNamesMirror();
        Class<?>[] paraTypes = methodMeta.getParameterTypes();
        int paraLength = paraTypes.length;
        Annotation[][] annotations = methodMeta.getParameterAnnotations();
        Annotation[] tmp = null;
        Object[] parasVals = new Object[paraLength];
        boolean aesEnabled = Boolean.valueOf(ConfigUtil.getProperty("aes.enabled"));
        if (!encrypt) {
            aesEnabled = false;
        }
        String aesKey = null;
        String aesIv = null;
        if (aesEnabled) {
            aesKey = ConfigUtil.getProperty("aes.key");
            aesIv = ConfigUtil.getProperty("aes.iv");
        }
        block0: for (int i = 0; i < paraLength; ++i) {
            if (paraTypes[i] == HttpServletRequest.class) {
                parasVals[i] = request;
                continue;
            }
            if (paraTypes[i] == HttpServletResponse.class) {
                parasVals[i] = response;
                continue;
            }
            tmp = annotations[i];
            if (tmp.length == 0) {
                String parameterKey = paraNamesMirror.get(i);
                String[] tmpArray = requestMap.get(parameterKey);
                if (tmpArray == null) continue;
                if (httpMethod.equals("POST") && aesEnabled) {
                    for (int k = 0; k < tmpArray.length; ++k) {
                        tmpArray[k] = new String(AESUtil.decriptCBC(tmpArray[k], aesKey, aesIv), "UTF-8");
                    }
                }
                if (tmpArray.length == 1) {
                    parasVals[i] = tmpArray[0];
                    continue;
                }
                parasVals[i] = tmpArray;
                continue;
            }
            for (Annotation an : tmp) {
                if (an.annotationType() == Parameter.class) {
                    String[] tmpArray;
                    String parameterKey = ((Parameter)an).value();
                    if (CommonUtil.isEmpty(parameterKey)) {
                        parameterKey = paraNamesMirror.get(i);
                    }
                    if ((tmpArray = requestMap.get(parameterKey)) == null) continue block0;
                    if (httpMethod.equals("POST") && aesEnabled) {
                        for (int k = 0; k < tmpArray.length; ++k) {
                            tmpArray[k] = new String(AESUtil.decriptCBC(tmpArray[k], aesKey, aesIv), "UTF-8");
                        }
                    }
                    if (tmpArray.length == 1) {
                        parasVals[i] = tmpArray[0];
                        continue block0;
                    }
                    parasVals[i] = tmpArray;
                    continue block0;
                }
                if (an.annotationType() == HeaderInfo.class) {
                    parasVals[i] = headerInfo;
                    continue block0;
                }
                if (an.annotationType() == Cookies.class) {
                    parasVals[i] = cookies;
                    continue block0;
                }
                if (an.annotationType() != PathVariable.class) continue;
                String pathVaribleKey = ((PathVariable)an).value();
                if (paraTypes[i] == String.class) {
                    parasVals[i] = pathVaribleMap.get(pathVaribleKey);
                    continue block0;
                }
                if (paraTypes[i] == Long.class) {
                    parasVals[i] = Long.valueOf((String)pathVaribleMap.get(pathVaribleKey));
                    continue block0;
                }
                if (paraTypes[i] == Integer.class) {
                    parasVals[i] = Integer.valueOf((String)pathVaribleMap.get(pathVaribleKey));
                    continue block0;
                }
                if (paraTypes[i] == Double.class) {
                    parasVals[i] = Double.valueOf((String)pathVaribleMap.get(pathVaribleKey));
                    continue block0;
                }
                if (paraTypes[i] != Float.class) continue block0;
                parasVals[i] = Float.valueOf((String)pathVaribleMap.get(pathVaribleKey));
                continue block0;
            }
        }
        return parasVals;
    }

    private static Object[] resolveParasOld(RequestNodeWrapper requestNodeWrapper, Map<String, String[]> requestMap, Map<String, String> headerInfo, Map<String, String> cookies, HttpServletRequest request, HttpServletResponse response, String requestURI) {
        RequestNode requestNode = requestNodeWrapper.getRequestNode();
        LinkedHashMap<String, Object> pathVaribleMap = requestNodeWrapper.getParaMap();
        Method method = requestNode.getMethod();
        Class<?>[] paraTypes = method.getParameterTypes();
        int paraLength = paraTypes.length;
        Annotation[][] annotations = method.getParameterAnnotations();
        Annotation[] tmp = null;
        HashMap<Class<? extends Annotation>, Annotation> tmpMap = null;
        Object[] parasVals = new Object[paraLength];
        for (int i = 0; i < paraLength; ++i) {
            if (paraTypes[i] == HttpServletRequest.class) {
                parasVals[i] = request;
                continue;
            }
            if (paraTypes[i] == HttpServletResponse.class) {
                parasVals[i] = response;
                continue;
            }
            tmp = annotations[i];
            tmpMap = new HashMap<Class<? extends Annotation>, Annotation>();
            for (Annotation an : tmp) {
                tmpMap.put(an.annotationType(), an);
            }
            Parameter parameterAno = (Parameter)tmpMap.get(Parameter.class);
            if (parameterAno != null) {
                String parameterKey = parameterAno.value();
                String[] tmpArray = requestMap.get(parameterKey);
                if (tmpArray == null) continue;
                if (tmpArray.length == 1) {
                    parasVals[i] = tmpArray[0];
                    continue;
                }
                parasVals[i] = tmpArray;
                continue;
            }
            if (tmpMap.containsKey(HeaderInfo.class)) {
                parasVals[i] = headerInfo;
                continue;
            }
            if (tmpMap.containsKey(Cookies.class)) {
                parasVals[i] = cookies;
                continue;
            }
            PathVariable pathVariableAnno = (PathVariable)tmpMap.get(PathVariable.class);
            if (pathVariableAnno == null) continue;
            String pathVaribleKey = pathVariableAnno.value();
            if (paraTypes[i] == String.class) {
                parasVals[i] = pathVaribleMap.get(pathVaribleKey);
                continue;
            }
            if (paraTypes[i] == Long.class) {
                parasVals[i] = Long.valueOf((String)pathVaribleMap.get(pathVaribleKey));
                continue;
            }
            if (paraTypes[i] == Integer.class) {
                parasVals[i] = Integer.valueOf((String)pathVaribleMap.get(pathVaribleKey));
                continue;
            }
            if (paraTypes[i] == Double.class) {
                parasVals[i] = Double.valueOf((String)pathVaribleMap.get(pathVaribleKey));
                continue;
            }
            if (paraTypes[i] != Float.class) continue;
            parasVals[i] = Float.valueOf((String)pathVaribleMap.get(pathVaribleKey));
        }
        return parasVals;
    }

    static {
        systemContext = SystemContext.getInstance();
        contextsMap = systemContext.getContextsMap();
    }
}

