/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.core.dbconnection;

import cn.regionsoft.one.common.Logger;
import cn.regionsoft.one.core.H2OContext;
import cn.regionsoft.one.core.dbconnection.SQLConnection;
import cn.regionsoft.one.utils.ThreadData;
import cn.regionsoft.one.utils.ThreadHolder;
import cn.regionsoft.one.utils.TransactionUtil;
import java.sql.SQLException;

public class SQLConnectionManager {
    private static final Logger logger = Logger.getLogger(SQLConnectionManager.class);

    public static SQLConnection getCurrentConnection(H2OContext h2oContext) throws Exception {
        SQLConnection dbConnection = null;
        ThreadHolder holder = ThreadHolder.getInstance();
        ThreadData threadData = holder.getThreadDatas().get();
        dbConnection = TransactionUtil.isInTransaction(h2oContext) ? (SQLConnection)threadData.getTransactionConnection(h2oContext) : (SQLConnection)threadData.getNoTrxConnection(h2oContext);
        return dbConnection;
    }

    public static void releaseConnection(H2OContext h2oContext) {
        if (h2oContext.getConnectionPool() == null) {
            return;
        }
        SQLConnection dbConnection = null;
        ThreadHolder holder = ThreadHolder.getInstance();
        ThreadData threadData = holder.getThreadDatas().get();
        if (TransactionUtil.isInTransaction(h2oContext)) {
            dbConnection = (SQLConnection)threadData.getTransactionConnection(h2oContext);
            if (dbConnection != null) {
                int depth = threadData.getTransactionDepth(h2oContext);
                if (depth <= 1) {
                    threadData.setTransactionDepth(0, h2oContext);
                    threadData.setTransactionConnection(null, h2oContext);
                    try {
                        dbConnection.setAutoCommit(true);
                    }
                    catch (SQLException e) {
                        logger.error(e);
                    }
                    h2oContext.getConnectionPool().releaseConnectionToPool(dbConnection);
                } else {
                    threadData.setTransactionDepth(--depth, h2oContext);
                }
            }
        } else {
            dbConnection = (SQLConnection)threadData.getNoTrxConnection(h2oContext);
            if (dbConnection != null) {
                int depth = threadData.getNonTransactionDepth(h2oContext);
                if (depth <= 1) {
                    threadData.setNonTransactionDepth(0, h2oContext);
                    threadData.setNoTrxConnection(null, h2oContext);
                    h2oContext.getConnectionPool().releaseConnectionToPool(dbConnection);
                } else {
                    threadData.setNonTransactionDepth(--depth, h2oContext);
                }
            }
        }
    }
}

