/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.core.dbconnection;

import cn.regionsoft.one.common.Logger;
import cn.regionsoft.one.core.CommonUtil;
import cn.regionsoft.one.core.ContextConfig;
import cn.regionsoft.one.core.H2OContext;
import cn.regionsoft.one.core.dbconnection.AbstractConnectionPoolImpl;
import cn.regionsoft.one.core.dbconnection.MongoConnection;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import java.util.Arrays;
import java.util.concurrent.LinkedBlockingQueue;

public class MongoConnectionPool
extends AbstractConnectionPoolImpl<MongoConnection> {
    private static final Logger logger = Logger.getLogger(MongoConnectionPool.class);
    private H2OContext h2oContext;
    private MongoClient mongoClient;

    @Override
    public void init(H2OContext h2oContext) throws Exception {
        this.h2oContext = h2oContext;
        ContextConfig config = h2oContext.getConfig();
        String connectStr = config.getConnectStr();
        String[] tmpArray = connectStr.split(":");
        MongoClientOptions.Builder buider = new MongoClientOptions.Builder();
        buider.connectionsPerHost(config.getDbConnPoolSize());
        buider.connectTimeout(1200000);
        buider.maxWaitTime(30000);
        buider.threadsAllowedToBlockForConnectionMultiplier(100);
        buider.maxConnectionIdleTime(0);
        buider.maxConnectionLifeTime(0);
        buider.socketTimeout(0);
        MongoClientOptions myOptions = buider.build();
        if (CommonUtil.isEmpty(config.getUserName()) || CommonUtil.isEmpty(config.getPassword())) {
            this.mongoClient = new MongoClient(Arrays.asList(new ServerAddress(tmpArray[0], Integer.parseInt(tmpArray[1]))), myOptions);
        } else {
            MongoCredential credential = MongoCredential.createCredential((String)config.getUserName(), (String)config.getSchema(), (char[])config.getPassword().toCharArray());
            this.mongoClient = new MongoClient(Arrays.asList(new ServerAddress(tmpArray[0], Integer.parseInt(tmpArray[1]))), credential, myOptions);
        }
        this.connections = new LinkedBlockingQueue(config.getDbConnPoolSize());
        for (int i = 0; i < config.getDbConnPoolSize(); ++i) {
            this.connections.add(this.newConnection());
        }
    }

    @Override
    public MongoConnection newConnection() throws Exception {
        return new MongoConnection(this.mongoClient, this.h2oContext);
    }
}

