/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.core.dbconnection;

import cn.regionsoft.one.common.Logger;
import cn.regionsoft.one.core.dbconnection.ConnectionPool;
import cn.regionsoft.one.core.dbconnection.H2OConnection;
import java.util.Date;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public abstract class AbstractConnectionPoolImpl<T extends H2OConnection>
implements ConnectionPool {
    private static final Logger logger = Logger.getLogger(AbstractConnectionPoolImpl.class);
    protected BlockingQueue<T> connections = new LinkedBlockingQueue<T>(100);

    public T getConnectionFromPool() {
        H2OConnection h2OConnection;
        try {
            H2OConnection connection;
            h2OConnection = connection = (H2OConnection)this.connections.take();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error(e);
            T t = null;
            return t;
        }
        return (T)h2OConnection;
    }

    @Override
    public int avaliable() {
        return this.connections.size();
    }

    @Override
    public void releaseConnectionToPool(H2OConnection poolConnection) {
        H2OConnection tmp = poolConnection;
        tmp.setLastUseDt(new Date());
        this.connections.add(poolConnection);
    }
}

