/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.core.controller;

import cn.regionsoft.one.annotation.InstanceAnoType;
import cn.regionsoft.one.annotation.tag.RequestMapping;
import cn.regionsoft.one.core.CommonUtil;
import cn.regionsoft.one.core.H2OContext;
import cn.regionsoft.one.core.controller.NodeType;
import cn.regionsoft.one.core.controller.RequestNode;
import cn.regionsoft.one.core.controller.RequestNodeWrapper;
import cn.regionsoft.one.core.exception.MultipleControllerMappingException;
import cn.regionsoft.one.core.exception.NoControllerMappingException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;

public class ControllerManager {
    private RequestNode rootNode = new RequestNode(NodeType.PATH);

    public ControllerManager(H2OContext context) {
        this.rootNode.setRelativePath("");
        HashSet<Class<?>> controllers = context.getAnnotatedClassHub().getClassSetByAnnotation(InstanceAnoType.Controller);
        RequestMapping requestMapping = null;
        if (controllers != null) {
            for (Class<?> controller : controllers) {
                requestMapping = controller.getAnnotation(RequestMapping.class);
                this.registerController(controller, requestMapping);
            }
        }
    }

    public RequestNodeWrapper getMatchedRequestNode(String requestURI) throws Exception {
        String[] array;
        ArrayList<String> pathLs = new ArrayList<String>();
        for (String tmp : array = requestURI.split("/")) {
            if (CommonUtil.isEmpty(tmp)) continue;
            pathLs.add(tmp);
        }
        ArrayList<RequestNodeWrapper> matchedNodes = new ArrayList<RequestNodeWrapper>();
        this.checkMatchedRequestNode(this.rootNode, pathLs, 0, null, matchedNodes);
        return ControllerManager.filterReuqestNodeWrapper(requestURI, matchedNodes);
    }

    public static RequestNodeWrapper filterReuqestNodeWrapper(String requestURI, List<RequestNodeWrapper> matchedNodes) throws Exception {
        if (matchedNodes.size() == 0) {
            throw new NoControllerMappingException(requestURI);
        }
        if (matchedNodes.size() > 1) {
            StringBuilder sb = new StringBuilder();
            sb.append("Multiple controller mapping are found \r\n");
            for (RequestNodeWrapper tmp : matchedNodes) {
                sb.append(tmp.getRequestNode().getControllerClass().getName());
                sb.append(".");
                sb.append(tmp.getRequestNode().getMethod().getName());
                sb.append("\r\n");
            }
            throw new MultipleControllerMappingException(sb.toString());
        }
        return matchedNodes.get(0);
    }

    private void checkMatchedRequestNode(RequestNode targetNode, List<String> pathLs, int depth, LinkedHashMap<String, Object> paraMap, List<RequestNodeWrapper> matchedNodes) {
        if (depth == pathLs.size()) {
            if (targetNode.getControllerClass() != null) {
                RequestNodeWrapper requestNodeWrapper = new RequestNodeWrapper();
                requestNodeWrapper.setRequestNode(targetNode);
                requestNodeWrapper.setParaMap(paraMap);
                matchedNodes.add(requestNodeWrapper);
            }
            return;
        }
        if (targetNode.getChilds() == null || targetNode.getChilds().size() == 0) {
            return;
        }
        String relativePath = pathLs.get(depth);
        int nextDepth = depth + 1;
        for (RequestNode requestNode : targetNode.getChilds()) {
            if (requestNode.getNodeType() == NodeType.PATH) {
                if (!relativePath.equals(requestNode.getRelativePath())) continue;
                this.checkMatchedRequestNode(requestNode, pathLs, nextDepth, paraMap, matchedNodes);
                continue;
            }
            if (requestNode.getNodeType() != NodeType.VARIABLE) continue;
            LinkedHashMap<String, Object> tmpMap = new LinkedHashMap<String, Object>();
            if (paraMap != null) {
                tmpMap.putAll(paraMap);
            }
            tmpMap.put(requestNode.getRelativePath(), relativePath);
            this.checkMatchedRequestNode(requestNode, pathLs, nextDepth, tmpMap, matchedNodes);
        }
        ++depth;
    }

    private void registerController(Class<?> controllerClass, RequestMapping requestMapping) {
        String contextPath = null;
        contextPath = requestMapping == null ? "" : requestMapping.value();
        ArrayList<String> pathLs = new ArrayList<String>();
        if (contextPath != null) {
            String[] array;
            for (String tmp : array = contextPath.split("/")) {
                if (CommonUtil.isEmpty(tmp)) continue;
                pathLs.add(tmp);
            }
            RequestNode contextNode = this.refreshNode(this.rootNode, pathLs, 0);
            Method[] methods = controllerClass.getDeclaredMethods();
            RequestMapping methodReqMapping = null;
            for (Method method : methods) {
                methodReqMapping = method.getAnnotation(RequestMapping.class);
                if (methodReqMapping == null) continue;
                contextPath = methodReqMapping.value();
                pathLs.clear();
                for (String tmp : array = contextPath.split("/")) {
                    if (CommonUtil.isEmpty(tmp)) continue;
                    pathLs.add(tmp);
                }
                RequestNode methodNode = this.refreshNode(contextNode, pathLs, 0);
                methodNode.setControllerClass(controllerClass);
                methodNode.setMethod(method);
                methodNode.setRequestMethods(methodReqMapping.method());
                methodNode.setProduces(methodReqMapping.responseHeader());
                methodNode.setReturnType(method.getReturnType());
            }
        }
    }

    private RequestNode refreshNode(RequestNode targetNode, List<String> pathLs, int depth) {
        if (pathLs.size() == depth) {
            return targetNode;
        }
        NodeType noteType = NodeType.PATH;
        String relativePath = pathLs.get(depth);
        if (relativePath.startsWith("${") && relativePath.endsWith("}")) {
            relativePath = relativePath.substring(2, relativePath.length() - 1);
            noteType = NodeType.VARIABLE;
        }
        RequestNode newNode = new RequestNode(noteType);
        newNode.setParent(targetNode);
        newNode.setRelativePath(relativePath);
        List<RequestNode> childs = targetNode.getChilds();
        if (childs == null) {
            childs = new ArrayList<RequestNode>();
            targetNode.setChilds(childs);
        }
        childs.add(newNode);
        return this.refreshNode(newNode, pathLs, ++depth);
    }
}

