/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.core.contextinfo.dto;

import cn.regionsoft.one.annotation.InstanceAnoType;
import cn.regionsoft.one.annotation.NoInstanceAnoType;
import cn.regionsoft.one.annotation.tag.RequestMapping;
import cn.regionsoft.one.common.Logger;
import cn.regionsoft.one.core.AnnotatedClassHub;
import cn.regionsoft.one.core.CommonUtil;
import cn.regionsoft.one.core.EntityManager;
import cn.regionsoft.one.core.H2OContext;
import cn.regionsoft.one.core.SystemContext;
import cn.regionsoft.one.core.contextinfo.ManagedBeanDetailPojo;
import cn.regionsoft.one.core.contextinfo.MethodInfoPojo;
import cn.regionsoft.one.core.contextinfo.dto.ClassWrapper;
import cn.regionsoft.one.core.dbconnection.SQLConnection;
import cn.regionsoft.one.core.dbconnection.SQLConnectionManager;
import cn.regionsoft.one.core.entity.BindColumn;
import cn.regionsoft.one.core.entity.BindObject;
import cn.regionsoft.one.core.entity.SQLEntityManager;
import cn.regionsoft.one.core.ids.IDGenerator;
import cn.regionsoft.one.data.dialet.core.SQLDialet;
import cn.regionsoft.one.data.persistence.H2OEntity;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

public class H2OContextDetail {
    private static final Logger logger = Logger.getLogger(H2OContextDetail.class);
    private String name;
    private boolean persist;
    private List<ManagedBeanDetailPojo> managedBeanDetailPojoLs = new ArrayList<ManagedBeanDetailPojo>();
    private SystemContext systemContext = SystemContext.getInstance();
    private List toPersistBeanData = new ArrayList();
    private List toPersistMethodData = new ArrayList();

    public List<ManagedBeanDetailPojo> getManagedBeanDetailPojoLs() {
        return this.managedBeanDetailPojoLs;
    }

    public H2OContextDetail(H2OContext h2oContext, boolean persist, String name) throws SQLException {
        this.persist = persist;
        this.name = name;
        this.scanInfo(h2oContext);
    }

    private void scanInfo(H2OContext h2oContext) throws SQLException {
        this.managedBeanDetailPojoLs.clear();
        this.toPersistBeanData.clear();
        this.toPersistMethodData.clear();
        AnnotatedClassHub annotatedClassHub = h2oContext.getAnnotatedClassHub();
        HashSet<Class<?>> entities = annotatedClassHub.getClassSetByAnnotation(NoInstanceAnoType.Entity);
        Class<?> managedBeanDetail = null;
        Class<?> methodInfo = null;
        for (Class<?> entity : entities) {
            if (managedBeanDetail != null && methodInfo != null) break;
            if ("ManagedBeanDetail".equals(entity.getSimpleName())) {
                managedBeanDetail = entity;
                continue;
            }
            if (!"MethodInfo".equals(entity.getSimpleName())) continue;
            methodInfo = entity;
        }
        if (managedBeanDetail == null || methodInfo == null) {
            return;
        }
        this.resolveBeans("Entity", entities, managedBeanDetail, methodInfo, this.toPersistBeanData, this.toPersistMethodData);
        this.resolveBeans("Controller", annotatedClassHub.getClassSetByAnnotation(InstanceAnoType.Controller), managedBeanDetail, methodInfo, this.toPersistBeanData, this.toPersistMethodData);
        this.resolveBeans("Component", annotatedClassHub.getClassSetByAnnotation(InstanceAnoType.Component), managedBeanDetail, methodInfo, this.toPersistBeanData, this.toPersistMethodData);
        this.resolveBeans("Resource", annotatedClassHub.getClassSetByAnnotation(InstanceAnoType.Resource), managedBeanDetail, methodInfo, this.toPersistBeanData, this.toPersistMethodData);
        this.resolveBeans("Service", annotatedClassHub.getClassSetByAnnotation(InstanceAnoType.Service), managedBeanDetail, methodInfo, this.toPersistBeanData, this.toPersistMethodData);
        this.resolveBeans("Dao", annotatedClassHub.getClassSetByAnnotation(InstanceAnoType.Dao), managedBeanDetail, methodInfo, this.toPersistBeanData, this.toPersistMethodData);
        if (this.persist) {
            this.persistData(h2oContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void persistData(H2OContext h2oContext) throws SQLException {
        block27: {
            String preparedSql;
            String truncateSql;
            String tableName;
            SQLDialet dialet;
            List<BindColumn> columns;
            BindObject bindObject;
            EntityManager entityManager;
            SQLConnection connection;
            Statement pst;
            PreparedStatement truncatePst;
            block26: {
                truncatePst = null;
                pst = null;
                connection = null;
                entityManager = h2oContext.getEntityManager();
                connection = SQLEntityManager.getConnection(h2oContext);
                connection.setAutoCommit(false);
                bindObject = null;
                columns = null;
                for (Object instance : this.toPersistBeanData) {
                    if (pst == null) {
                        bindObject = entityManager.getBindObject(instance.getClass());
                        dialet = (SQLDialet)h2oContext.getEntityManager().getDialet();
                        tableName = bindObject.getTableName();
                        truncateSql = dialet.getTruncateTableSql(tableName);
                        truncatePst = connection.prepareStatement(truncateSql);
                        truncatePst.executeUpdate();
                        preparedSql = dialet.getInsertSql(bindObject);
                        pst = connection.prepareStatement(preparedSql);
                        columns = bindObject.getAllColumnsExceptVersion();
                    }
                    H2OContextDetail.setPrepareStm((PreparedStatement)pst, columns, instance, bindObject.getVersionColumn());
                    pst.addBatch();
                }
                pst.executeBatch();
                connection.commit();
                CommonUtil.closeQuietly(pst);
                CommonUtil.closeQuietly(truncatePst);
                pst = null;
                try {
                    connection.setAutoCommit(true);
                    break block26;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                break block26;
                catch (Exception e) {
                    try {
                        throw e;
                    }
                    catch (Throwable throwable) {
                        CommonUtil.closeQuietly(pst);
                        CommonUtil.closeQuietly(truncatePst);
                        pst = null;
                        try {
                            connection.setAutoCommit(true);
                        }
                        catch (SQLException e2) {
                            e2.printStackTrace();
                        }
                        SQLConnectionManager.releaseConnection(h2oContext);
                        throw throwable;
                    }
                }
            }
            SQLConnectionManager.releaseConnection(h2oContext);
            connection = SQLEntityManager.getConnection(h2oContext);
            connection.setAutoCommit(false);
            bindObject = null;
            columns = null;
            for (Object instance : this.toPersistMethodData) {
                if (pst == null) {
                    bindObject = entityManager.getBindObject(instance.getClass());
                    dialet = (SQLDialet)h2oContext.getEntityManager().getDialet();
                    tableName = bindObject.getTableName();
                    truncateSql = dialet.getTruncateTableSql(tableName);
                    truncatePst = connection.prepareStatement(truncateSql);
                    truncatePst.executeUpdate();
                    preparedSql = dialet.getInsertSql(bindObject);
                    pst = connection.prepareStatement(preparedSql);
                    columns = bindObject.getAllColumnsExceptVersion();
                }
                H2OContextDetail.setPrepareStm((PreparedStatement)pst, columns, instance, bindObject.getVersionColumn());
                pst.addBatch();
            }
            pst.executeBatch();
            connection.commit();
            try {
                connection.setAutoCommit(true);
            }
            catch (SQLException e) {
                logger.error(e);
            }
            CommonUtil.closeQuietly(pst);
            CommonUtil.closeQuietly(truncatePst);
            SQLConnectionManager.releaseConnection(h2oContext);
            pst = null;
            break block27;
            catch (Exception e) {
                try {
                    logger.error(e);
                    connection.rollback();
                }
                catch (Throwable throwable) {
                    try {
                        connection.setAutoCommit(true);
                    }
                    catch (SQLException e3) {
                        logger.error(e3);
                    }
                    CommonUtil.closeQuietly(pst);
                    CommonUtil.closeQuietly(truncatePst);
                    SQLConnectionManager.releaseConnection(h2oContext);
                    pst = null;
                    throw throwable;
                }
                try {
                    connection.setAutoCommit(true);
                }
                catch (SQLException e4) {
                    logger.error(e4);
                }
                CommonUtil.closeQuietly(pst);
                CommonUtil.closeQuietly(truncatePst);
                SQLConnectionManager.releaseConnection(h2oContext);
                pst = null;
            }
        }
    }

    private static void setPrepareStm(PreparedStatement pst, List<BindColumn> columns, Object instance, BindColumn versionColumn) throws Exception {
        int index = 0;
        Field field = null;
        Object value = null;
        for (BindColumn bindColumn : columns) {
            field = bindColumn.getField();
            field.setAccessible(true);
            value = field.get(instance);
            if (bindColumn.getBindType() == Date.class) {
                if (value == null) {
                    pst.setDate(++index, null);
                    continue;
                }
                Date utilDate = (Date)value;
                Timestamp sqlDate = new Timestamp(utilDate.getTime());
                pst.setTimestamp(++index, sqlDate);
                continue;
            }
            if (bindColumn.getBindType() == Boolean.class) {
                pst.setBoolean(++index, (Boolean)value);
                continue;
            }
            pst.setObject(++index, value);
        }
        if (versionColumn != null) {
            field = versionColumn.getField();
            field.setAccessible(true);
            Integer versionNo = (Integer)field.get(instance);
            versionNo = versionNo == null ? Integer.valueOf(0) : Integer.valueOf(versionNo + 1);
            field.set(instance, versionNo);
            pst.setInt(++index, versionNo);
        }
    }

    private void resolveBeans(String beanType, HashSet<Class<?>> beanSet, Class managedBeanDetail, Class methodInfo, List toPersistBeanData, List toPersistMethodData) {
        ArrayList<ClassWrapper> ls = new ArrayList<ClassWrapper>();
        for (Class<?> beanClass : beanSet) {
            ClassWrapper classWrapper = new ClassWrapper(beanClass);
            ls.add(classWrapper);
        }
        Collections.sort(ls);
        Date now = new Date();
        for (ClassWrapper classWrapper : ls) {
            Class beanClass = classWrapper.getBeanClass();
            try {
                RequestMapping requestMapping;
                if ("Controller".equals(beanType) && classWrapper.getBeanClass().getSimpleName().equals("CombinedRequestController")) continue;
                ManagedBeanDetailPojo managedBeanDetailPojo = new ManagedBeanDetailPojo();
                this.managedBeanDetailPojoLs.add(managedBeanDetailPojo);
                managedBeanDetailPojo.setSystemId("LOCAL");
                managedBeanDetailPojo.setId(IDGenerator.getStringID());
                managedBeanDetailPojo.setContextName(this.name);
                String beanName = beanClass.getName();
                managedBeanDetailPojo.setName(beanClass.getSimpleName());
                managedBeanDetailPojo.setPackageName(beanName.substring(0, beanName.lastIndexOf(".")));
                managedBeanDetailPojo.setBeanType(beanType);
                managedBeanDetailPojo.setSvcType("Local");
                managedBeanDetailPojo.setCreateBy("System");
                managedBeanDetailPojo.setUpdateBy("System");
                managedBeanDetailPojo.setCreateDt(now);
                managedBeanDetailPojo.setUpdateDt(now);
                String baseUrl = "";
                if ("Controller".equals(beanType) && (requestMapping = beanClass.getAnnotation(RequestMapping.class)) != null) {
                    baseUrl = requestMapping.value();
                }
                H2OEntity bean = (H2OEntity)managedBeanDetail.newInstance();
                CommonUtil.copyProperties(managedBeanDetailPojo, bean);
                toPersistBeanData.add(bean);
                for (Method method : beanClass.getDeclaredMethods()) {
                    RequestMapping requestMapping2;
                    MethodInfoPojo methodInfoPojo = new MethodInfoPojo();
                    managedBeanDetailPojo.addMethodInfoPojo(methodInfoPojo);
                    methodInfoPojo.setId(IDGenerator.getStringID());
                    methodInfoPojo.setDetailId(Long.valueOf(managedBeanDetailPojo.getId()));
                    methodInfoPojo.setName(method.getName());
                    if ("Controller".equals(beanType) && (requestMapping2 = method.getAnnotation(RequestMapping.class)) != null) {
                        methodInfoPojo.setUrl(baseUrl + requestMapping2.value());
                    }
                    StringBuilder sb = new StringBuilder("");
                    Class<?>[] parameterTypes = method.getParameterTypes();
                    if (parameterTypes != null) {
                        for (int i = 0; i < parameterTypes.length; ++i) {
                            sb.append(parameterTypes[i].getName());
                            sb.append(" arg");
                            sb.append(i);
                            if (i == parameterTypes.length - 1) continue;
                            sb.append(" , ");
                        }
                    }
                    methodInfoPojo.setInputType(sb.toString());
                    methodInfoPojo.setReturnType(method.getReturnType().getName());
                    methodInfoPojo.setCreateBy("System");
                    methodInfoPojo.setUpdateBy("System");
                    methodInfoPojo.setCreateDt(now);
                    methodInfoPojo.setUpdateDt(now);
                    H2OEntity methodInfoBean = (H2OEntity)methodInfo.newInstance();
                    CommonUtil.copyProperties(methodInfoPojo, methodInfoBean);
                    toPersistMethodData.add(methodInfoBean);
                }
            }
            catch (Exception e) {
                logger.error(e);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

