/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.core.combinedreq;

import cn.regionsoft.one.common.JsonUtil;
import cn.regionsoft.one.core.combinedreq.SingleRequest;
import cn.regionsoft.one.core.combinedreq.SingleResponse;
import cn.regionsoft.one.core.dispatcher.ProcessResponseWrapper;
import cn.regionsoft.one.core.dispatcher.WebRequestProcessor;
import cn.regionsoft.one.web.core.RespCode;
import cn.regionsoft.one.web.wrapper.ResourceResWrapper;
import cn.regionsoft.one.web.wrapper.WebReqWrapper;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SingleRequestThread
implements Callable<SingleResponse> {
    private SingleRequest singleRequest;
    private Map<String, String[]> requestMap = new HashMap<String, String[]>();
    private Map<String, String> headerInfo;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private Map<String, String> cookies;

    public SingleRequestThread(SingleRequest singleRequest, Map<String, String> headerInfo, Map<String, String> cookies, HttpServletRequest request, HttpServletResponse response) {
        this.singleRequest = singleRequest;
        if (request.getParameterMap() != null) {
            this.requestMap.putAll(request.getParameterMap());
        }
        this.headerInfo = headerInfo;
        this.request = request;
        this.response = response;
        this.cookies = cookies;
    }

    @Override
    public SingleResponse call() throws Exception {
        SingleResponse singleResponse = new SingleResponse();
        singleResponse.setRequestId(this.singleRequest.getRequestId());
        try {
            WebReqWrapper webReqWrapper = new WebReqWrapper();
            webReqWrapper.setData(this.singleRequest.getReqData());
            webReqWrapper.setRequestId(this.singleRequest.getRequestId());
            this.requestMap.put("requestStr", new String[]{JsonUtil.objectToJson(webReqWrapper)});
            String pageUrl = this.singleRequest.getPageUrl();
            int paraIndex = pageUrl.indexOf("?");
            String reqUrl = pageUrl;
            if (paraIndex != -1) {
                String[] paraArray;
                reqUrl = pageUrl.substring(0, paraIndex);
                String paras = pageUrl.substring(paraIndex + 1);
                for (String tmp : paraArray = paras.split("&")) {
                    String[] tmpPara = tmp.split("=");
                    if (tmpPara.length != 2) continue;
                    this.requestMap.put(tmpPara[0], new String[]{tmpPara[1]});
                }
            }
            ProcessResponseWrapper prw = WebRequestProcessor.process(reqUrl, this.singleRequest.getMethod(), this.requestMap, this.headerInfo, this.cookies, this.request, this.response);
            String responseMsg = (String)prw.getResponse();
            singleResponse.setResponse(responseMsg);
        }
        catch (Exception e) {
            String responseMsg = JsonUtil.objectToJson(ResourceResWrapper.failResult("Error:", this.singleRequest, RespCode._508));
            singleResponse.setResponse(responseMsg);
        }
        return singleResponse;
    }
}

