/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.core.auth;

import cn.regionsoft.one.common.Logger;
import cn.regionsoft.one.core.CommonUtil;
import cn.regionsoft.one.properties.ConfigUtil;
import cn.regionsoft.one.rpc.common.ServerConstant;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

public class LoginHelper {
    private static final Logger logger = Logger.getLogger(LoginHelper.class);
    public static final String CLAIM_SESSION_ID = "sessionId";
    public static Algorithm ALGORITHM = null;
    public static Long RENEW_GAP = null;

    public static void deleteToken(HttpServletResponse response) {
        Cookie tokenCookie = new Cookie("_token", null);
        tokenCookie.setMaxAge(0);
        tokenCookie.setPath("/");
        response.addCookie(tokenCookie);
    }

    public static void deleteLoginFlag(HttpServletResponse response) {
        Cookie loginFlag = new Cookie("_region_login", null);
        loginFlag.setMaxAge(0);
        loginFlag.setPath("/");
        response.addCookie(loginFlag);
    }

    public static void addToken(String tokenStr, HttpServletResponse response) {
        Cookie tokenCookie = new Cookie("_token", tokenStr);
        tokenCookie.setPath("/");
        tokenCookie.setMaxAge(36000);
        tokenCookie.setHttpOnly(true);
        response.addCookie(tokenCookie);
    }

    public static void addLoginFlag(String userInfo, HttpServletResponse response) {
        Cookie loginFlag = new Cookie("_region_login", userInfo);
        loginFlag.setMaxAge(172800);
        loginFlag.setPath("/");
        loginFlag.setHttpOnly(true);
        response.addCookie(loginFlag);
    }

    public static String generateToken(Long renewGap, Map<String, String> claims, Algorithm algorithm) {
        Date now = new Date();
        Date expireDt = new Date();
        expireDt.setTime(now.getTime() + renewGap);
        JWTCreator.Builder builder = JWT.create().withIssuer("regionsoft").withIssuedAt(now).withExpiresAt(expireDt);
        for (Map.Entry<String, String> entry : claims.entrySet()) {
            builder.withClaim(entry.getKey(), entry.getValue());
        }
        String token = builder.sign(algorithm);
        return token;
    }

    public static String generateToken(Map<String, String> claims) {
        String token = LoginHelper.generateToken(RENEW_GAP, claims, ALGORITHM);
        return token;
    }

    public static DecodedJWT resolveToken(String token) {
        JWTVerifier verifier1 = JWT.require((Algorithm)ALGORITHM).acceptExpiresAt(ServerConstant.SESSION_EXPIRE_GAP / 1000L).build();
        try {
            DecodedJWT decodedJWT = verifier1.verify(token);
            return decodedJWT;
        }
        catch (Exception e) {
            logger.warn(e);
            return null;
        }
    }

    static {
        try {
            String renewGapStr = ConfigUtil.getProperty("token.renew.gap");
            if (CommonUtil.isEmpty(renewGapStr)) {
                renewGapStr = "15";
            }
            RENEW_GAP = Long.valueOf(renewGapStr) * 60000L;
        }
        catch (Exception e) {
            logger.error(e);
        }
        try {
            String key = ConfigUtil.getProperty("jwt.signature");
            if (CommonUtil.isEmpty(key)) {
                key = "OPHgw^H_+gj=";
            }
            ALGORITHM = Algorithm.HMAC256((String)key);
        }
        catch (Exception e) {
            logger.error(e);
        }
    }
}

