/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.core;

import cn.regionsoft.one.caches.LocalCacheUtil;
import cn.regionsoft.one.caches.RedisUtil;
import cn.regionsoft.one.common.Logger;
import cn.regionsoft.one.core.CommonUtil;
import cn.regionsoft.one.core.ContextConfig;
import cn.regionsoft.one.core.H2OContext;
import cn.regionsoft.one.core.SYSEnvSetup;
import cn.regionsoft.one.core.aop.ApplicationListener;
import cn.regionsoft.one.core.aop.BackendErrorLogInterceptor;
import cn.regionsoft.one.core.aop.LifecycleInterceptor;
import cn.regionsoft.one.core.auth.AdvancedSecurityProvider;
import cn.regionsoft.one.core.auth.BasicSecurityProvider;
import cn.regionsoft.one.properties.ConfigUtil;
import cn.regionsoft.one.rpc.client.MicrosvcManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SystemContext {
    private static final Logger logger = Logger.getLogger(SystemContext.class);
    private static SystemContext systemContext = new SystemContext();
    private Map<String, H2OContext> contextsMap = new HashMap<String, H2OContext>();
    private boolean inited = false;
    public static final String DEFAULT_CONTEXT = "DefaultContext";
    private MicrosvcManager microsvcManager;
    private BackendErrorLogInterceptor backendErrorLogInterceptor;
    private AdvancedSecurityProvider advancedSecurityProvider;
    private BasicSecurityProvider basicSecurityProvider;

    private SystemContext() {
    }

    public static SystemContext getInstance() {
        return systemContext;
    }

    synchronized MicrosvcManager getMicrosvcManager() {
        if (this.microsvcManager == null) {
            String zookeeperConnectstr = ConfigUtil.getProperty("rs.microsvc.zookeepers");
            if (CommonUtil.isEmpty(zookeeperConnectstr)) {
                throw new RuntimeException("rs.microsvc.zookeepers is not configured");
            }
            this.microsvcManager = new MicrosvcManager(zookeeperConnectstr);
        }
        return this.microsvcManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ContextConfig ... contextConfigs) {
        block27: {
            try {
                String backendErrorInterceptor;
                String advancedSecurityProviderStr;
                String basicSecurityProviderStr;
                if (this.inited) break block27;
                RedisUtil.init();
                Long start = System.currentTimeMillis();
                String lifecycleInterceptor = ConfigUtil.getProperty("lifecycle.interceptor");
                this.inited = true;
                LifecycleInterceptor lifecycleInterceptorObj = null;
                if (!CommonUtil.isEmpty(lifecycleInterceptor)) {
                    try {
                        Class<?> tmp = Class.forName(lifecycleInterceptor);
                        if (tmp != null) {
                            lifecycleInterceptorObj = (LifecycleInterceptor)tmp.newInstance();
                        }
                    }
                    catch (ClassNotFoundException tmp) {
                    }
                    catch (InstantiationException e) {
                        throw new RuntimeException(e);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (lifecycleInterceptorObj != null) {
                    lifecycleInterceptorObj.beforeInitContext();
                }
                for (ContextConfig contextConfig : contextConfigs) {
                    H2OContext context = new H2OContext(contextConfig, this);
                    this.contextsMap.put(contextConfig.getContextName(), context);
                }
                for (H2OContext context : this.contextsMap.values()) {
                    context.init();
                }
                if (this.microsvcManager != null) {
                    if (this.microsvcManager.getConsumerCount() > 0) {
                        this.microsvcManager.startWatchServices();
                    }
                    if (this.microsvcManager.getProviderCount() > 0) {
                        this.microsvcManager.startMicroSvcServer();
                    }
                }
                if (!CommonUtil.isEmpty(basicSecurityProviderStr = ConfigUtil.getProperty("basic.security.provider"))) {
                    try {
                        Class<?> providerClass = Class.forName(basicSecurityProviderStr);
                        BasicSecurityProvider basicSecurityProvider = (BasicSecurityProvider)systemContext.getManagedBean(providerClass);
                        systemContext.setBasicSecurityProvider(basicSecurityProvider);
                    }
                    catch (ClassNotFoundException e) {
                        logger.warn(e);
                    }
                }
                if (!CommonUtil.isEmpty(advancedSecurityProviderStr = ConfigUtil.getProperty("advanced.security.provider"))) {
                    try {
                        Class<?> providerClass = Class.forName(advancedSecurityProviderStr);
                        AdvancedSecurityProvider advancedSecurityProvider = (AdvancedSecurityProvider)systemContext.getManagedBean(providerClass);
                        systemContext.setAdvancedSecurityProvider(advancedSecurityProvider);
                    }
                    catch (ClassNotFoundException e) {
                        logger.warn(e);
                    }
                }
                if (lifecycleInterceptorObj != null) {
                    lifecycleInterceptorObj.afterInitContext();
                }
                if (!CommonUtil.isEmpty(backendErrorInterceptor = ConfigUtil.getProperty("backend.error.interceptor"))) {
                    try {
                        Class<?> clazz = Class.forName(backendErrorInterceptor);
                        this.backendErrorLogInterceptor = (BackendErrorLogInterceptor)this.getManagedBean(clazz);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        logger.warn(classNotFoundException);
                    }
                }
                logger.debug("init ApplicationListener");
                for (H2OContext context : this.contextsMap.values()) {
                    Set<ApplicationListener> listeners = context.getApplicationListener();
                    for (ApplicationListener listener : listeners) {
                        listener.onApplicationInited(this);
                    }
                }
                logger.debug("init system context within ", System.currentTimeMillis() - start, " milliseconds");
            }
            finally {
                SYSEnvSetup.releaseResource();
            }
        }
    }

    public BackendErrorLogInterceptor getBackendErrorLogInterceptor() {
        return this.backendErrorLogInterceptor;
    }

    public <T> T getManagedBean(Class<T> classType) {
        String cacheKey = "getManagedBean-" + classType.getName();
        Object cached = LocalCacheUtil.get(cacheKey);
        if (cached != null) {
            return (T)cached;
        }
        String contextName = CommonUtil.getTargetContextName(classType);
        if (contextName == null || contextName.trim().equals("")) {
            contextName = DEFAULT_CONTEXT;
        }
        T result = this.getContext(contextName).getManagedBean(classType);
        LocalCacheUtil.put(cacheKey, result);
        return result;
    }

    public <T> T getManagedBean(String classFullName) throws ClassNotFoundException {
        String cacheKey = "getManagedBean-" + classFullName;
        Object cached = LocalCacheUtil.get(cacheKey);
        if (cached != null) {
            return (T)cached;
        }
        Class<?> classType = Class.forName(classFullName, true, this.getClass().getClassLoader());
        Object result = this.getManagedBean(classType);
        LocalCacheUtil.put(cacheKey, result);
        return (T)result;
    }

    public H2OContext getContext(String contextName) {
        return this.contextsMap.get(contextName);
    }

    public Map<String, H2OContext> getContextsMap() {
        return this.contextsMap;
    }

    public AdvancedSecurityProvider getAdvancedSecurityProvider() {
        return this.advancedSecurityProvider;
    }

    public void setAdvancedSecurityProvider(AdvancedSecurityProvider securityProvider) {
        this.advancedSecurityProvider = securityProvider;
    }

    public BasicSecurityProvider getBasicSecurityProvider() {
        return this.basicSecurityProvider;
    }

    public void setBasicSecurityProvider(BasicSecurityProvider basicSecurityProvider) {
        this.basicSecurityProvider = basicSecurityProvider;
    }
}

