/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.core;

import cn.regionsoft.one.core.SYSEnvSetup;
import cn.regionsoft.one.httpserver.SimpleHtmlServer;
import cn.regionsoft.one.properties.ConfigUtil;
import cn.regionsoft.one.standalone.StandaloneServer;
import java.io.FileInputStream;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;

public class RegionSoftServer {
    public static void start() throws Exception {
        SYSEnvSetup.setUp();
        String useHttps = ConfigUtil.getProperty("https");
        if (Boolean.valueOf(useHttps).booleanValue()) {
            RegionSoftServer.startHttpsServer();
        } else {
            RegionSoftServer.startHttpServer();
        }
    }

    public static void startHttpServer() {
        try {
            new SimpleHtmlServer().runHttp(ConfigUtil.getPropertyAsInteger("frontend.port"), ConfigUtil.getProperty("frontend.context"), ConfigUtil.getProperty("frontend.html"));
        }
        catch (Exception e) {
            System.err.println("warning : html server setup error");
        }
        try {
            StandaloneServer ss = new StandaloneServer(ConfigUtil.getProperty("backend.context", ""));
            ss.runHttp();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void startHttpsServer() {
        try {
            new SimpleHtmlServer().runHttps(ConfigUtil.getPropertyAsInteger("frontend.port"), ConfigUtil.getProperty("frontend.context"), ConfigUtil.getProperty("frontend.html"), RegionSoftServer.initSSLEngineKeyManager());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("warning : html server setup error");
        }
        try {
            StandaloneServer ss = new StandaloneServer(ConfigUtil.getProperty("backend.context", ""));
            ss.runHttps(RegionSoftServer.initSSLEngineKeyManager());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static synchronized KeyManagerFactory initSSLEngineKeyManager() throws Exception {
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(ConfigUtil.getProperty("https.algorithm"));
        KeyStore ks = KeyStore.getInstance(ConfigUtil.getProperty("https.algorithm.type"));
        String keyStorePath = ConfigUtil.getProperty("https.keystore.path");
        String keyStorePassword = ConfigUtil.getProperty("https.keystore.password");
        ks.load(new FileInputStream(keyStorePath), keyStorePassword.toCharArray());
        String keyPassword = ConfigUtil.getProperty("https.key.password");
        kmf.init(ks, keyPassword.toCharArray());
        return kmf;
    }
}

