/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.core;

import cn.regionsoft.one.common.Logger;
import cn.regionsoft.one.core.CommonUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class I18nMessageManager {
    public static Logger logger = Logger.getLogger(I18nMessageManager.class);
    private static Map<String, Map<String, String>> propertiesMap = new HashMap<String, Map<String, String>>();
    private static final String DEFAULT = "default";

    public static void loadI18nMessage() {
        try {
            URL i18nFolderUrl = I18nMessageManager.class.getClassLoader().getResource("i18n");
            if (i18nFolderUrl == null) {
                logger.warn("No i18n configuration found");
            } else {
                File i18nFolder = new File(i18nFolderUrl.getFile());
                for (File languageFolder : i18nFolder.listFiles()) {
                    if (languageFolder.isFile()) continue;
                    HashMap<String, String> languageProperties = new HashMap<String, String>();
                    for (File file : languageFolder.listFiles()) {
                        Properties tmpProperties = I18nMessageManager.loadProperties(file);
                        for (Map.Entry<Object, Object> tmpEntry : tmpProperties.entrySet()) {
                            languageProperties.put((String)tmpEntry.getKey(), (String)tmpEntry.getValue());
                        }
                    }
                    propertiesMap.put(languageFolder.getName(), languageProperties);
                }
            }
        }
        catch (Exception e) {
            logger.error(e);
        }
    }

    public static String getMessage(String key) {
        Map<String, String> languageProperties = propertiesMap.get(DEFAULT);
        if (languageProperties == null) {
            logger.error("No i18n configuration found");
        }
        return languageProperties.get(key);
    }

    public static String getMessageWithDefault(String key, String defaultMsg) {
        String result;
        Map<String, String> languageProperties = propertiesMap.get(DEFAULT);
        if (languageProperties == null) {
            logger.error("No i18n configuration found");
        }
        if (CommonUtil.isEmpty(result = languageProperties.get(key))) {
            return defaultMsg;
        }
        return result;
    }

    public static String getMessage(String key, String localeStr) {
        Map<String, String> languageProperties = propertiesMap.get(localeStr);
        if (languageProperties == null) {
            languageProperties = propertiesMap.get(DEFAULT);
        }
        if (languageProperties == null) {
            logger.error("No i18n configuration found");
        }
        return languageProperties.get(key);
    }

    private static Properties loadProperties(File tmp) throws Exception {
        Properties properties;
        Properties properties2 = new Properties();
        Closeable is = null;
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader((InputStream)new FileInputStream(tmp), "utf-8");
            properties2.load(isr);
            properties = properties2;
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                CommonUtil.closeQuietly(isr);
                CommonUtil.closeQuietly(is);
                throw throwable;
            }
        }
        CommonUtil.closeQuietly(isr);
        CommonUtil.closeQuietly(is);
        return properties;
    }
}

