/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.core;

import cn.regionsoft.one.common.Logger;
import cn.regionsoft.one.core.CommonUtil;
import cn.regionsoft.one.core.DBType;
import cn.regionsoft.one.core.EntityManager;
import cn.regionsoft.one.core.H2OContext;
import cn.regionsoft.one.core.H2ODaoI;
import cn.regionsoft.one.core.SystemContext;
import cn.regionsoft.one.core.dbconnection.SQLConnection;
import cn.regionsoft.one.core.dbconnection.SQLConnectionManager;
import cn.regionsoft.one.core.entity.BindColumn;
import cn.regionsoft.one.core.entity.BindObject;
import cn.regionsoft.one.data.dialet.core.SQLDialet;
import cn.regionsoft.one.data.persistence.H2OEntity;
import cn.regionsoft.one.data.persistence.criteria.Condition;
import cn.regionsoft.one.data.persistence.criteria.Operator;
import cn.regionsoft.one.data.persistence.criteria.Query;
import cn.regionsoft.one.properties.ConfigUtil;
import cn.regionsoft.one.utils.MongoHelper;
import cn.regionsoft.one.utils.TransactionUtil;
import com.mongodb.client.MongoCollection;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.Document;

public abstract class H2ODao<T extends H2OEntity, I>
implements H2ODaoI<T, I> {
    private static final Logger logger = Logger.getLogger(H2ODao.class);
    private static boolean showSql = Boolean.valueOf(ConfigUtil.getProperty("show.sql"));

    @Override
    public List<T> findBySelective(T instance) throws Exception {
        List<T> list;
        Class<T> entityClass = this.getEntityClass();
        H2OContext h2oContext = CommonUtil.getTargetContext(entityClass);
        BindObject bindObject = h2oContext.getEntityManager().getBindObject(entityClass);
        if (h2oContext.getConfig().getDbType() == DBType.MONGODB) {
            MongoCollection<Document> collection = MongoHelper.getBindCollection(bindObject.getEntityClass());
            Query query = new Query();
            List<BindColumn> columns = bindObject.getAllColumnsExceptVersion();
            Field field = null;
            Object value = null;
            for (BindColumn bindColumn : columns) {
                field = bindColumn.getField();
                field.setAccessible(true);
                value = field.get(instance);
                if (value == null) continue;
                query.addCondition(new Condition(bindColumn.getName(), Operator.EQ, value));
            }
            return MongoHelper.getList(entityClass, collection, query);
        }
        SQLConnection connection = SQLConnectionManager.getCurrentConnection(h2oContext);
        PreparedStatement ps = null;
        try {
            String tableName = bindObject.getTableName();
            StringBuilder sqlBuf = new StringBuilder("select * from ");
            sqlBuf.append(tableName);
            sqlBuf.append(" where 1=1 ");
            List<BindColumn> columns = bindObject.getAllColumnsExceptVersion();
            Field field = null;
            Object value = null;
            LinkedHashMap<BindColumn, Object> paras = new LinkedHashMap<BindColumn, Object>();
            for (BindColumn bindColumn : columns) {
                field = bindColumn.getField();
                field.setAccessible(true);
                value = field.get(instance);
                if (value == null) continue;
                sqlBuf.append(" and " + bindColumn.getName() + "= ?");
                paras.put(bindColumn, value);
            }
            ps = connection.prepareStatement(sqlBuf.toString());
            Iterator iterator = paras.entrySet().iterator();
            Map.Entry tmpEntry = null;
            BindColumn bindColumn = null;
            int index = 0;
            while (iterator.hasNext()) {
                tmpEntry = iterator.next();
                bindColumn = (BindColumn)tmpEntry.getKey();
                value = tmpEntry.getValue();
                if (bindColumn.getBindType() == Date.class) {
                    if (value == null) {
                        ps.setDate(++index, null);
                        continue;
                    }
                    Date utilDate = (Date)value;
                    Timestamp sqlDate = new Timestamp(utilDate.getTime());
                    ps.setTimestamp(++index, sqlDate);
                    continue;
                }
                if (bindColumn.getBindType() == Boolean.class) {
                    ps.setBoolean(++index, (Boolean)value);
                    continue;
                }
                ps.setObject(++index, value);
            }
            if (showSql) {
                logger.debug(sqlBuf.toString() + " :" + paras.values());
            }
            ResultSet rs = ps.executeQuery();
            list = CommonUtil.resolveResultSet(rs, entityClass, h2oContext);
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                CommonUtil.closeQuietly(ps);
                throw throwable;
            }
        }
        CommonUtil.closeQuietly(ps);
        return list;
    }

    @Override
    public T insert(T instance) throws Exception {
        if (instance == null) {
            throw new RuntimeException("Instance is null");
        }
        H2OContext h2oContext = CommonUtil.getTargetContext(instance.getClass());
        BindObject bindObject = h2oContext.getEntityManager().getBindObject(instance.getClass());
        if (bindObject.getIdColumn() == null) {
            throw new Exception("No Id column defined :" + bindObject.getEntityClass().getName());
        }
        if (h2oContext.getConfig().getDbType() == DBType.MONGODB) {
            MongoHelper.insert(instance);
            return instance;
        }
        SQLDialet dialet = (SQLDialet)h2oContext.getEntityManager().getDialet();
        String preparedSql = dialet.getInsertSql(bindObject);
        if (showSql) {
            logger.debug(preparedSql + " :" + instance);
        }
        SQLConnection connection = SQLConnectionManager.getCurrentConnection(h2oContext);
        PreparedStatement pst = null;
        try {
            pst = connection.prepareStatement(preparedSql);
            List<BindColumn> columns = bindObject.getAllColumnsExceptVersion();
            H2ODao.setPrepareStm(pst, columns, instance, bindObject.getVersionColumn());
            pst.execute();
            T t = instance;
            return t;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            CommonUtil.closeQuietly(pst);
        }
    }

    @Override
    public T find(I id) throws Exception {
        if (id == null) {
            throw new RuntimeException("Id is null");
        }
        Class<T> cls = this.getEntityClass();
        H2OContext h2oContext = CommonUtil.getTargetContext(cls);
        BindObject bindObject = h2oContext.getEntityManager().getBindObject(cls);
        if (bindObject.getIdColumn() == null) {
            throw new Exception("No Id column defined :" + bindObject.getEntityClass().getName());
        }
        if (h2oContext.getConfig().getDbType() == DBType.MONGODB) {
            H2OEntity instance = (H2OEntity)MongoHelper.find(id, cls);
            return (T)instance;
        }
        String transactionCacheKey = null;
        if (TransactionUtil.isInTransaction(h2oContext)) {
            transactionCacheKey = cls.getName() + "_" + id;
        }
        if (TransactionUtil.transactionCacheConstainKey(h2oContext, transactionCacheKey)) {
            return (T)((H2OEntity)TransactionUtil.getTransactionCache(h2oContext, transactionCacheKey));
        }
        SQLDialet dialet = (SQLDialet)h2oContext.getEntityManager().getDialet();
        String sql = dialet.getFindSql(bindObject);
        SQLConnection connection = SQLConnectionManager.getCurrentConnection(h2oContext);
        T result = this.getObject(sql, new Object[]{id}, cls, h2oContext);
        if (TransactionUtil.isInTransaction(h2oContext)) {
            TransactionUtil.addTransactionCache(h2oContext, transactionCacheKey, result);
        }
        return result;
    }

    public List<T> findAll() throws Exception {
        Class<T> cls = this.getEntityClass();
        H2OContext h2oContext = CommonUtil.getTargetContext(cls);
        BindObject bindObject = h2oContext.getEntityManager().getBindObject(cls);
        if (bindObject.getIdColumn() == null) {
            throw new Exception("No Id column defined :" + bindObject.getEntityClass().getName());
        }
        if (h2oContext.getConfig().getDbType() == DBType.MONGODB) {
            return MongoHelper.findAll(cls);
        }
        SQLDialet dialet = (SQLDialet)h2oContext.getEntityManager().getDialet();
        String sql = dialet.getFindAllSql(bindObject);
        return this.getList(sql, null, cls, h2oContext);
    }

    @Override
    public Integer delete(I id) throws Exception {
        if (id == null) {
            throw new RuntimeException("Id is null");
        }
        Class<T> cls = this.getEntityClass();
        H2OContext h2oContext = CommonUtil.getTargetContext(cls);
        if (h2oContext.getConfig().getDbType() == DBType.MONGODB) {
            MongoHelper.delete(id, cls);
        } else {
            BindObject bindObject = h2oContext.getEntityManager().getBindObject(cls);
            if (bindObject.getIdColumn() == null) {
                throw new Exception("No Id column defined :" + bindObject.getEntityClass().getName());
            }
            SQLDialet dialet = (SQLDialet)h2oContext.getEntityManager().getDialet();
            String sql = dialet.getDeleteSql(bindObject);
            SQLConnection connection = SQLConnectionManager.getCurrentConnection(h2oContext);
            this.excute(sql, new Object[]{id}, connection);
            String transactionCacheKey = null;
            if (TransactionUtil.isInTransaction(h2oContext)) {
                transactionCacheKey = cls.getName() + "_" + id;
                TransactionUtil.removeTransactionCacheByKey(h2oContext, transactionCacheKey);
            }
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Integer softDelete(I id, String operator) throws Exception {
        PreparedStatement ps;
        int result;
        block6: {
            Class<T> entityClass = this.getEntityClass();
            H2OContext h2oContext = CommonUtil.getTargetContext(entityClass);
            BindObject bindObject = h2oContext.getEntityManager().getBindObject(entityClass);
            result = 0;
            if (h2oContext.getConfig().getDbType() == DBType.MONGODB) {
                MongoCollection<Document> mongoCollection = MongoHelper.getBindCollection(bindObject.getEntityClass());
                return result;
            }
            SQLConnection connection = SQLConnectionManager.getCurrentConnection(h2oContext);
            ps = null;
            try {
                String tableName = bindObject.getTableName();
                StringBuilder sqlBuf = new StringBuilder("update ");
                sqlBuf.append(tableName);
                sqlBuf.append(" set softDelete=1 where id=? and softDelete = 0");
                ps = connection.prepareStatement(sqlBuf.toString());
                ps.setObject(1, id);
                if (showSql) {
                    logger.debug(sqlBuf.toString() + " :" + id);
                }
                result = ps.executeUpdate();
                String transactionCacheKey = null;
                if (!TransactionUtil.isInTransaction(h2oContext)) break block6;
                transactionCacheKey = entityClass.getName() + "_" + String.valueOf(id);
                TransactionUtil.removeTransactionCacheByKey(h2oContext, transactionCacheKey);
            }
            catch (Exception e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    CommonUtil.closeQuietly(ps);
                    throw throwable;
                }
            }
        }
        CommonUtil.closeQuietly(ps);
        return result;
    }

    @Override
    public T update(T instance) throws Exception {
        H2OContext h2oContext = CommonUtil.getTargetContext(instance.getClass());
        BindObject bindObject = h2oContext.getEntityManager().getBindObject(instance.getClass());
        LinkedHashMap<String, BindColumn> dueToUpDateMap = new LinkedHashMap<String, BindColumn>();
        Collection<BindColumn> collection = bindObject.getColumns().values();
        for (BindColumn tmp : collection) {
            dueToUpDateMap.put(tmp.getName(), tmp);
        }
        this.subUpdate(instance, dueToUpDateMap, h2oContext, bindObject);
        return instance;
    }

    @Override
    public T update(T instance, String ... columns) throws Exception {
        HashSet<String> set = new HashSet<String>();
        for (String tmp : columns) {
            set.add(tmp);
        }
        return this.update(instance, set);
    }

    @Override
    public T update(T instance, Set<String> columns) throws Exception {
        H2OContext h2oContext = CommonUtil.getTargetContext(instance.getClass());
        BindObject bindObject = h2oContext.getEntityManager().getBindObject(instance.getClass());
        LinkedHashMap<String, BindColumn> dueToUpDateMap = new LinkedHashMap<String, BindColumn>();
        Collection<BindColumn> collection = bindObject.getColumns().values();
        for (BindColumn bindColumn : collection) {
            if (!columns.contains(bindColumn.getName())) continue;
            dueToUpDateMap.put(bindColumn.getName(), bindColumn);
            columns.remove(bindColumn.getName());
        }
        Iterator<Object> iterator = columns.iterator();
        if (iterator.hasNext()) {
            String string = (String)iterator.next();
            throw new Exception("Update exception :column " + string + " is not found ," + instance.getClass().getName());
        }
        return this.subUpdate(instance, dueToUpDateMap, h2oContext, bindObject);
    }

    private T subUpdate(T instance, Map<String, BindColumn> dueToUpDateMap, H2OContext h2oContext, BindObject bindObject) throws Exception {
        if (bindObject.getIdColumn() == null) {
            throw new Exception("No Id column defined :" + bindObject.getEntityClass().getName());
        }
        Field idField = bindObject.getIdColumn().getField();
        idField.setAccessible(true);
        Object idVal = idField.get(instance);
        if (idVal == null) {
            throw new Exception("Primary key value is empty");
        }
        int paraLength = dueToUpDateMap.size() + 1;
        if (bindObject.getVersionColumn() != null) {
            ++paraLength;
        }
        if (h2oContext.getConfig().getDbType() == DBType.MONGODB) {
            if (bindObject.getVersionColumn() != null) {
                dueToUpDateMap.put(bindObject.getVersionColumn().getName(), bindObject.getVersionColumn());
            }
            MongoHelper.update(idVal, instance, dueToUpDateMap);
            return instance;
        }
        SQLDialet dialet = (SQLDialet)h2oContext.getEntityManager().getDialet();
        String sql = dialet.getUpdateSql(bindObject, dueToUpDateMap);
        SQLConnection connection = SQLConnectionManager.getCurrentConnection(h2oContext);
        Object[] sqlParas = new Object[paraLength];
        int index = 0;
        Field tmpField = null;
        Object tmpVal = null;
        for (BindColumn bindColumn : dueToUpDateMap.values()) {
            tmpField = bindColumn.getField();
            sqlParas[index] = tmpVal = tmpField.get(instance);
            ++index;
        }
        if (bindObject.getVersionColumn() != null) {
            tmpField = bindObject.getVersionColumn().getField();
            sqlParas[index] = tmpVal = tmpField.get(instance);
            ++index;
        }
        tmpField = bindObject.getIdColumn().getField();
        sqlParas[index] = tmpVal = tmpField.get(instance);
        this.excute(sql, sqlParas, connection);
        String transactionCacheKey = null;
        if (TransactionUtil.isInTransaction(h2oContext)) {
            transactionCacheKey = instance.getClass().getName() + "_" + idVal.toString();
            TransactionUtil.removeTransactionCacheByKey(h2oContext, transactionCacheKey);
        }
        return instance;
    }

    private void excute(String preparedSql, Object[] sqlParas, SQLConnection connection) throws Exception {
        if (showSql) {
            logger.debug(preparedSql, " , paras:", sqlParas);
        }
        PreparedStatement ps = null;
        try {
            ps = connection.prepareStatement(preparedSql);
            if (sqlParas != null) {
                for (int i = 0; i < sqlParas.length; ++i) {
                    if (sqlParas[i] instanceof Date) {
                        if (sqlParas[i] == null) {
                            ps.setDate(i + 1, null);
                            continue;
                        }
                        Date tmpDt = (Date)sqlParas[i];
                        Timestamp sqlDt = new Timestamp(tmpDt.getTime());
                        ps.setTimestamp(i + 1, sqlDt);
                        continue;
                    }
                    if (sqlParas[i] instanceof Boolean) {
                        ps.setBoolean(i + 1, (Boolean)sqlParas[i]);
                        continue;
                    }
                    ps.setObject(i + 1, sqlParas[i]);
                }
            }
            ps.execute();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            CommonUtil.closeQuietly(ps);
        }
    }

    protected Class<T> getEntityClass() throws ClassNotFoundException {
        Class<?> orignalClass = null;
        String proxyClassName = this.getClass().getName();
        int index = proxyClassName.indexOf("$$");
        orignalClass = index == -1 ? this.getClass() : Class.forName(proxyClassName.substring(0, index));
        Type[] types = ((ParameterizedType)orignalClass.getGenericSuperclass()).getActualTypeArguments();
        if (types.length != 0) {
            return (Class)types[0];
        }
        return null;
    }

    private T getObject(String preparedSql, Object[] sqlParas, Class<T> resultMapClass, H2OContext h2oContext) throws Exception {
        List<T> ls = this.getList(preparedSql, sqlParas, resultMapClass, h2oContext);
        if (ls.size() == 0) {
            return null;
        }
        if (ls.size() == 1) {
            return (T)((H2OEntity)ls.get(0));
        }
        throw new Exception("More than one records are found");
    }

    protected List<T> getList(String preparedSql, Object[] sqlParas, Class<T> resultMapClass, H2OContext h2oContext) throws Exception {
        return this.getGenericList(preparedSql, sqlParas, resultMapClass, h2oContext);
    }

    protected List<?> getGenericList(String preparedSql, Object[] sqlParas, Class<?> resultMapClass, H2OContext h2oContext) throws Exception {
        List<?> list;
        if (showSql) {
            logger.debug(preparedSql, " , paras:", sqlParas);
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            List<?> ls;
            SQLConnection connection = SQLConnectionManager.getCurrentConnection(h2oContext);
            ps = connection.prepareStatement(preparedSql);
            if (sqlParas != null) {
                for (int i = 0; i < sqlParas.length; ++i) {
                    if (sqlParas[i] instanceof Date) {
                        if (sqlParas[i] == null) {
                            ps.setDate(i + 1, null);
                            continue;
                        }
                        Date tmpDt = (Date)sqlParas[i];
                        Timestamp sqlDt = new Timestamp(tmpDt.getTime());
                        ps.setTimestamp(i + 1, sqlDt);
                        continue;
                    }
                    if (sqlParas[i] instanceof Boolean) {
                        ps.setBoolean(i + 1, (Boolean)sqlParas[i]);
                        continue;
                    }
                    ps.setObject(i + 1, sqlParas[i]);
                }
            }
            rs = ps.executeQuery();
            list = ls = CommonUtil.resolveResultSet(rs, resultMapClass, h2oContext);
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                CommonUtil.closeQuietly(rs);
                CommonUtil.closeQuietly(ps);
                throw throwable;
            }
        }
        CommonUtil.closeQuietly(rs);
        CommonUtil.closeQuietly(ps);
        return list;
    }

    public List<T> getListByIds(Long[] ids) throws Exception {
        String tableName = this.getBindTableName();
        StringBuilder sqlBuf = new StringBuilder("select * from ");
        sqlBuf.append(tableName);
        sqlBuf.append(" where id in (");
        for (int i = 0; i < ids.length; ++i) {
            sqlBuf.append(ids[i]);
            if (i == ids.length - 1) continue;
            sqlBuf.append(",");
        }
        sqlBuf.append(")");
        return this.getEntityList(sqlBuf.toString());
    }

    private static void setPrepareStm(PreparedStatement pst, List<BindColumn> columns, Object instance, BindColumn versionColumn) throws Exception {
        int index = 0;
        Field field = null;
        Object value = null;
        for (BindColumn bindColumn : columns) {
            field = bindColumn.getField();
            field.setAccessible(true);
            value = field.get(instance);
            if (bindColumn.getBindType() == Date.class) {
                if (value == null) {
                    pst.setDate(++index, null);
                    continue;
                }
                Date utilDate = (Date)value;
                Timestamp sqlDate = new Timestamp(utilDate.getTime());
                pst.setTimestamp(++index, sqlDate);
                continue;
            }
            if (bindColumn.getBindType() == Boolean.class) {
                pst.setBoolean(++index, (Boolean)value);
                continue;
            }
            pst.setObject(++index, value);
        }
        if (versionColumn != null) {
            field = versionColumn.getField();
            field.setAccessible(true);
            Integer versionNo = (Integer)field.get(instance);
            versionNo = versionNo == null ? Integer.valueOf(0) : Integer.valueOf(versionNo + 1);
            field.set(instance, versionNo);
            pst.setInt(++index, versionNo);
        }
    }

    protected List<T> getEntityList(String preparedSql, Object[] sqlParas) throws Exception {
        return this.getEntityList(preparedSql, sqlParas, null, null);
    }

    protected List<T> getEntityList(String preparedSql) throws Exception {
        return this.getEntityList(preparedSql, null, null, null);
    }

    protected <G> List<G> getGenericList(String preparedSql, Object[] sqlParas, Class<G> resultClass, Integer pageNo, Integer pageSize) throws Exception {
        Class<T> entityClass = this.getEntityClass();
        H2OContext h2oContext = CommonUtil.getTargetContext(entityClass);
        SQLDialet dialet = (SQLDialet)h2oContext.getEntityManager().getDialet();
        preparedSql = dialet.getPagenationQuery(preparedSql, pageNo, pageSize);
        return this.getGenericList(preparedSql, sqlParas, resultClass, h2oContext);
    }

    protected <G> List<G> getGenericList(String preparedSql, Object[] sqlParas, Class<G> resultClass) throws Exception {
        return this.getGenericList(preparedSql, sqlParas, resultClass, null, null);
    }

    protected <G> List<G> getGenericList(String preparedSql, Class<G> resultClass) throws Exception {
        return this.getGenericList(preparedSql, null, resultClass, null, null);
    }

    protected List<T> getEntityList(String preparedSql, Object[] sqlParas, Integer pageNo, Integer pageSize) throws Exception {
        Class<T> entityClass = this.getEntityClass();
        H2OContext h2oContext = CommonUtil.getTargetContext(entityClass);
        SQLDialet dialet = (SQLDialet)h2oContext.getEntityManager().getDialet();
        preparedSql = dialet.getPagenationQuery(preparedSql, pageNo, pageSize);
        return this.getList(preparedSql, sqlParas, entityClass, h2oContext);
    }

    protected T getEntity(String preparedSql, Object[] sqlParas) throws Exception {
        List<T> ls = this.getEntityList(preparedSql, sqlParas);
        if (ls.size() == 0) {
            return null;
        }
        if (ls.size() == 1) {
            return (T)((H2OEntity)ls.get(0));
        }
        throw new Exception("More than one records are found");
    }

    protected EntityManager getEntityManager() {
        try {
            Class<T> entityClass = this.getEntityClass();
            return CommonUtil.getEntityManager(entityClass);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String getBindTableName() {
        try {
            Class<T> entityClass = this.getEntityClass();
            H2OContext h2oContext = CommonUtil.getTargetContext(entityClass);
            BindObject bindObject = h2oContext.getEntityManager().getBindObject(entityClass);
            if (bindObject.getIdColumn() == null) {
                throw new RuntimeException("No Id column defined :" + entityClass.getName());
            }
            String tableName = bindObject.getTableName();
            return tableName;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected MongoCollection<Document> getBindCollection() {
        try {
            Class<T> entityClass = this.getEntityClass();
            return MongoHelper.getBindCollection(entityClass);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void excute(String preparedSql, Object[] sqlParas) throws Exception {
        Class<T> entityClass = this.getEntityClass();
        H2OContext h2oContext = CommonUtil.getTargetContext(entityClass);
        SQLConnection connection = SQLConnectionManager.getCurrentConnection(h2oContext);
        this.excute(preparedSql, sqlParas, connection);
    }

    protected H2OContext getDefaultContext() {
        H2OContext h2oContext = SystemContext.getInstance().getContext("DefaultContext");
        return h2oContext;
    }
}

