/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.core;

import cn.regionsoft.one.annotation.Controller;
import cn.regionsoft.one.annotation.Job;
import cn.regionsoft.one.annotation.MicroConsumer;
import cn.regionsoft.one.annotation.MicroProvider;
import cn.regionsoft.one.annotation.tag.AfterAutowired;
import cn.regionsoft.one.annotation.tag.Autowired;
import cn.regionsoft.one.caches.aop.CacheListener;
import cn.regionsoft.one.caches.aop.CachesListener;
import cn.regionsoft.one.common.Logger;
import cn.regionsoft.one.core.AnnotatedClassHub;
import cn.regionsoft.one.core.ClassProxy;
import cn.regionsoft.one.core.CommonUtil;
import cn.regionsoft.one.core.ContextConfig;
import cn.regionsoft.one.core.DBType;
import cn.regionsoft.one.core.EntityManager;
import cn.regionsoft.one.core.SystemContext;
import cn.regionsoft.one.core.aop.AOPListener;
import cn.regionsoft.one.core.aop.ApplicationListener;
import cn.regionsoft.one.core.aop.impl.H2OAop;
import cn.regionsoft.one.core.aop.impl.TransactionListener;
import cn.regionsoft.one.core.controller.ControllerManager;
import cn.regionsoft.one.core.controller.RequestNodeWrapper;
import cn.regionsoft.one.core.dbconnection.ConnectionPool;
import cn.regionsoft.one.core.dbconnection.H2OConnection;
import cn.regionsoft.one.core.entity.CloudDBEntityManager;
import cn.regionsoft.one.core.entity.MongoEntityManager;
import cn.regionsoft.one.core.entity.SQLEntityManager;
import cn.regionsoft.one.core.threads.InitConnnectionPoolTask;
import cn.regionsoft.one.core.threads.ScanContextClassesTask;
import cn.regionsoft.one.rpc.client.MicrosvcManager;
import cn.regionsoft.one.rpc.client.RpcProxy;
import cn.regionsoft.one.schedule.ScheduleManager;
import cn.regionsoft.one.tool.ThreadPool;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;

public class H2OContext {
    private static final Logger logger = Logger.getLogger(H2OContext.class);
    private String contextName = null;
    private ConnectionPool connectionPool;
    private Map<Class<?>, Object> classInstanceMap = new ConcurrentHashMap();
    private Set<ApplicationListener> applicationListener = new HashSet<ApplicationListener>();
    private AnnotatedClassHub annotatedClassHub = null;
    private EntityManager entityManager = null;
    private ControllerManager controllerManager = null;
    private ClassProxy cglibInterceptor = new H2OAop();
    private ContextConfig config;
    private List<AOPListener> aopListeners = new ArrayList<AOPListener>();
    private Set<Class<?>> needInstanceClass = null;
    private SystemContext systemContext = null;
    private final Semaphore semp = new Semaphore(1);

    public H2OContext(ContextConfig config, SystemContext systemContext) {
        this.config = config;
        this.systemContext = systemContext;
        this.contextName = config.getContextName();
        this.onCreate();
    }

    public ContextConfig getConfig() {
        return this.config;
    }

    public Set<ApplicationListener> getApplicationListener() {
        return this.applicationListener;
    }

    private void onCreate() {
        this.annotatedClassHub = new AnnotatedClassHub();
        HashSet contextClasses = null;
        try {
            InitConnnectionPoolTask poolTask = new InitConnnectionPoolTask(this);
            Future<ConnectionPool> poolTaskResult = ThreadPool.getInstance().submitQuickTask(poolTask);
            ScanContextClassesTask contextClassesTask = new ScanContextClassesTask(this);
            Future contextClassesTaskResult = ThreadPool.getInstance().submitQuickTask(contextClassesTask);
            this.connectionPool = poolTaskResult.get();
            contextClasses = (HashSet)contextClassesTaskResult.get();
            if (this.connectionPool == null) {
                logger.warn("Connection pool init failed");
            }
            if (contextClasses == null) {
                throw new Exception("System context scan failed");
            }
        }
        catch (Exception e) {
            logger.error(e);
        }
        this.needInstanceClass = this.annotatedClassHub.init(contextClasses, this.contextName);
    }

    void init() {
        if (DBType.CLOUDDB == this.config.getDbType()) {
            this.entityManager = new CloudDBEntityManager(this);
            this.entityManager.init();
        } else if (DBType.MONGODB == this.config.getDbType()) {
            this.entityManager = new MongoEntityManager(this);
            this.entityManager.init();
        } else {
            this.entityManager = new SQLEntityManager(this);
            this.entityManager.init();
        }
        this.aopListeners.add(new TransactionListener());
        this.aopListeners.add(new CachesListener());
        this.aopListeners.add(new CacheListener());
        this.controllerManager = new ControllerManager(this);
        if (this.config.getAopListeners() != null) {
            for (AOPListener aopListener : this.config.getAopListeners()) {
                this.aopListeners.add(aopListener);
            }
        }
        this.initClassesInstance(this.needInstanceClass);
    }

    public RequestNodeWrapper getMatchedRequestNode(String requestURI) throws Exception {
        return this.controllerManager.getMatchedRequestNode(requestURI);
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    private void initClassesInstance(Set<Class<?>> xframeManagedClassSet) {
        for (Class<?> tmp : xframeManagedClassSet) {
            try {
                this.initIfNoManagedBean(tmp, null, null);
            }
            catch (Exception e) {
                logger.error(e);
            }
        }
    }

    private <T> T initIfNoManagedBean(Class<T> contextManagedClass, Field field, Object parentInstance) throws Exception {
        String tmpName;
        H2OContext h2oContext;
        if (contextManagedClass.isInterface()) {
            if (contextManagedClass.isAnnotation()) {
                return null;
            }
            MicroConsumer microConsumer = field.getAnnotation(MicroConsumer.class);
            if (microConsumer != null) {
                return (T)this.createRemoteProxy(field, contextManagedClass, microConsumer);
            }
            Autowired autowired = field.getAnnotation(Autowired.class);
            if (autowired == null) {
                throw new Exception("not able to create instance," + contextManagedClass.getName());
            }
            contextManagedClass = autowired.targetClass();
        }
        if ((h2oContext = this.systemContext.getContext(tmpName = CommonUtil.getTargetContextName(contextManagedClass))) == null) {
            throw new RuntimeException("Context not found :" + tmpName + " - " + contextManagedClass.getName());
        }
        Map<Class<?>, Object> tmpMap = h2oContext.getClassInstanceMap();
        Object instance = tmpMap.get(contextManagedClass);
        if (instance != null) {
            return (T)instance;
        }
        try {
            MicroProvider microProvider = contextManagedClass.getAnnotation(MicroProvider.class);
            if (microProvider != null) {
                Class<?>[] interfaces = contextManagedClass.getInterfaces();
                if (interfaces.length == 0) {
                    throw new RuntimeException("no interface found for mocro provider. class:" + contextManagedClass.getName());
                }
                if (interfaces.length > 1) {
                    throw new RuntimeException("more than one interface found for mocro provider. class:" + contextManagedClass.getName());
                }
                instance = contextManagedClass.newInstance();
                this.registerProvider(interfaces[0], microProvider, instance);
            } else {
                instance = contextManagedClass.isAnnotationPresent(Controller.class) ? contextManagedClass.newInstance() : this.cglibInterceptor.proxyCglibClass(contextManagedClass);
            }
            this.autowired(contextManagedClass, instance, parentInstance);
            this.initJobs(contextManagedClass, instance, parentInstance);
            try {
                Method[] methods;
                for (Method method : methods = contextManagedClass.getDeclaredMethods()) {
                    if (!method.isAnnotationPresent(AfterAutowired.class)) continue;
                    method.setAccessible(true);
                    method.invoke(instance, new Object[0]);
                }
            }
            catch (Exception e) {
                logger.error(e);
            }
            tmpMap.put(contextManagedClass, instance);
            if (instance instanceof ApplicationListener) {
                h2oContext.getApplicationListener().add((ApplicationListener)instance);
            }
        }
        catch (Exception e) {
            logger.error(e);
        }
        return (T)instance;
    }

    private void initJobs(Class<?> contextManagedClass, Object result, Object refObj) throws Exception {
        Method[] methods;
        for (Method method : methods = contextManagedClass.getDeclaredMethods()) {
            Job job = method.getAnnotation(Job.class);
            if (job == null) continue;
            ScheduleManager scheduleManager = ScheduleManager.getInstance();
            scheduleManager.initNewJob(job, method, result);
        }
    }

    public Map<Class<?>, Object> getClassInstanceMap() {
        return this.classInstanceMap;
    }

    private void autowired(Class<?> xframeManagedClass, Object target, Object refObj) {
        Field[] fields;
        for (Field field : fields = xframeManagedClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Autowired.class) && !field.isAnnotationPresent(MicroConsumer.class)) continue;
            try {
                String refObjClassName;
                int index;
                if (Modifier.isFinal(field.getModifiers())) continue;
                boolean filled = false;
                if (refObj != null && (index = (refObjClassName = refObj.getClass().getName()).indexOf("$$")) != -1 && (refObjClassName = refObjClassName.substring(0, index)).equals(field.getType().getName())) {
                    field.setAccessible(true);
                    field.set(target, refObj);
                    filled = true;
                }
                if (filled) continue;
                Object tmp = this.initIfNoManagedBean(field.getType(), field, target);
                field.setAccessible(true);
                field.set(target, tmp);
            }
            catch (Exception e) {
                logger.error(e);
            }
        }
        Class<?> parentClass = xframeManagedClass.getSuperclass();
        if (parentClass != Object.class) {
            this.autowired(parentClass, target, refObj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T getManagedBean(Class<T> xframeManagedClass) {
        Object result = this.classInstanceMap.get(xframeManagedClass);
        if (result != null) {
            return (T)result;
        }
        try {
            this.semp.acquire();
            T t = this.initIfNoManagedBean(xframeManagedClass, null, null);
            return t;
        }
        catch (Exception e) {
            logger.error(e);
            T t = null;
            return t;
        }
        finally {
            this.semp.release();
        }
    }

    public H2OConnection getConnectionFromPool() {
        return this.connectionPool.getConnectionFromPool();
    }

    public ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    public H2OConnection newConnection() throws Exception {
        return this.connectionPool.newConnection();
    }

    public int poolAvailableSize() {
        return this.connectionPool.avaliable();
    }

    public AnnotatedClassHub getAnnotatedClassHub() {
        return this.annotatedClassHub;
    }

    public String getContextName() {
        return this.contextName;
    }

    public void addAopListener(AOPListener aopListener) {
        this.aopListeners.add(aopListener);
    }

    public List<AOPListener> getAopListeners() {
        return this.aopListeners;
    }

    private Object createRemoteProxy(Field field, Class interfaceClass, MicroConsumer microConsumer) {
        MicrosvcManager microsvcManager = this.systemContext.getMicrosvcManager();
        microsvcManager.plusConsumer();
        RpcProxy rpcProxy = microsvcManager.getRpcProxy();
        if (rpcProxy == null) {
            rpcProxy = new RpcProxy(microsvcManager);
            microsvcManager.setRpcProxy(rpcProxy);
        }
        String registerEndpoint = "/regionsoft/microsvc/" + microConsumer.group() + "/" + interfaceClass.getName() + "/" + microConsumer.version() + "/providers";
        microsvcManager.registerConsumer(registerEndpoint);
        return rpcProxy.create(field.getType(), registerEndpoint);
    }

    public void registerProvider(Class remoteInterface, MicroProvider microProvider, Object resourceBean) {
        MicrosvcManager microsvcManager = this.systemContext.getMicrosvcManager();
        microsvcManager.plusProvider();
        String registerEndpoint = "/regionsoft/microsvc/" + microProvider.group() + "/" + remoteInterface.getName() + "/" + microProvider.version() + "/providers";
        microsvcManager.getRpcHandlerMap().put(registerEndpoint, resourceBean);
    }
}

