/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.core;

import cn.regionsoft.one.annotation.InstanceAnoType;
import cn.regionsoft.one.annotation.NoInstanceAnoType;
import cn.regionsoft.one.caches.LocalCacheUtil;
import cn.regionsoft.one.common.Constants;
import cn.regionsoft.one.common.JsonUtil;
import cn.regionsoft.one.common.Logger;
import cn.regionsoft.one.core.Assert;
import cn.regionsoft.one.core.EntityManager;
import cn.regionsoft.one.core.H2OContext;
import cn.regionsoft.one.core.RequestInfoHolder;
import cn.regionsoft.one.core.SystemContext;
import cn.regionsoft.one.core.auth.dto.RequestInfoDto;
import cn.regionsoft.one.core.entity.BindColumn;
import cn.regionsoft.one.core.entity.BindObject;
import cn.regionsoft.one.data.dialet.core.SQLDialet;
import cn.regionsoft.one.data.persistence.H2OEntity;
import cn.regionsoft.one.data.persistence.Text;
import cn.regionsoft.one.enums.LocaleStr;
import cn.regionsoft.one.reflect.MethodMeta;
import cn.regionsoft.one.reflect.enums.ReturnClassType;
import cn.regionsoft.one.standalone.RegionHttpRequest;
import cn.regionsoft.one.standalone.RegionHttpResponse;
import cn.regionsoft.one.standalone.fileupload.RegionFileItem;
import cn.regionsoft.one.standalone.fileupload.UploadResolver;
import cn.regionsoft.one.utils.ThreadData;
import cn.regionsoft.one.utils.ThreadHolder;
import cn.regionsoft.one.web.wrapper.WebReqWrapper;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.LocalVariableAttribute;
import javassist.bytecode.MethodInfo;
import javax.activation.MimetypesFileTypeMap;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.lang.text.StrSubstitutor;

public class CommonUtil {
    private static final Logger logger = Logger.getLogger(CommonUtil.class);
    private static final String EMPTY_STR = "";
    private static final String targetContextStr = "targetContext";
    private static ConcurrentHashMap<Class<?>, HashMap<String, Field>> classTypeCache = new ConcurrentHashMap();
    private static final String injStr = "'|and|exec|insert|select|delete|count|*|%|chr|mid|master|truncate|char|declare|;|or|-|+|,";
    private static final String[] injStra = "'|and|exec|insert|select|delete|count|*|%|chr|mid|master|truncate|char|declare|;|or|-|+|,".split("\\|");
    private static final char[] CHARACTERS = "123456789ABCDEFGHJKLMNPQRSTUVWXYZ".toCharArray();

    public static <T extends Annotation> T getFieldAnnotation(Field field, Class<T> annotationClass) {
        return field.getDeclaredAnnotation(annotationClass);
    }

    public static WebReqWrapper resolveWebReqWrapper(String requestStr) {
        WebReqWrapper webReqWrapper = JsonUtil.jsonToBean(requestStr, WebReqWrapper.class);
        if (webReqWrapper == null) {
            return null;
        }
        RequestInfoDto requestInfoDto = RequestInfoHolder.getInstance().getRequestInfo();
        requestInfoDto.setRequestId(webReqWrapper.getRequestId());
        requestInfoDto.setRsAppId(webReqWrapper.getRsAppId());
        return webReqWrapper;
    }

    public static SimpleDateFormat getSimpleDateFormat(String pattern, LocaleStr localeStr) {
        ThreadHolder threadHolder = ThreadHolder.getInstance();
        ThreadData threadData = threadHolder.getThreadDatas().get();
        if (threadData == null) {
            threadData = new ThreadData();
            threadHolder.getThreadDatas().set(threadData);
        }
        return threadData.getSimpleDateFormat(pattern, localeStr.name());
    }

    public static SimpleDateFormat getSimpleDateFormat(String pattern) {
        return CommonUtil.getSimpleDateFormat(pattern, LocaleStr.cn);
    }

    public static String boolToStr(Boolean value) {
        if (value == null) {
            return null;
        }
        if (value.booleanValue()) {
            return "1";
        }
        return "0";
    }

    public static Boolean strToBool(String value) {
        if (value == null) {
            return null;
        }
        if (value.equals("1")) {
            return true;
        }
        return false;
    }

    public static String longToStr(Long value) {
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }

    public static Long strToLong(String value) {
        if (value == null) {
            return null;
        }
        return Long.valueOf(value);
    }

    public static <T extends Enum> T getEnumByName(String name, Class<T> ennumClass) {
        Enum[] arrays;
        for (Enum tmp : arrays = (Enum[])ennumClass.getEnumConstants()) {
            if (!tmp.name().equals(name)) continue;
            return (T)tmp;
        }
        return null;
    }

    public static Properties loadProperties(File tmp) throws Exception {
        Properties properties;
        Properties newP = new Properties();
        FileInputStream is = null;
        try {
            is = new FileInputStream(tmp);
            newP.load(is);
            properties = newP;
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                CommonUtil.closeQuietly(is);
                throw throwable;
            }
        }
        CommonUtil.closeQuietly(is);
        return properties;
    }

    public static Properties loadProperties(InputStream is) throws Exception {
        Properties newP = new Properties();
        try {
            newP.load(is);
            Properties properties = newP;
            return properties;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            CommonUtil.closeQuietly(is);
        }
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().equals(EMPTY_STR);
    }

    public static boolean isEmpty(Object source) {
        return source == null;
    }

    public static boolean isNotEmpty(String source) {
        return !CommonUtil.isEmpty(source);
    }

    private static Annotation getInstanceAnoType(Class<?> classType) {
        Annotation annotation = null;
        for (InstanceAnoType s : InstanceAnoType.values()) {
            annotation = classType.getDeclaredAnnotation(s.getClassType());
            if (annotation == null) continue;
            return annotation;
        }
        Class<?> parentClass = classType.getSuperclass();
        if (parentClass != Object.class && parentClass != null) {
            return CommonUtil.getInstanceAnoType(parentClass);
        }
        return null;
    }

    private static Annotation getNoInstanceAnoType(Class<?> classType) {
        Annotation annotation = null;
        for (NoInstanceAnoType s : NoInstanceAnoType.values()) {
            annotation = classType.getDeclaredAnnotation(s.getClassType());
            if (annotation == null) continue;
            return annotation;
        }
        Class<?> parentClass = classType.getSuperclass();
        if (parentClass != Object.class && parentClass != null) {
            return CommonUtil.getNoInstanceAnoType(parentClass);
        }
        return null;
    }

    public static String getTargetContextName(Class<?> classType) {
        Method[] methods;
        Annotation annotation = CommonUtil.getInstanceAnoType(classType);
        if (annotation == null) {
            annotation = CommonUtil.getNoInstanceAnoType(classType);
        }
        if (annotation == null) {
            return null;
        }
        for (Method tmp : methods = annotation.getClass().getDeclaredMethods()) {
            if (!tmp.getName().equals(targetContextStr)) continue;
            try {
                return (String)tmp.invoke((Object)annotation, new Object[0]);
            }
            catch (Exception e) {
                logger.error(e);
            }
        }
        return null;
    }

    public static H2OContext getTargetContext(Class<?> classType) {
        String cacheKey = "getTargetContext-" + classType.getName();
        Object cached = LocalCacheUtil.get(cacheKey);
        if (cached != null) {
            return (H2OContext)cached;
        }
        String contextName = CommonUtil.getTargetContextName(classType);
        H2OContext h2oContext = SystemContext.getInstance().getContext(contextName);
        LocalCacheUtil.put(cacheKey, h2oContext);
        return h2oContext;
    }

    public static H2OContext getTargetContextByClassName(String classFullName) throws ClassNotFoundException {
        String cacheKey = "getTargetContext-" + classFullName;
        Object cached = LocalCacheUtil.get(cacheKey);
        if (cached != null) {
            return (H2OContext)cached;
        }
        Class<?> classType = Class.forName(classFullName);
        String contextName = CommonUtil.getTargetContextName(classType);
        H2OContext h2oContext = SystemContext.getInstance().getContext(contextName);
        LocalCacheUtil.put(cacheKey, h2oContext);
        return h2oContext;
    }

    public static EntityManager getEntityManager(Class<? extends H2OEntity> classType) {
        String contextName = CommonUtil.getTargetContextName(classType);
        H2OContext h2oContext = SystemContext.getInstance().getContext(contextName);
        return h2oContext.getEntityManager();
    }

    public static void resolveAllFields(Class<?> targetClass, List<Field> allFields) {
        Field[] fields;
        for (Field field : fields = targetClass.getDeclaredFields()) {
            field.setAccessible(true);
            allFields.add(field);
        }
        Class<?> parentClass = targetClass.getSuperclass();
        if (parentClass != Object.class) {
            CommonUtil.resolveAllFields(parentClass, allFields);
        }
    }

    public static String getColumnsSql(BindObject bindObject, SQLDialet dialet) {
        StringBuilder sb = new StringBuilder();
        if (bindObject.getIdColumn() != null) {
            CommonUtil.appendColumnSql(bindObject.getIdColumn(), dialet, sb, true);
        }
        Map<String, BindColumn> columns = bindObject.getColumns();
        for (BindColumn tmp : columns.values()) {
            CommonUtil.appendColumnSql(tmp, dialet, sb, false);
        }
        if (bindObject.getVersionColumn() != null) {
            CommonUtil.appendColumnSql(bindObject.getVersionColumn(), dialet, sb, false);
        }
        String result = sb.toString();
        result = result.substring(0, result.length() - 1);
        return result;
    }

    private static void appendColumnSql(BindColumn bindColumn, SQLDialet dialet, StringBuilder sb, boolean isPrimary) {
        sb.append(bindColumn.getName());
        sb.append(" ");
        if (bindColumn.getField().isAnnotationPresent(Text.class)) {
            sb.append(dialet.getSqlStrForTextField());
        } else {
            sb.append(SQLDialet.getSqlStrByFieldType(dialet, bindColumn.getBindType()));
            if (bindColumn.getLength() != 0) {
                sb.append("(");
                sb.append(bindColumn.getLength());
                sb.append(")");
            }
        }
        if (isPrimary) {
            sb.append(" PRIMARY KEY ");
        }
        sb.append(",");
    }

    public static <T> List<T> resolveResultSet(ResultSet rs, Class<T> resultClass, H2OContext h2oContext) throws Exception {
        if (resultClass == String.class || resultClass == Long.class || resultClass == Integer.class) {
            return CommonUtil.resolveResultSetForBasicType(rs, resultClass);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        HashMap<String, BindColumn> metaMap = CommonUtil.getClassMapping(resultClass, h2oContext);
        Object tmpObject = null;
        Field field = null;
        BindColumn bindColumn = null;
        Object tmpValue = null;
        while (rs.next()) {
            tmpObject = resultClass.newInstance();
            result.add(tmpObject);
            for (Map.Entry<String, BindColumn> entry : metaMap.entrySet()) {
                bindColumn = entry.getValue();
                field = bindColumn.getField();
                field.setAccessible(true);
                try {
                    rs.findColumn(entry.getKey());
                }
                catch (Exception e) {
                    continue;
                }
                if (bindColumn.getBindType() == Date.class) {
                    Timestamp sqlDate = rs.getTimestamp(entry.getKey());
                    if (sqlDate != null) {
                        Date utilDate = new Date(sqlDate.getTime());
                        tmpValue = utilDate;
                    } else {
                        tmpValue = null;
                    }
                    field.set(tmpObject, tmpValue);
                    continue;
                }
                tmpValue = rs.getObject(entry.getKey());
                if (tmpValue == null) {
                    field.set(tmpObject, null);
                    continue;
                }
                if (tmpValue.getClass() != bindColumn.getBindType()) {
                    Number x;
                    if (tmpValue.getClass() == BigDecimal.class) {
                        x = (BigDecimal)tmpValue;
                        tmpValue = ((BigDecimal)x).longValue();
                        if (bindColumn.getBindType() == Integer.class) {
                            tmpValue = Integer.parseInt(String.valueOf(tmpValue));
                        }
                    } else if (tmpValue.getClass() == Integer.class) {
                        x = (Integer)tmpValue;
                        if (bindColumn.getBindType() == Long.class) {
                            tmpValue = new Long(((Integer)x).intValue());
                        }
                    }
                }
                field.set(tmpObject, tmpValue);
            }
        }
        return result;
    }

    private static <T> List<T> resolveResultSetForBasicType(ResultSet rs, Class<T> resultClass) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        while (rs.next()) {
            Object tmpValue = null;
            if (resultClass == String.class) {
                tmpValue = rs.getString(1);
            } else if (resultClass == Long.class) {
                tmpValue = rs.getLong(1);
            } else if (resultClass == Integer.class) {
                tmpValue = rs.getInt(1);
            }
            result.add((String)tmpValue);
        }
        return result;
    }

    private static HashMap<String, BindColumn> getClassMapping(Class<?> resultClass, H2OContext h2oContext) {
        HashMap<String, BindColumn> map = new HashMap<String, BindColumn>();
        BindObject bindObject = h2oContext.getEntityManager().getEntityToTableCache().get(resultClass);
        if (bindObject == null) {
            bindObject = new BindObject(resultClass);
            h2oContext.getEntityManager().getEntityToTableCache().put(resultClass, bindObject);
        }
        Map<String, BindColumn> bindColumnsMap = bindObject.getColumns();
        BindColumn tmpColumn = bindObject.getIdColumn();
        if (tmpColumn != null) {
            map.put(tmpColumn.getName(), tmpColumn);
        }
        if ((tmpColumn = bindObject.getVersionColumn()) != null) {
            map.put(tmpColumn.getName(), tmpColumn);
        }
        for (BindColumn tmp : bindColumnsMap.values()) {
            map.put(tmp.getName(), tmp);
        }
        return map;
    }

    public static String instanceToString(Object obj, Boolean complex) {
        if (obj == null) {
            return "null";
        }
        ArrayList<Field> allFields = new ArrayList<Field>();
        StringBuilder sb = new StringBuilder(EMPTY_STR);
        if (complex.booleanValue()) {
            sb.append(obj.getClass().getName());
            sb.append("{");
            sb.append("\r\n");
            CommonUtil.resolveAllFields(obj.getClass(), allFields);
            Field field = null;
            String space1 = "         ";
            String space2 = " ";
            int length = allFields.size();
            for (int i = 0; i < length; ++i) {
                try {
                    field = (Field)allFields.get(i);
                    field.setAccessible(true);
                    Object val = field.get(obj);
                    sb.append(space1);
                    sb.append(field.getType().getSimpleName());
                    sb.append(space2);
                    sb.append(field.getName());
                    sb.append(":");
                    sb.append(val);
                    if (i == length - 1) break;
                    sb.append(",");
                    sb.append("\r\n");
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            sb.append("\r\n");
            sb.append("}");
        } else {
            sb.append(obj.getClass().getSimpleName());
            sb.append(":");
            CommonUtil.resolveAllFields(obj.getClass(), allFields);
            Field field = null;
            int length = allFields.size();
            for (int i = 0; i < length; ++i) {
                try {
                    field = (Field)allFields.get(i);
                    field.setAccessible(true);
                    Object val = field.get(obj);
                    sb.append(field.getName());
                    sb.append(":");
                    sb.append(val);
                    if (i == length - 1) break;
                    sb.append(",");
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return sb.toString();
    }

    public static void copyProperties(Object src, Object target) {
        Class<?> srcClass = src.getClass();
        HashMap<String, Field> srcFieldMap = CommonUtil.resolveClassFieldMapWithCache(srcClass);
        Class<?> targetClass = target.getClass();
        HashMap<String, Field> targetFieldMap = CommonUtil.resolveClassFieldMapWithCache(targetClass);
        for (Map.Entry<String, Field> entry : srcFieldMap.entrySet()) {
            String key = entry.getKey();
            Field srcField = entry.getValue();
            Field targetField = targetFieldMap.get(key);
            if (targetField == null) continue;
            try {
                if (targetField.getType() != srcField.getType()) {
                    Object tmp;
                    if (targetField.getType() == String.class && srcField.getType() == Long.class) {
                        tmp = (Long)srcField.get(src);
                        if (tmp == null) continue;
                        targetField.set(target, String.valueOf(tmp));
                        continue;
                    }
                    if (targetField.getType() == Long.class && srcField.getType() == String.class) {
                        tmp = (String)srcField.get(src);
                        targetField.set(target, Long.valueOf((String)tmp));
                        continue;
                    }
                    if (targetField.getType() == String.class && srcField.getType() == Boolean.class) {
                        tmp = (Boolean)srcField.get(src);
                        targetField.set(target, ((Boolean)tmp).booleanValue() ? "1" : "0");
                        continue;
                    }
                    if (targetField.getType() != Boolean.class || srcField.getType() != String.class) continue;
                    tmp = (String)srcField.get(src);
                    targetField.set(target, "1".equals(tmp));
                    continue;
                }
                targetField.set(target, srcField.get(src));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static HashMap<String, Field> resolveClassFieldMapWithCache(Class<?> classType) {
        HashMap<String, Field> cachedMap = classTypeCache.get(classType);
        if (cachedMap != null) {
            return cachedMap;
        }
        HashMap<String, Field> fieldMap = CommonUtil.resolveClassFieldMap(classType);
        classTypeCache.put(classType, fieldMap);
        return fieldMap;
    }

    private static HashMap<String, Field> resolveClassFieldMap(Class<?> classType) {
        Field[] fields;
        if (Object.class == classType) {
            return null;
        }
        HashMap<String, Field> fieldMap = new HashMap<String, Field>();
        for (Field field : fields = classType.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            fieldMap.put(field.getName(), field);
        }
        Class<?> superClass = classType.getSuperclass();
        HashMap<String, Field> superFieldMap = CommonUtil.resolveClassFieldMap(superClass);
        if (superFieldMap != null) {
            superFieldMap.putAll(fieldMap);
            return superFieldMap;
        }
        return fieldMap;
    }

    public static <T, X> List<T> copyListProperties(List<X> obj, Class<T> c) {
        if (obj == null) {
            return null;
        }
        Object target = null;
        ArrayList<Object> result = new ArrayList<Object>();
        for (X tmp : obj) {
            try {
                target = c.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            CommonUtil.copyProperties(tmp, target);
            result.add(target);
        }
        return result;
    }

    public static String toUpcaseOf1stChar(String source) {
        if (source == null || source.length() == 0) {
            return source;
        }
        return source.substring(0, 1).toUpperCase() + source.substring(1);
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Exception e) {
            logger.error(e);
        }
    }

    public static void closeQuietly(AutoCloseable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Exception e) {
            logger.error(e);
        }
    }

    public static void copyFile(String srcFile, String targetFile) throws Exception {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        FileChannel fcin = null;
        FileChannel fcout = null;
        try {
            fis = new FileInputStream(srcFile);
            fos = new FileOutputStream(targetFile);
            fcin = fis.getChannel();
            fcout = fos.getChannel();
            ByteBuffer buffer = ByteBuffer.allocate(1024);
            while (true) {
                buffer.clear();
                int r = fcin.read(buffer);
                if (r == -1) break;
                buffer.flip();
                fcout.write(buffer);
            }
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                CommonUtil.closeQuietly(fcout);
                CommonUtil.closeQuietly(fcin);
                CommonUtil.closeQuietly(fos);
                CommonUtil.closeQuietly(fis);
                throw throwable;
            }
        }
        CommonUtil.closeQuietly(fcout);
        CommonUtil.closeQuietly(fcin);
        CommonUtil.closeQuietly(fos);
        CommonUtil.closeQuietly(fis);
    }

    public static void copyFile(File srcFile, File targetFile) throws Exception {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        FileChannel fcin = null;
        FileChannel fcout = null;
        try {
            fis = new FileInputStream(srcFile);
            fos = new FileOutputStream(targetFile);
            fcin = fis.getChannel();
            fcout = fos.getChannel();
            ByteBuffer buffer = ByteBuffer.allocate(1024);
            while (true) {
                buffer.clear();
                int r = fcin.read(buffer);
                if (r == -1) break;
                buffer.flip();
                fcout.write(buffer);
            }
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                CommonUtil.closeQuietly(fcout);
                CommonUtil.closeQuietly(fcin);
                CommonUtil.closeQuietly(fos);
                CommonUtil.closeQuietly(fis);
                throw throwable;
            }
        }
        CommonUtil.closeQuietly(fcout);
        CommonUtil.closeQuietly(fcin);
        CommonUtil.closeQuietly(fos);
        CommonUtil.closeQuietly(fis);
    }

    public static void copyFileToDirectory(File srcFile, File outputFolder) throws Exception {
        File outputFile = new File(outputFolder.getAbsolutePath() + Constants.SYSTEM_SEPERATOR + srcFile.getName());
        CommonUtil.copyFile(srcFile, outputFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String zipFolder(String folderPath) throws Exception {
        File folder = new File(folderPath);
        if (!folder.exists()) {
            throw new FileNotFoundException(folderPath);
        }
        String zipPath = folderPath + ".zip";
        File zipFile = new File(zipPath);
        if (zipFile.exists()) {
            zipFile.delete();
        }
        String folderName = folder.getName();
        ZipOutputStream out = null;
        try {
            out = new ZipOutputStream(new FileOutputStream(zipPath));
            byte[] buf = new byte[1024];
            CommonUtil.zipFolder(folder, out, buf, folderName);
        }
        catch (Throwable throwable) {
            CommonUtil.closeQuietly(out);
            throw throwable;
        }
        CommonUtil.closeQuietly(out);
        return zipPath;
    }

    private static void zipFolder(File folder, ZipOutputStream out, byte[] buf, String baseDir) throws IOException {
        for (File file : folder.listFiles()) {
            if (file.isDirectory()) {
                CommonUtil.zipFolder(file, out, buf, baseDir + Constants.SYSTEM_SEPERATOR + file.getName());
                continue;
            }
            CommonUtil.zipFile(file, out, buf, baseDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zipFile(File file, ZipOutputStream out, byte[] buf, String baseDir) throws IOException {
        FileInputStream in = null;
        try {
            int len;
            in = new FileInputStream(file);
            out.putNextEntry(new ZipEntry(baseDir + Constants.SYSTEM_SEPERATOR + file.getName()));
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        finally {
            out.closeEntry();
            CommonUtil.closeQuietly(in);
        }
    }

    public static void deleteFolderOrFile(File file) {
        File[] files;
        if (file == null || !file.exists()) {
            return;
        }
        if (file.isFile()) {
            file.delete();
            return;
        }
        for (File tmp : files = file.listFiles()) {
            CommonUtil.deleteFolderOrFile(tmp);
        }
        file.delete();
    }

    public static String getRequestIp(HttpServletRequest request) {
        String remoteAddr = request.getRemoteAddr();
        String forwarded = request.getHeader("X-Forwarded-For");
        String realIp = request.getHeader("X-Real-IP");
        String ip = null;
        if (realIp == null) {
            ip = forwarded == null ? remoteAddr : remoteAddr + "/" + forwarded.split(",")[0];
        } else if (realIp.equals(forwarded)) {
            ip = realIp;
        } else {
            if (forwarded != null) {
                forwarded = forwarded.split(",")[0];
            }
            ip = realIp + "/" + forwarded;
        }
        return ip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void downloadFile(HttpServletResponse response, String downLoadPath, String fileName) {
        block19: {
            if (response instanceof RegionHttpResponse) {
                ((RegionHttpResponse)response).handleFile(downLoadPath, false, fileName);
                return;
            }
            if (downLoadPath == null) {
                response.setStatus(404);
                return;
            }
            File file = new File(downLoadPath);
            if (!file.exists()) {
                response.setStatus(404);
                return;
            }
            response.reset();
            if (fileName == null) {
                fileName = file.getName();
            }
            String contentType = new MimetypesFileTypeMap().getContentType(file);
            response.setContentType(contentType);
            try {
                response.addHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(fileName, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                try {
                    response.addHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(fileName, "UTF-16"));
                }
                catch (UnsupportedEncodingException e1) {
                    logger.error(e1);
                }
            }
            FileInputStream fileInputStream = null;
            BufferedInputStream bufferedInputStream = null;
            fileInputStream = new FileInputStream(file);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            int size = 0;
            byte[] b = new byte[4096];
            while ((size = bufferedInputStream.read(b)) != -1) {
                response.getOutputStream().write(b, 0, size);
            }
            try {
                response.getOutputStream().flush();
            }
            catch (IOException e) {
                logger.error(e);
            }
            CommonUtil.closeQuietly(bufferedInputStream);
            CommonUtil.closeQuietly(fileInputStream);
            break block19;
            catch (Exception e) {
                try {
                    logger.warn(e);
                }
                catch (Throwable throwable) {
                    try {
                        response.getOutputStream().flush();
                    }
                    catch (IOException e2) {
                        logger.error(e2);
                    }
                    CommonUtil.closeQuietly(bufferedInputStream);
                    CommonUtil.closeQuietly(fileInputStream);
                    throw throwable;
                }
                try {
                    response.getOutputStream().flush();
                }
                catch (IOException e3) {
                    logger.error(e3);
                }
                CommonUtil.closeQuietly(bufferedInputStream);
                CommonUtil.closeQuietly(fileInputStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void viewFile(HttpServletResponse response, String downLoadPath, String fileName) {
        block19: {
            if (response instanceof RegionHttpResponse) {
                ((RegionHttpResponse)response).handleFile(downLoadPath, true, fileName);
                return;
            }
            if (downLoadPath == null) {
                response.setStatus(404);
                return;
            }
            File file = new File(downLoadPath);
            if (!file.exists()) {
                response.setStatus(404);
                return;
            }
            response.reset();
            if (fileName == null) {
                fileName = file.getName();
            }
            String contentType = new MimetypesFileTypeMap().getContentType(file);
            response.setContentType(contentType);
            try {
                response.addHeader("Content-Disposition", "inline; filename=" + URLEncoder.encode(fileName, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                try {
                    response.addHeader("Content-Disposition", "inline; filename=" + URLEncoder.encode(fileName, "UTF-16"));
                }
                catch (UnsupportedEncodingException e1) {
                    logger.error(e1);
                }
            }
            FileInputStream fileInputStream = null;
            BufferedInputStream bufferedInputStream = null;
            fileInputStream = new FileInputStream(file);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            int size = 0;
            byte[] b = new byte[4096];
            while ((size = bufferedInputStream.read(b)) != -1) {
                response.getOutputStream().write(b, 0, size);
            }
            try {
                response.getOutputStream().flush();
            }
            catch (IOException e) {
                logger.error(e);
            }
            CommonUtil.closeQuietly(bufferedInputStream);
            CommonUtil.closeQuietly(fileInputStream);
            break block19;
            catch (Exception e) {
                try {
                    logger.warn(e);
                }
                catch (Throwable throwable) {
                    try {
                        response.getOutputStream().flush();
                    }
                    catch (IOException e2) {
                        logger.error(e2);
                    }
                    CommonUtil.closeQuietly(bufferedInputStream);
                    CommonUtil.closeQuietly(fileInputStream);
                    throw throwable;
                }
                try {
                    response.getOutputStream().flush();
                }
                catch (IOException e3) {
                    logger.error(e3);
                }
                CommonUtil.closeQuietly(bufferedInputStream);
                CommonUtil.closeQuietly(fileInputStream);
            }
        }
    }

    public static List<FileItem> resolveUploadFileInfo(Map<String, String> reqMap, HttpServletRequest request) throws Exception {
        ArrayList<FileItem> files;
        block5: {
            block4: {
                files = new ArrayList<FileItem>();
                if (!(request instanceof RegionHttpRequest)) break block4;
                RegionHttpRequest regionHttpRequest = (RegionHttpRequest)request;
                UploadResolver uploadResolver = new UploadResolver();
                if (regionHttpRequest.getUploadMsg() == null) break block5;
                String tmpFilePath = Constants.FILE_SERVER_ROOT + Constants.SYSTEM_SEPERATOR + "tmp" + Constants.SYSTEM_SEPERATOR + regionHttpRequest.getUploadMsg().getFileName();
                List<RegionFileItem> fileItemLs = uploadResolver.resolveUpload(tmpFilePath);
                for (RegionFileItem item : fileItemLs) {
                    if (!item.isFile()) {
                        reqMap.put(item.getFieldName(), item.getString());
                        continue;
                    }
                    files.add(item);
                }
                break block5;
            }
            DiskFileItemFactory factory = new DiskFileItemFactory();
            File cacheFolder = new File(Constants.FILE_SERVER_ROOT + Constants.SYSTEM_SEPERATOR + "tmp");
            factory.setRepository(cacheFolder);
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            List items = upload.parseRequest(request);
            for (FileItem item : items) {
                if (item.isFormField()) {
                    reqMap.put(item.getFieldName(), item.getString());
                    continue;
                }
                files.add(item);
            }
        }
        return files;
    }

    public static String constructErrorStr(Object ... objs) {
        StringBuilder buf = new StringBuilder();
        buf.append(CommonUtil.lineNumber());
        for (Object obj : objs) {
            if (obj instanceof Throwable) {
                buf.append(CommonUtil.constructStackTrace((Throwable)obj));
                continue;
            }
            if (obj instanceof Object[]) {
                buf.append("[");
                Object[] array = (Object[])obj;
                for (int i = 0; i < array.length; ++i) {
                    buf.append(array[i]);
                    if (i == array.length - 1) continue;
                    buf.append(",");
                }
                buf.append("]");
                continue;
            }
            buf.append(obj);
        }
        return buf.toString();
    }

    public static String lineNumber() {
        StackTraceElement[] threadTrackArray = Thread.currentThread().getStackTrace();
        if (threadTrackArray.length > 3) {
            return ":" + Integer.toString(threadTrackArray[3].getLineNumber());
        }
        return EMPTY_STR;
    }

    public static String constructStackTrace(Throwable t) {
        try {
            return CommonUtil.getStackTrace(t);
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public static String getStackTrace(Throwable aThrowable) throws Exception {
        String string;
        StringWriter stack = null;
        PrintWriter printWriter = null;
        try {
            stack = new StringWriter();
            printWriter = new PrintWriter(stack);
            aThrowable.printStackTrace(printWriter);
            string = ((Object)stack).toString();
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                CommonUtil.closeQuietly(printWriter);
                CommonUtil.closeQuietly(stack);
                throw throwable;
            }
        }
        CommonUtil.closeQuietly(printWriter);
        CommonUtil.closeQuietly(stack);
        return string;
    }

    public static byte[] intToByte4(int i) {
        byte[] targets = new byte[4];
        targets[3] = (byte)(i & 0xFF);
        targets[2] = (byte)(i >> 8 & 0xFF);
        targets[1] = (byte)(i >> 16 & 0xFF);
        targets[0] = (byte)(i >> 24 & 0xFF);
        return targets;
    }

    public static int byte4ToInt(byte[] bytes, int off) {
        int b0 = bytes[off] & 0xFF;
        int b1 = bytes[off + 1] & 0xFF;
        int b2 = bytes[off + 2] & 0xFF;
        int b3 = bytes[off + 3] & 0xFF;
        return b0 << 24 | b1 << 16 | b2 << 8 | b3;
    }

    public static String getCookie(HttpServletRequest request, String cookieKey) {
        if (request instanceof RegionHttpRequest) {
            return ((RegionHttpRequest)request).getCookiesMap().get(cookieKey);
        }
        Cookie[] cookies = request.getCookies();
        String loginToken = null;
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(cookieKey)) continue;
                loginToken = cookie.getValue();
                break;
            }
        }
        return loginToken;
    }

    public static void checkSQLInject(String sql) throws Exception {
        for (int i = 0; i < injStra.length; ++i) {
            if (sql.indexOf(injStra[i]) == -1) continue;
            throw new Exception("sql is invalid");
        }
    }

    private static String objectToString(Object object) {
        StringBuilder b = new StringBuilder();
        if (object != null) {
            if (object instanceof Map) {
                Map tmp = (Map)object;
                Iterator iterator = tmp.entrySet().iterator();
                b.append("[");
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    b.append((String)entry.getKey());
                    b.append(":");
                    b.append(CommonUtil.objectToString(entry.getValue()));
                    b.append(",");
                }
                b.append("]");
            } else {
                b.append(object);
            }
        }
        return b.toString();
    }

    public static String[] findFirstTagContent(String content, String startTag, String endTag) {
        if (CommonUtil.isEmpty(content)) {
            return new String[]{EMPTY_STR};
        }
        int imgStartIndex = content.indexOf(startTag);
        if (imgStartIndex != -1) {
            String part1 = content.substring(0, imgStartIndex);
            String part2 = content.substring(imgStartIndex + startTag.length());
            int endTagIndex = part2.indexOf(endTag);
            if (endTagIndex != -1) {
                String tagContent = startTag + part2.substring(0, endTagIndex + endTag.length());
                String part3 = part2.substring(endTagIndex + endTag.length());
                return new String[]{part1, tagContent, part3};
            }
        }
        return new String[]{content};
    }

    public static List<String> getOccupationParanames(String content, String startTag, String endTag) {
        ArrayList<String> result = new ArrayList<String>();
        if (CommonUtil.isEmpty(content)) {
            return result;
        }
        int imgStartIndex = content.indexOf(startTag);
        while (imgStartIndex != -1) {
            String part2 = content.substring(imgStartIndex + startTag.length());
            int endTagIndex = part2.indexOf(endTag);
            if (endTagIndex == -1) continue;
            String tagContent = part2.substring(0, endTagIndex);
            result.add(tagContent);
            content = part2.substring(endTagIndex + endTag.length());
            imgStartIndex = content.indexOf(startTag);
        }
        return result;
    }

    public static String encodeLong(long val) {
        StringBuilder result = new StringBuilder();
        int x = CHARACTERS.length;
        long quotient = val / (long)x;
        long remainder = val % (long)x;
        result.append(CHARACTERS[(int)remainder]);
        if (quotient < (long)x) {
            if (quotient != 0L) {
                result.append(CHARACTERS[(int)quotient]);
            }
            result = result.reverse();
            return result.toString();
        }
        while (quotient >= (long)x) {
            val = quotient;
            quotient = val / (long)x;
            remainder = val % (long)x;
            result.append(CHARACTERS[(int)remainder]);
        }
        if (quotient != 0L) {
            result.append(CHARACTERS[(int)quotient]);
        }
        result = result.reverse();
        return result.toString();
    }

    public static List<String> convertStringArrayToList(String[] array) {
        if (array == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String tmp : array) {
            if (CommonUtil.isEmpty(tmp)) continue;
            result.add(tmp);
        }
        return result;
    }

    public static String replace(String source, Map<String, Object> parameter, String prefix, String suffix, boolean enableSubstitutionInVariables) {
        StrSubstitutor strSubstitutor = new StrSubstitutor(parameter, prefix, suffix);
        strSubstitutor.setEnableSubstitutionInVariables(enableSubstitutionInVariables);
        return strSubstitutor.replace(source);
    }

    public static String wrapText(String orignalText, Map<String, Object> params) {
        return CommonUtil.replace(orignalText, params, "${", "}", false);
    }

    public static String buildCacheKey(Object ... args) {
        Assert.notNull(args, "args is empty");
        StringBuilder b = new StringBuilder();
        for (Object object : args) {
            b.append("-");
            b.append(CommonUtil.objectToString(object));
        }
        return b.toString();
    }

    public static MethodMeta getMethodMeta(Class<?> clz, Method method) throws Exception {
        String cacheKey;
        Object cachedObj;
        String methodName = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        int hashCode = clz.getName().hashCode() * 31 + methodName.hashCode();
        if (parameterTypes != null) {
            for (Class<?> tmp : parameterTypes) {
                hashCode = hashCode * 31 + tmp.getName().hashCode();
            }
        }
        if ((cachedObj = LocalCacheUtil.get(cacheKey = String.valueOf(hashCode))) != null) {
            return (MethodMeta)cachedObj;
        }
        LinkedHashMap<String, Integer> paraMaps = new LinkedHashMap<String, Integer>();
        ClassPool pool = ClassPool.getDefault();
        String proxyClassName = clz.getName();
        int cglibTag = proxyClassName.indexOf("$$");
        String origClassName = null;
        origClassName = cglibTag != -1 ? proxyClassName.substring(0, proxyClassName.indexOf("$$")) : proxyClassName;
        CtClass ctClass = pool.get(origClassName);
        CtMethod cm = ctClass.getDeclaredMethod(methodName);
        MethodInfo methodInfo = cm.getMethodInfo();
        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        LocalVariableAttribute attr = (LocalVariableAttribute)codeAttribute.getAttribute("LocalVariableTable");
        String[] paramNames = new String[cm.getParameterTypes().length];
        int pos = Modifier.isStatic(cm.getModifiers()) ? 0 : 1;
        for (int j = 0; j < paramNames.length; ++j) {
            paramNames[j] = attr.variableName(j + pos);
        }
        for (int i = 0; i < paramNames.length; ++i) {
            paraMaps.put(paramNames[i], i);
        }
        ReturnClassType returnClassType = null;
        Type[] argumentsOfReturnClass = null;
        Type type = method.getGenericReturnType();
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            if (parameterizedType.getRawType() == List.class) {
                returnClassType = ReturnClassType.LIST;
                argumentsOfReturnClass = parameterizedType.getActualTypeArguments();
            } else {
                returnClassType = ReturnClassType.OTHERS;
            }
        } else {
            returnClassType = ReturnClassType.POJO;
        }
        MethodMeta methodMeta = new MethodMeta(paraMaps, returnClassType, argumentsOfReturnClass, type, cacheKey, parameterTypes, method.getParameterAnnotations());
        LocalCacheUtil.put(cacheKey, methodMeta);
        return methodMeta;
    }

    public static MethodMeta getInterfaceMeta(Class<?> interfaceClz, Method method) throws Exception {
        String cacheKey;
        Object cachedObj;
        String methodName = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        int hashCode = interfaceClz.getName().hashCode() * 31 + methodName.hashCode();
        if (parameterTypes != null) {
            for (Class<?> tmp : parameterTypes) {
                hashCode = hashCode * 31 + tmp.getName().hashCode();
            }
        }
        if ((cachedObj = LocalCacheUtil.get(cacheKey = String.valueOf(hashCode))) != null) {
            return (MethodMeta)cachedObj;
        }
        LinkedHashMap<String, Integer> paraMaps = new LinkedHashMap<String, Integer>();
        ReturnClassType returnClassType = null;
        Type[] argumentsOfReturnClass = null;
        Type type = method.getGenericReturnType();
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            if (parameterizedType.getRawType() == List.class) {
                returnClassType = ReturnClassType.LIST;
                argumentsOfReturnClass = parameterizedType.getActualTypeArguments();
            } else {
                returnClassType = ReturnClassType.OTHERS;
            }
        } else {
            returnClassType = ReturnClassType.POJO;
        }
        MethodMeta methodMeta = new MethodMeta(paraMaps, returnClassType, argumentsOfReturnClass, type, cacheKey, parameterTypes, method.getParameterAnnotations());
        LocalCacheUtil.put(cacheKey, methodMeta);
        return methodMeta;
    }

    public static Method[] getDeclaredMethods(Class<?> clz) throws Exception {
        String cacheKey = "getDeclaredMethods-" + clz.getName();
        Method[] cachedObj = LocalCacheUtil.get(cacheKey);
        if (cachedObj == null) {
            cachedObj = clz.getDeclaredMethods();
            LocalCacheUtil.put(cacheKey, cachedObj);
        }
        return cachedObj;
    }

    public static Object getEmbededAttributeValue(Object object, String[] fieldArray) throws Exception {
        Field field = null;
        for (int i = 1; i < fieldArray.length; ++i) {
            field = CommonUtil.getField(object.getClass(), fieldArray[i]);
            if (field == null) {
                return null;
            }
            field.setAccessible(true);
            object = field.get(object);
            if (object != null) continue;
            return null;
        }
        return object;
    }

    public static Field getField(Class classType, String fieldName) {
        if (classType == Object.class) {
            return null;
        }
        String cacheKey = "getField-" + classType.getName() + fieldName;
        Field field = (Field)LocalCacheUtil.get(cacheKey);
        if (field != null) {
            return field;
        }
        while (field == null) {
            try {
                field = classType.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                if ((classType = classType.getSuperclass()) != null && classType != Object.class) continue;
                break;
            }
        }
        if (field != null) {
            LocalCacheUtil.put(cacheKey, field);
        }
        return field;
    }

    public static String getAllFieldsAsString(Class<? extends Object> clazz) {
        Field[] fields;
        String cacheKey = "getField-as-str" + clazz.getName();
        String cachedStr = (String)LocalCacheUtil.get(cacheKey);
        if (cachedStr != null) {
            return cachedStr;
        }
        TreeSet<String> fieldsNameSet = new TreeSet<String>();
        for (Field tmp : fields = clazz.getDeclaredFields()) {
            fieldsNameSet.add(tmp.getName());
        }
        for (clazz = clazz.getSuperclass(); clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Field tmp : fields = clazz.getDeclaredFields()) {
                fieldsNameSet.add(tmp.getName());
            }
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (String fieldName : fieldsNameSet) {
            if (i != 0) {
                sb.append("_");
            }
            sb.append("${");
            sb.append(fieldName);
            sb.append("}");
            ++i;
        }
        String result = sb.toString();
        if (result != EMPTY_STR) {
            LocalCacheUtil.put(cacheKey, result);
        }
        return result;
    }

    public static Map<String, Field> getAllFields(Class<? extends Object> clazz) {
        Field[] fields;
        String cacheKey = "getAllFields" + clazz.getName();
        Object cachedObject = LocalCacheUtil.get(cacheKey);
        if (cachedObject != null) {
            return (Map)cachedObject;
        }
        HashMap<String, Field> fieldsMap = new HashMap<String, Field>();
        for (Field tmp : fields = clazz.getDeclaredFields()) {
            fieldsMap.put(tmp.getName(), tmp);
        }
        for (clazz = clazz.getSuperclass(); clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Field tmp : fields = clazz.getDeclaredFields()) {
                fieldsMap.put(tmp.getName(), tmp);
            }
        }
        if (fieldsMap.size() != 0) {
            LocalCacheUtil.put(cacheKey, fieldsMap);
        }
        return fieldsMap;
    }

    public static Date now() {
        return Calendar.getInstance(TimeZone.getTimeZone("GMT-8:00")).getTime();
    }

    public static Date toDate(Long milliseconds) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT-8:00"));
        calendar.setTimeInMillis(milliseconds);
        return calendar.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mergeFiles(String[] filePaths, String targetFolder, String targetFileName) {
        File file = null;
        file = new File(targetFolder);
        if (!file.exists()) {
            file.mkdirs();
        } else if (!file.isDirectory()) {
            throw new RuntimeException("targetFolder is file");
        }
        File targetFile = new File(file.getAbsolutePath() + "/" + targetFileName);
        FileOutputStream fos = null;
        FileInputStream fis = null;
        try {
            fos = new FileOutputStream(targetFile);
            for (String filePath : filePaths) {
                file = new File(filePath);
                fis = new FileInputStream(file);
                int buffersize = 512;
                byte[] buffer = new byte[buffersize];
                int available = 0;
                while ((available = fis.read(buffer, 0, buffersize)) != -1) {
                    fos.write(buffer, 0, available);
                }
                fos.write(13);
                fos.write(10);
                fos.flush();
                fis.close();
                fis = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            CommonUtil.closeQuietly(fis);
            CommonUtil.closeQuietly(fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] zip(byte[] data) {
        byte[] b = null;
        ByteArrayOutputStream bos = null;
        ZipOutputStream zip = null;
        ZipEntry entry = null;
        try {
            bos = new ByteArrayOutputStream();
            zip = new ZipOutputStream(bos);
            entry = new ZipEntry("zip");
            entry.setSize(data.length);
            zip.putNextEntry(entry);
            zip.write(data);
            b = bos.toByteArray();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                zip.closeEntry();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                zip.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            CommonUtil.closeQuietly(bos);
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] gzip(byte[] data) throws UnsupportedEncodingException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream gzip = null;
        try {
            gzip = new GZIPOutputStream(out);
            gzip.write(data);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                CommonUtil.closeQuietly(gzip);
                throw throwable;
            }
            CommonUtil.closeQuietly(gzip);
        }
        CommonUtil.closeQuietly(gzip);
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] ungzip(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        GZIPInputStream ungzip = null;
        try {
            int n;
            ungzip = new GZIPInputStream(in);
            byte[] buffer = new byte[256];
            while ((n = ungzip.read(buffer)) >= 0) {
                out.write(buffer, 0, n);
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                CommonUtil.closeQuietly(ungzip);
                CommonUtil.closeQuietly(in);
                throw throwable;
            }
            CommonUtil.closeQuietly(ungzip);
            CommonUtil.closeQuietly(in);
        }
        CommonUtil.closeQuietly(ungzip);
        CommonUtil.closeQuietly(in);
        return out.toByteArray();
    }
}

