/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.core;

import cn.regionsoft.one.annotation.InstanceAnoType;
import cn.regionsoft.one.annotation.NoInstanceAnoType;
import cn.regionsoft.one.core.CommonUtil;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AnnotatedClassHub {
    private Map<Class<? extends Annotation>, HashSet<Class<?>>> noInstanceMap = new HashMap();
    private Map<Class<? extends Annotation>, HashSet<Class<?>>> instanceMap = new HashMap();
    private boolean isInited = false;

    public Set<Class<?>> init(HashSet<Class<?>> contextClasses, String contextName) {
        HashSet needInstanceClass = new HashSet();
        if (!this.isInited) {
            this.isInited = true;
            for (Class<?> tmp : contextClasses) {
                if (!contextName.equals(CommonUtil.getTargetContextName(tmp))) continue;
                this.resolveXFrameAno(tmp, needInstanceClass);
            }
        }
        return needInstanceClass;
    }

    private void resolveXFrameAno(Class<?> classType, Set<Class<?>> needInstanceClassPara) {
        HashSet<Class<Object>> classSet;
        Class<? extends Annotation> anoClass = null;
        Annotation annotation = null;
        for (InstanceAnoType instanceAnoType : InstanceAnoType.values()) {
            annotation = classType.getDeclaredAnnotation(instanceAnoType.getClassType());
            if (annotation == null) continue;
            anoClass = annotation.annotationType();
            needInstanceClassPara.add(classType);
            classSet = this.instanceMap.get(anoClass);
            if (classSet == null) {
                classSet = new HashSet();
                this.instanceMap.put(anoClass, classSet);
            }
            classSet.add(classType);
            this.resolveXFrameAno(anoClass, needInstanceClassPara);
        }
        for (Enum enum_ : NoInstanceAnoType.values()) {
            annotation = classType.getDeclaredAnnotation(((NoInstanceAnoType)enum_).getClassType());
            if (annotation == null) continue;
            anoClass = annotation.annotationType();
            classSet = this.noInstanceMap.get(anoClass);
            if (classSet == null) {
                classSet = new HashSet();
                this.noInstanceMap.put(anoClass, classSet);
            }
            classSet.add(classType);
            this.resolveXFrameAno(anoClass, needInstanceClassPara);
        }
    }

    public HashSet<Class<?>> getClassSetByAnnotation(InstanceAnoType instanceAnoType) {
        return this.instanceMap.get(instanceAnoType.getClassType());
    }

    public HashSet<Class<?>> getClassSetByAnnotation(NoInstanceAnoType noInstanceAnoType) {
        return this.noInstanceMap.get(noInstanceAnoType.getClassType());
    }
}

