/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.common;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TreeUtil {
    public static Map resolvePlainLsAsTreeMap(List treeNodeList, String nodeIdAttr, String parentIdAttr, String childsLsAttr, String parentAttr) {
        try {
            Class<?> idClassType = null;
            LinkedHashMap treeMap = new LinkedHashMap();
            for (Object e : treeNodeList) {
                Object fieldVal = TreeUtil.getObjFieldValue(e, nodeIdAttr);
                if (idClassType == null) {
                    idClassType = fieldVal.getClass();
                }
                treeMap.put(fieldVal, e);
            }
            for (Map.Entry entry : treeMap.entrySet()) {
                Object treeNode = entry.getValue();
                Object parentId = TreeUtil.getObjFieldValue(treeNode, parentIdAttr);
                boolean notRootNode = false;
                if (parentId == null) {
                    notRootNode = false;
                } else if (parentId.getClass() == String.class) {
                    notRootNode = !parentId.equals("0");
                } else if (parentId.getClass() == Long.class) {
                    boolean bl = notRootNode = !parentId.equals(0);
                }
                if (!notRootNode) continue;
                Object parentNode = treeMap.get(parentId);
                TreeUtil.setObjFieldValue(treeNode, parentAttr, parentNode);
                ArrayList childs = (ArrayList)TreeUtil.getObjFieldValue(parentNode, childsLsAttr);
                if (childs == null) {
                    childs = new ArrayList();
                    TreeUtil.setObjFieldValue(parentNode, childsLsAttr, childs);
                }
                childs.add(treeNode);
            }
            return treeMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void setObjFieldValue(Object target, String fieldNM, Object value) throws Exception {
        try {
            Field field = TreeUtil.getFieldByFieldName(target.getClass(), fieldNM);
            field.setAccessible(true);
            field.set(target, value);
        }
        catch (NoSuchFieldException e) {
            throw new Exception(e);
        }
    }

    public static Object getObjFieldValue(Object target, String fieldNM) throws Exception {
        try {
            Field field = TreeUtil.getFieldByFieldName(target.getClass(), fieldNM);
            field.setAccessible(true);
            return field.get(target);
        }
        catch (NoSuchFieldException e) {
            throw new Exception(e);
        }
    }

    public static Field getFieldByFieldName(Class<?> classType, String fieldNM) throws NoSuchFieldException, SecurityException {
        try {
            return classType.getDeclaredField(fieldNM);
        }
        catch (NoSuchFieldException e) {
            if (classType == Object.class) {
                throw new NoSuchFieldException(fieldNM);
            }
            return classType.getSuperclass().getDeclaredField(fieldNM);
        }
    }
}

