/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.common;

import cn.regionsoft.one.core.CommonUtil;
import cn.regionsoft.one.core.LogDepthManager;
import cn.regionsoft.one.core.RequestInfoHolder;
import cn.regionsoft.one.core.SystemContext;
import cn.regionsoft.one.core.aop.BackendErrorLogInterceptor;
import cn.regionsoft.one.core.auth.dto.RequestInfoDto;
import cn.regionsoft.one.core.exception.BizException;
import cn.regionsoft.one.core.logger.CustomizedClassloaderUtil;
import cn.regionsoft.one.properties.ConfigUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import org.apache.logging.log4j.LogManager;

public class Logger {
    public static final int OPTYPE_C = 0;
    public static final int OPTYPE_R = 1;
    public static final int OPTYPE_U = 2;
    public static final int OPTYPE_D = 3;
    public static final int OPTYPE_C_ED = 4;
    public static final int OPTYPE_U_ED = 5;
    public static final int OPTYPE_D_ED = 6;
    public static final int OPTYPE_R_CACHE = 7;
    public static final int OPTYPE_R_DB = 8;
    public static final int OPTYPE_RAMOUNT = 13;
    public static final int OPTYPE_RAMOUNT_CACHE_ED = 14;
    public static final int OPTYPE_RAMOUNT_DB_ED = 15;
    public static final int OPTYPE_RLS = 16;
    public static final int OPTYPE_RLS_CACHE_ED = 17;
    public static final int OPTYPE_RLS_DB_ED = 18;
    public static boolean specialLogEnabled = true;
    private Object logInstance;
    private static LogDepthManager logDepthManager = LogDepthManager.getInstance();

    public static Logger getLogger(Class<?> clazz) {
        return new Logger(clazz);
    }

    private Logger(Class<?> clazz) {
        try {
            String loggerMode = ConfigUtil.getProperty("logger.proxy");
            this.logInstance = Boolean.valueOf(loggerMode).booleanValue() ? CustomizedClassloaderUtil.invokeMethod("getLogger", clazz) : LogManager.getLogger(clazz);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debug(Object ... objs) {
        try {
            logDepthManager.enterLog();
            if (logDepthManager.getLogDepth() > 3) {
                return;
            }
            BackendErrorLogInterceptor in = SystemContext.getInstance().getBackendErrorLogInterceptor();
            boolean logToFile = true;
            if (in != null) {
                logToFile = in.debug(objs);
            }
            if (!logToFile) {
                return;
            }
            StringBuilder buf = new StringBuilder();
            buf.append(this.lineNumber());
            for (Object obj : objs) {
                if (obj instanceof Throwable) {
                    buf.append(this.constructStackTrace((Throwable)obj));
                    continue;
                }
                if (obj instanceof Object[]) {
                    buf.append("[");
                    Object[] array = (Object[])obj;
                    for (int i = 0; i < array.length; ++i) {
                        buf.append(array[i]);
                        if (i == array.length - 1) continue;
                        buf.append(",");
                    }
                    buf.append("]");
                    continue;
                }
                buf.append(obj);
            }
            Logger.invokeLogManager(this.logInstance, "debug", buf.toString());
        }
        finally {
            logDepthManager.exitLog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(Object ... objs) {
        try {
            logDepthManager.enterLog();
            if (logDepthManager.getLogDepth() > 3) {
                return;
            }
            BackendErrorLogInterceptor in = SystemContext.getInstance().getBackendErrorLogInterceptor();
            boolean logToFile = true;
            if (in != null) {
                logToFile = in.error(objs);
            }
            if (!logToFile) {
                return;
            }
            StringBuilder buf = new StringBuilder();
            buf.append(this.lineNumber());
            boolean bizException = false;
            for (Object obj : objs) {
                if (obj instanceof Throwable) {
                    if (obj instanceof BizException) {
                        bizException = true;
                    }
                    buf.append(this.constructStackTrace((Throwable)obj));
                    continue;
                }
                if (obj instanceof Object[]) {
                    buf.append("[");
                    Object[] array = (Object[])obj;
                    for (int i = 0; i < array.length; ++i) {
                        buf.append(array[i]);
                        if (i == array.length - 1) continue;
                        buf.append(",");
                    }
                    buf.append("]");
                    continue;
                }
                buf.append(obj);
            }
            if (bizException) {
                Logger.invokeLogManager(this.logInstance, "warn", buf.toString());
            } else {
                Logger.invokeLogManager(this.logInstance, "error", buf.toString());
            }
        }
        finally {
            logDepthManager.exitLog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void info(Object ... objs) {
        try {
            logDepthManager.enterLog();
            if (logDepthManager.getLogDepth() > 3) {
                return;
            }
            BackendErrorLogInterceptor in = SystemContext.getInstance().getBackendErrorLogInterceptor();
            boolean logToFile = true;
            if (in != null) {
                logToFile = in.info(objs);
            }
            if (!logToFile) {
                return;
            }
            StringBuilder buf = new StringBuilder();
            buf.append(this.lineNumber());
            for (Object obj : objs) {
                if (obj instanceof Throwable) {
                    buf.append(this.constructStackTrace((Throwable)obj));
                    continue;
                }
                if (obj instanceof Object[]) {
                    buf.append("[");
                    Object[] array = (Object[])obj;
                    for (int i = 0; i < array.length; ++i) {
                        buf.append(array[i]);
                        if (i == array.length - 1) continue;
                        buf.append(",");
                    }
                    buf.append("]");
                    continue;
                }
                buf.append(obj);
            }
            Logger.invokeLogManager(this.logInstance, "info", buf.toString());
        }
        finally {
            logDepthManager.exitLog();
        }
    }

    private String constructStackTrace(Throwable t) {
        try {
            if (t instanceof BizException) {
                return t.getMessage();
            }
            return Logger.getStackTrace(t);
        }
        catch (Exception e) {
            Logger.invokeLogManager(this.logInstance, "error", e.getMessage());
            return e.getMessage();
        }
    }

    public static String getStackTrace(Throwable aThrowable) throws RuntimeException {
        String string;
        StringWriter stack = null;
        PrintWriter printWriter = null;
        try {
            stack = new StringWriter();
            printWriter = new PrintWriter(stack);
            aThrowable.printStackTrace(printWriter);
            string = ((Object)stack).toString();
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonUtil.closeQuietly(printWriter);
                CommonUtil.closeQuietly(stack);
                throw throwable;
            }
        }
        CommonUtil.closeQuietly(printWriter);
        CommonUtil.closeQuietly(stack);
        return string;
    }

    private String lineNumber() {
        StackTraceElement[] threadTrackArray;
        RequestInfoDto requestInfoDto = RequestInfoHolder.getInstance().getRequestInfo();
        String reqId = null;
        if (requestInfoDto != null) {
            reqId = requestInfoDto.getRequestId();
        }
        if ((threadTrackArray = Thread.currentThread().getStackTrace()).length > 3) {
            return ":" + Integer.toString(threadTrackArray[3].getLineNumber()) + "- [requestId:" + reqId + "] ";
        }
        return " [requestId:" + reqId + "] ";
    }

    public static void invokeLogManager(Object logManager, String methodName, Object ... args) {
        Method[] methods;
        block2: for (Method method : methods = logManager.getClass().getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            if (args == null) {
                args = new Object[]{};
            }
            if (method.getParameterCount() != args.length) continue;
            Class<?>[] paraTypes = method.getParameterTypes();
            for (int i = 0; i < paraTypes.length; ++i) {
                if (paraTypes[i] != args[i].getClass()) continue block2;
            }
            try {
                method.invoke(logManager, args);
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
    }

    public void warn(Exception e) {
        Logger.invokeLogManager(this.logInstance, "warn", e.getMessage());
    }

    public void warn(String msg) {
        Logger.invokeLogManager(this.logInstance, "warn", msg);
    }
}

