/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.common;

import cn.regionsoft.one.core.CommonUtil;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JsonUtil {
    public static ObjectMapper readMapper = new ObjectMapper();
    public static ObjectMapper writerMapper = new ObjectMapper();

    public static <T> T parseToObject(InputStream is, Class<T> toClass) {
        try {
            return (T)readMapper.readValue(is, toClass);
        }
        catch (Exception var3) {
            var3.printStackTrace();
            throw new RuntimeException(var3);
        }
    }

    public static <T> T parseToObject(byte[] b, int offset, int len, Class<T> valueType) {
        try {
            return (T)readMapper.readValue(b, offset, len, valueType);
        }
        catch (Exception var5) {
            var5.printStackTrace();
            throw new RuntimeException(var5);
        }
    }

    public static <T> T parseToObject(String json, Class<T> toClass) {
        try {
            return (T)(CommonUtil.isEmpty(json) ? null : readMapper.readValue(json, toClass));
        }
        catch (Exception var3) {
            var3.printStackTrace();
            throw new RuntimeException(var3);
        }
    }

    public static String getNodeValue(String json, String fieldName) {
        try {
            if (CommonUtil.isEmpty(json)) {
                return null;
            }
            if (fieldName == null) {
                return json;
            }
            JsonNode node = readMapper.readTree(json);
            JsonNode fnode = node.path(fieldName);
            return fnode.toString();
        }
        catch (Exception var4) {
            var4.printStackTrace();
            throw new RuntimeException(var4);
        }
    }

    public static <T> T parseToObject(String json, String fieldName, Class<T> toClass) {
        return JsonUtil.parseToObject(JsonUtil.getNodeValue(json, fieldName), toClass);
    }

    public static Map parseToMap(String json) {
        return JsonUtil.parseToObject(json, Map.class);
    }

    public static Map parseToMap(byte[] b) {
        return b != null && b.length != 0 ? JsonUtil.parseToObject(b, 0, b.length, Map.class) : null;
    }

    public static Map parseToMap(InputStream is) {
        return JsonUtil.parseToObject(is, Map.class);
    }

    public static Map parseToMap(Object o) {
        String oJson = JsonUtil.parseToJson(o);
        return JsonUtil.parseToObject(oJson, Map.class);
    }

    public static String parseToJson(Object o) {
        return JsonUtil.parseToJson(o, false);
    }

    public static String parseToJson(Object o, boolean ignoreNull) {
        if (o == null) {
            return null;
        }
        try {
            return writerMapper.writeValueAsString(o);
        }
        catch (Exception var4) {
            var4.printStackTrace();
            throw new RuntimeException(var4);
        }
    }

    public static <T> String listToJson(List<T> list) {
        try {
            String jsonStr = readMapper.writeValueAsString(list);
            return jsonStr;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> List<T> jsonToList(String json, Class<T> clz) {
        try {
            JavaType javaType = JsonUtil.getCollectionType(ArrayList.class, clz);
            List result = (List)readMapper.readValue(json, javaType);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static JavaType getCollectionType(Class<?> collectionClass, Class<?> ... elementClasses) {
        return readMapper.getTypeFactory().constructParametricType(collectionClass, (Class[])elementClasses);
    }

    public static <T> T jsonToBean(String json, Class<T> toClass) {
        return JsonUtil.parseToObject(json, toClass);
    }

    public static <T> T jsonToBeanDateSerializer(String json, Class<T> toClass, String dateFormat1) {
        return JsonUtil.parseToObject(json, toClass);
    }

    public static String objectToJson(Object object) {
        return JsonUtil.parseToJson(object);
    }

    public static String objectToJsonDateSerializer(Object object, String dateFormat1) {
        return JsonUtil.parseToJson(object);
    }

    public static Object[] jsonToArray(String json) {
        return JsonUtil.parseToObject(json, Object[].class);
    }

    public static Map jsonToMap(String json) {
        return JsonUtil.parseToObject(json, Map.class);
    }

    static {
        readMapper.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
        readMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        readMapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        writerMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        writerMapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
        writerMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        writerMapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
    }
}

