/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.common;

import cn.regionsoft.one.core.CommonUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class GsonUtil {
    private static Gson gson = null;

    private GsonUtil() {
    }

    public static String objectToJson(Object ts) {
        String jsonStr = null;
        if (gson != null) {
            jsonStr = gson.toJson(ts);
        }
        return jsonStr;
    }

    public static String objectToJsonDateSerializer(Object ts, String dateformatPattern) {
        String jsonStr = null;
        final SimpleDateFormat format = CommonUtil.getSimpleDateFormat(dateformatPattern);
        gson = new GsonBuilder().registerTypeHierarchyAdapter(Date.class, (Object)new JsonSerializer<Date>(){

            public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(format.format(src));
            }
        }).setDateFormat(dateformatPattern).create();
        if (gson != null) {
            jsonStr = gson.toJson(ts);
        }
        return jsonStr;
    }

    public static <T> List<T> jsonToList(String jsonStr, Class<T> classType) {
        ArrayList<Object> result = new ArrayList<Object>();
        List objList = null;
        if (gson != null) {
            Type type = new TypeToken<List<?>>(){}.getType();
            objList = (List)gson.fromJson(jsonStr, type);
        }
        if (classType != null) {
            for (Object a : objList) {
                Map ltm = (Map)a;
                Object tmp = null;
                try {
                    tmp = GsonUtil.wrapLinkedTreeMap(ltm, classType);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (tmp == null) continue;
                result.add(tmp);
            }
        }
        return result;
    }

    public static Object wrapLinkedTreeMap(Map src, Class classType) throws Exception {
        return GsonUtil.wrapLinkedTreeMap(src, classType, "yyyy-MM-dd HH:mm:ss");
    }

    public static Object wrapLinkedTreeMap(Map src, Class classType, String dateFormat) throws Exception {
        Field[] fileds;
        Map ltm = src;
        Object classInstance = classType.newInstance();
        for (Class superClass = classType.getSuperclass(); superClass != Object.class && superClass != null; superClass = superClass.getSuperclass()) {
            Field[] filedsOfSuperClass;
            for (Field f : filedsOfSuperClass = superClass.getDeclaredFields()) {
                GsonUtil.handleField(ltm, f, classInstance, dateFormat);
            }
        }
        for (Field f : fileds = classType.getDeclaredFields()) {
            GsonUtil.handleField(ltm, f, classInstance, dateFormat);
        }
        return classInstance;
    }

    private static void handleField(Map ltm, Field f, Object classInstance, String dateFormat) throws NumberFormatException, IllegalArgumentException, IllegalAccessException, ParseException, Exception {
        SimpleDateFormat sdf = CommonUtil.getSimpleDateFormat(dateFormat);
        if (ltm.containsKey(f.getName())) {
            f.setAccessible(true);
            Object filedVal = ltm.get(f.getName());
            if (f.get(classInstance) instanceof List) {
                ArrayList<Object> tR = new ArrayList<Object>();
                for (Map x : (List)filedVal) {
                    tR.add(GsonUtil.wrapLinkedTreeMap(x, (Class)((ParameterizedType)f.getGenericType()).getActualTypeArguments()[0]));
                }
                f.set(classInstance, tR);
            } else if (f.getType().equals(String.class)) {
                if (filedVal.getClass().equals(Long.class)) {
                    f.set(classInstance, String.valueOf(filedVal));
                } else if (filedVal.getClass().equals(Double.class)) {
                    long l = Math.round((Double)filedVal);
                    f.set(classInstance, String.valueOf(l));
                } else {
                    f.set(classInstance, filedVal);
                }
            } else if (f.getType().equals(Integer.class)) {
                Object value = filedVal;
                if (value.getClass().equals(Double.class)) {
                    f.set(classInstance, ((Double)filedVal).intValue());
                } else if (value.getClass().equals(Integer.class)) {
                    f.set(classInstance, filedVal);
                } else if (value.getClass().equals(Long.class)) {
                    f.set(classInstance, ((Long)filedVal).intValue());
                } else {
                    f.set(classInstance, filedVal);
                }
            } else if (f.getType().equals(Long.class)) {
                Object value = filedVal;
                if (value.getClass().equals(Double.class)) {
                    f.set(classInstance, Long.parseLong(String.valueOf(Math.round((Double)filedVal))));
                } else if (value.getClass().equals(Long.class)) {
                    f.set(classInstance, filedVal);
                } else if (value.getClass().equals(String.class)) {
                    f.set(classInstance, Long.valueOf((String)value));
                } else {
                    f.set(classInstance, filedVal);
                }
            } else if (f.getType().equals(Date.class)) {
                f.set(classInstance, sdf.parse((String)filedVal));
            } else {
                f.set(classInstance, filedVal);
            }
        }
    }

    public static Object[] jsonToArray(String jsonStr) {
        Object[] objMap = null;
        if (gson != null) {
            Type type = new TypeToken<Object[]>(){}.getType();
            objMap = (Object[])gson.fromJson(jsonStr, type);
        }
        return objMap;
    }

    public static <T, X> Map<T, X> jsonToMap(String jsonStr) {
        Map objMap = null;
        if (gson != null) {
            Type type = new TypeToken<Map<T, X>>(){}.getType();
            objMap = (Map)gson.fromJson(jsonStr, type);
        }
        return objMap;
    }

    public static <T> T jsonToBean(String jsonStr, Class<T> cl) {
        Object obj = null;
        if (gson != null) {
            obj = gson.fromJson(jsonStr, cl);
        }
        return (T)obj;
    }

    public static <T> T jsonToBeanDateSerializer(String jsonStr, Class<T> cl, final String pattern) {
        Object obj = null;
        gson = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new JsonDeserializer<Date>(){

            public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                SimpleDateFormat format = CommonUtil.getSimpleDateFormat(pattern);
                String dateStr = json.getAsString();
                try {
                    return format.parse(dateStr);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }).setDateFormat(pattern).create();
        if (gson != null) {
            obj = gson.fromJson(jsonStr, cl);
        }
        return (T)obj;
    }

    public static Object getJsonValue(String jsonStr, String key) {
        Object rulsObj = null;
        Map rulsMap = GsonUtil.jsonToMap(jsonStr);
        if (rulsMap != null && rulsMap.size() > 0) {
            rulsObj = rulsMap.get(key);
        }
        return rulsObj;
    }

    static {
        if (gson == null) {
            gson = new Gson();
        }
    }
}

