/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.common;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FreemarkerUtil {
    private static Configuration cfg = null;
    private static Map<String, Template> templateMap;

    public static Configuration getFreemarkerConfig() {
        return cfg;
    }

    public static boolean templateLoaded(String filePath) {
        return templateMap.containsKey(filePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fprint(String templateFileCacheKey, String name, Map<String, Object> paraMap, String outFile) {
        OutputStreamWriter out = null;
        try {
            out = new FileWriter(new File(outFile));
            Template temp = templateMap.get(templateFileCacheKey);
            if (temp == null) {
                temp = cfg.getTemplate(name, "UTF-8");
                templateMap.put(templateFileCacheKey, temp);
            }
            temp.process(paraMap, (Writer)out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        cfg = new Configuration(Configuration.VERSION_2_3_23);
        cfg.setDefaultEncoding("UTF-8");
        templateMap = new ConcurrentHashMap<String, Template>();
    }
}

